/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import components.ImageSelection;
import components.ImageTableModel;
import components.PictogramTableCellRenderer;
import configuration.TConfiguration;
import configuration.TLanguage;
import database.DB;
import database.ImageManager;
import dialogs.AddImageFrame;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class FindImageFrame
extends JDialog {
    private JPanel contentPane;
    private JTextField term1TextField;
    private JTextField term2TextField;
    private JTextField term3TextField;
    private JTextField imageNameTextField;
    private ImageTableModel imageTableModel;
    private String[] imageTableHeader;
    private JTable table;
    private JComboBox AndOr1ComboBox;
    private JComboBox AndOr2ComboBox;
    public static final int IS_INTEGRATED = 0;
    private int mode = -1;
    private String selectedImageName;
    private FindImageFrame mainFrame;
    private JButton btnBuscar;
    private JComboBox comboBox;
    private JLabel labelTotalImages;
    private JButton btnEliminarImgen;
    private JButton btnBuscar_1;
    private JButton btnCopiarImagenAl;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FindImageFrame frame = new FindImageFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public FindImageFrame(int mode) {
        this.mode = mode;
        this.init();
    }

    public FindImageFrame() {
        this.init();
    }

    private void init() {
        TLanguage.initLanguage(TConfiguration.getLanguage());
        this.imageTableHeader = new String[]{"", "", "", "", "", ""};
        this.mainFrame = this;
        this.setTitle(TLanguage.getString("FIND_IMAGE_FRAME.TITLE"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 720, 430);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.KEY_TERMS"), 4, 2, null, null));
        this.contentPane.add(panel);
        panel.setLayout(new FlowLayout(1, 5, 5));
        this.term1TextField = new JTextField();
        panel.add(this.term1TextField);
        this.term1TextField.setColumns(10);
        this.AndOr1ComboBox = new JComboBox();
        this.AndOr1ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("FIND_IMAGE_FRAME.AND"), TLanguage.getString("FIND_IMAGE_FRAME.OR")}));
        panel.add(this.AndOr1ComboBox);
        this.term2TextField = new JTextField();
        panel.add(this.term2TextField);
        this.term2TextField.setColumns(10);
        this.AndOr2ComboBox = new JComboBox();
        this.AndOr2ComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{TLanguage.getString("FIND_IMAGE_FRAME.AND"), TLanguage.getString("FIND_IMAGE_FRAME.OR")}));
        panel.add(this.AndOr2ComboBox);
        this.term3TextField = new JTextField();
        this.term3TextField.setColumns(10);
        panel.add(this.term3TextField);
        this.btnBuscar = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.FIND"));
        this.btnBuscar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FindImageFrame.this.term1TextField.getText().equals("")) {
                    String query = "SELECT GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name IN (SELECT main.name FROM main WHERE word LIKE '" + FindImageFrame.this.term1TextField.getText() + "'";
                    if (FindImageFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                        query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + FindImageFrame.this.comboBox.getSelectedItem().toString() + "')";
                    }
                    query = String.valueOf(query) + ")";
                    if (!FindImageFrame.this.term2TextField.getText().equals("")) {
                        query = String.valueOf(query) + (FindImageFrame.this.AndOr1ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        query = String.valueOf(query) + "main.name IN (SELECT main.name FROM main WHERE word LIKE '" + FindImageFrame.this.term2TextField.getText() + "'";
                        if (FindImageFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                            query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + FindImageFrame.this.comboBox.getSelectedItem().toString() + "')";
                        }
                        query = String.valueOf(query) + ")";
                    }
                    if (!FindImageFrame.this.term3TextField.getText().equals("")) {
                        query = String.valueOf(query) + (FindImageFrame.this.AndOr2ComboBox.getSelectedIndex() == 0 ? " AND " : " OR ");
                        query = String.valueOf(query) + "main.name IN (SELECT main.name FROM main WHERE word LIKE '" + FindImageFrame.this.term3TextField.getText() + "'";
                        if (FindImageFrame.this.comboBox.getSelectedItem().toString().compareTo("Todos") != 0) {
                            query = String.valueOf(query) + " AND idL = (SELECT id FROM language WHERE name LIKE '" + FindImageFrame.this.comboBox.getSelectedItem().toString() + "')";
                        }
                        query = String.valueOf(query) + ")";
                    }
                    query = String.valueOf(query) + " GROUP BY main.name";
                    try {
                        DB db = DB.getInstance();
                        ResultSet rs = db.query(query);
                        FindImageFrame.this.prepareTermsTable(rs);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        panel.add(this.btnBuscar);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.BY_IMAGE_NAME"), 4, 2, null, null));
        this.contentPane.add(panel_1);
        JLabel lblNombre = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.NAME"));
        panel_1.add(lblNombre);
        this.imageNameTextField = new JTextField();
        panel_1.add(this.imageNameTextField);
        this.imageNameTextField.setColumns(30);
        this.btnBuscar_1 = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.FIND"));
        this.btnBuscar_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FindImageFrame.this.imageNameTextField.getText().length() >= 3) {
                    try {
                        DB db = DB.getInstance();
                        String query = "SELECT GROUP_CONCAT(main.word) AS terms, main.nameNN AS name FROM main WHERE main.name LIKE '%" + FindImageFrame.this.imageNameTextField.getText() + "%' GROUP BY nameNN";
                        ResultSet rs = db.query(query);
                        FindImageFrame.this.prepareTermsTable(rs);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        panel_1.add(this.btnBuscar_1);
        JPanel panel_4 = new JPanel();
        this.contentPane.add(panel_4);
        JLabel lblIdiomaDeLa = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.LANGUAGE_OF_THE_SEARCH"));
        panel_4.add(lblIdiomaDeLa);
        this.comboBox = new JComboBox();
        this.comboBox.addItem("Todos");
        this.comboBox.setSelectedIndex(0);
        String query = "SELECT name FROM language ORDER BY id asc";
        try {
            ResultSet rs = DB.getInstance().query(query);
            int pos = 1;
            while (rs.next()) {
                this.comboBox.addItem(rs.getString("name"));
                if (rs.getString("name").compareTo(TConfiguration.getLanguage()) == 0) {
                    this.comboBox.setSelectedIndex(pos);
                }
                ++pos;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        panel_4.add(this.comboBox);
        JPanel panel_5 = new JPanel();
        this.contentPane.add(panel_5);
        JLabel lblTotalImgenesEncontradas = new JLabel(TLanguage.getString("FIND_IMAGE_FRAME.TOTAL_IMAGES_FOUND"));
        panel_5.add(lblTotalImgenesEncontradas);
        this.labelTotalImages = new JLabel("0");
        panel_5.add(this.labelTotalImages);
        JPanel panel_2 = new JPanel();
        panel_2.setLayout(new BorderLayout(0, 0));
        panel_2.setBorder(new TitledBorder(null, TLanguage.getString("FIND_IMAGE_FRAME.RESULTS"), 4, 2, null, null));
        this.contentPane.add(panel_2);
        this.imageTableModel = new ImageTableModel();
        this.table = new JTable(this.imageTableModel);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(String.class, new PictogramTableCellRenderer());
        this.table.setRowSelectionAllowed(false);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = FindImageFrame.this.table.getSelectedRow();
                int column = FindImageFrame.this.table.getSelectedColumn();
                String imageNameNN = ((ImageTableModel)FindImageFrame.this.table.getModel()).getImageName(row, column);
                FindImageFrame.this.selectedImageName = imageNameNN;
                if (FindImageFrame.this.selectedImageName != null && e.getClickCount() == 2) {
                    if (FindImageFrame.this.mode == 0) {
                        FindImageFrame.this.mainFrame.dispose();
                    } else {
                        AddImageFrame f = new AddImageFrame(imageNameNN);
                        f.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                FindImageFrame.this.updateSearch();
                            }
                        });
                        f.setVisible(true);
                        f.pack();
                    }
                }
            }
        });
        this.table.setRowHeight(100);
        this.table.setSize(new Dimension(500, 100));
        JScrollPane scrollPane = new JScrollPane(this.table);
        panel_2.add(scrollPane);
        JPanel panel_3 = new JPanel();
        this.contentPane.add(panel_3);
        if (this.mode == 0) {
            JButton btnInsertar = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.INSERT"));
            panel_3.add(btnInsertar);
            btnInsertar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (FindImageFrame.this.selectedImageName == null) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                    } else {
                        FindImageFrame.this.mainFrame.dispose();
                    }
                }
            });
        }
        JButton btnModificarImgen = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.MODIFY"));
        btnModificarImgen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FindImageFrame.this.selectedImageName == null) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                } else {
                    AddImageFrame f = new AddImageFrame(FindImageFrame.this.selectedImageName);
                    f.setModal(true);
                    f.setVisible(true);
                    f.pack();
                }
            }
        });
        panel_3.add(btnModificarImgen);
        this.btnEliminarImgen = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.DELETE"));
        this.btnEliminarImgen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Vector<String> data = ((ImageTableModel)FindImageFrame.this.table.getModel()).getDataNames();
                    int yesno = JOptionPane.showConfirmDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.REMOVE_SELECTED_IMAGES"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 0);
                    if (yesno == 0) {
                        int i = 0;
                        while (i < data.size()) {
                            String name = data.get(i).substring(data.get(i).lastIndexOf(File.separator) + 1);
                            String query = "DELETE FROM main WHERE nameNN LIKE '" + name + "'";
                            DB.getInstance().update(query);
                            ImageManager.delete(name);
                            ++i;
                        }
                        JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.IMAGE_REMOVED_CORRECTLY"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                        FindImageFrame.this.btnBuscar.doClick();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        panel_3.add(this.btnEliminarImgen);
        JButton btnCancelar = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.CANCEL"));
        btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FindImageFrame.this.mainFrame.dispose();
            }
        });
        this.btnCopiarImagenAl = new JButton(TLanguage.getString("FIND_IMAGE_FRAME.COPY_IMAGE"));
        this.btnCopiarImagenAl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (FindImageFrame.this.selectedImageName != null) {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        ImageIcon image = new ImageIcon(String.valueOf(DB.getInstance().getImagesPath()) + File.separator + FindImageFrame.this.selectedImageName);
                        ImageSelection dh = new ImageSelection(image.getImage());
                        cb.setContents(dh, null);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.ERROR_COPYING_IMAGE_TO_CLIPBOARD"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("FIND_IMAGE_FRAME.YOU_SHOULD_SELECT_AN_IMAGE"), TLanguage.getString("FIND_IMAGE_FRAME.AT_LEAST_THREE_CHARACTERS_WARNING_TITLE"), 2);
                }
            }
        });
        panel_3.add(this.btnCopiarImagenAl);
        panel_3.add(btnCancelar);
    }

    private void prepareTermsTable(ResultSet rs) {
        try {
            this.imageTableModel.setDataVector(null, this.imageTableHeader);
            String imagePath = DB.getInstance().getImagesPath();
            Vector<String> listNames = new Vector<String>();
            int totalImages = 0;
            while (rs.next()) {
                listNames.add(String.valueOf(imagePath) + File.separator + rs.getString("name"));
                ++totalImages;
            }
            this.labelTotalImages.setText(String.valueOf(totalImages));
            this.btnEliminarImgen.setText(String.valueOf(TLanguage.getString("FIND_IMAGE_FRAME.DELETE")) + " " + String.valueOf(totalImages));
            this.imageTableModel.setData(listNames);
            this.imageTableModel.fireTableDataChanged();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getSelectedImageName() {
        return this.selectedImageName;
    }

    public void updateSearch() {
        if (this.term1TextField.getText() != "") {
            this.btnBuscar.doClick();
        } else if (this.imageNameTextField.getText() != null) {
            this.btnBuscar_1.doClick();
        }
    }
}

