/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class TConfiguration {
    private static final String configPath = String.valueOf(File.separator) + "conf" + File.separator + "conf.properties";
    private static Properties p;
    private static String absolutePath;
    private static final String KEY_DATABASE = "database.name";
    private static final String VALUE_DATABASE;
    private static final String KEY_IMAGEPATH = "image.path";
    private static final String VALUE_IMAGEPATH;
    private static final String KEY_LANGUAGE = "language";
    private static final String VALUE_LANGUAGE = "Castellano";
    public static final String KEY_DATABASE_UPDATE_URL = "updateUrl";
    private static final String VALUE_DATABASE_UPDATE_URL = "http://arasaac.org/zona_descargas/arasuite/pictos_data";
    public static final String KEY_DB_RELEASE_DATE = "dbReleaseDate";

    static {
        VALUE_DATABASE = String.valueOf(File.separator) + "AraSuite.db";
        VALUE_IMAGEPATH = String.valueOf(File.separator) + "images";
    }

    public static String getDatabasePath() {
        return TConfiguration.getProperty(KEY_DATABASE);
    }

    public static String getImagesPath() {
        return TConfiguration.getProperty(KEY_IMAGEPATH);
    }

    public static String getLanguage() {
        return TConfiguration.getProperty(KEY_LANGUAGE);
    }

    public static String getAbsoultePath() {
        return absolutePath;
    }

    public static void setProperty(String key, String value) {
        try {
            TConfiguration.checkConfigurationFile();
            p.setProperty(key, value);
            File f = new File(String.valueOf(absolutePath) + configPath);
            p.store(new FileOutputStream(f), "Default properties created.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(String key) {
        TConfiguration.checkConfigurationFile();
        return p.getProperty(key);
    }

    private static void checkConfigurationFile() {
        if (p == null) {
            try {
                absolutePath = System.getProperty("os.name").toLowerCase().contains("win") ? String.valueOf(System.getProperty("user.home")) + File.separator + "arasuite" : (System.getProperty("os.name").toLowerCase().contains("mac") ? String.valueOf(System.getProperty("user.home")) + File.separator + ".arasuite" : String.valueOf(System.getProperty("user.home")) + File.separator + ".arasuite");
                System.out.println(absolutePath);
                System.out.println(String.valueOf(absolutePath) + configPath);
                File f = new File(String.valueOf(absolutePath) + configPath);
                if (!f.exists()) {
                    File w = new File(String.valueOf(absolutePath) + File.separator + "conf");
                    w.mkdirs();
                    System.out.println(w.getAbsolutePath());
                    System.out.println(f.getAbsolutePath());
                    f.createNewFile();
                    p = new Properties();
                    p.load(new FileInputStream(f));
                    p.setProperty(KEY_DATABASE, String.valueOf(absolutePath) + VALUE_DATABASE);
                    p.setProperty(KEY_IMAGEPATH, String.valueOf(absolutePath) + VALUE_IMAGEPATH);
                    p.setProperty(KEY_LANGUAGE, VALUE_LANGUAGE);
                    p.setProperty(KEY_DATABASE_UPDATE_URL, VALUE_DATABASE_UPDATE_URL);
                    p.store(new FileOutputStream(f), "Default properties created.");
                } else {
                    p = new Properties();
                    try {
                        p.load(new FileInputStream(new File(String.valueOf(absolutePath) + configPath)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void setLanguage(String language) {
        TConfiguration.setProperty(KEY_LANGUAGE, language);
    }
}

