/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ThumbnailPanel
extends JPanel
implements PropertyChangeListener {
    private JFileChooser jfc;
    private Image img;

    public ThumbnailPanel(JFileChooser jfc) {
        this.jfc = jfc;
        Dimension sz = new Dimension(200, 200);
        this.setPreferredSize(sz);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            File file = this.jfc.getSelectedFile();
            this.updateImage(file);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void updateImage(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!(file.getName().endsWith("png") || file.getName().endsWith("bmp") || file.getName().endsWith("jpg") || file.getName().endsWith("gif"))) {
            return;
        }
        this.img = ImageIO.read(file);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.img != null) {
            int w = this.img.getWidth(null);
            int h = this.img.getHeight(null);
            int side = Math.max(w, h);
            double scale = 200.0 / (double)side;
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
            g.drawImage(this.img, 0, 0, w, h, null);
            String dim = String.valueOf(w) + " x " + h;
            g.setColor(Color.black);
            g.drawString(dim, 31, 196);
            g.setColor(Color.white);
            g.drawString(dim, 30, 195);
        } else {
            g.setColor(Color.black);
            g.drawString("Not an image", 30, 100);
        }
    }
}

