/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PictogramTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label;
        this.setBorder(noFocusBorder);
        if (value != null) {
            String fileName = value.toString().substring(value.toString().lastIndexOf(File.separator) + 1);
            label = new JLabel();
            try {
                BufferedImage img = ImageIO.read(new File(value.toString()));
                ImageIcon icon = new ImageIcon(img.getScaledInstance(70, 70, 70));
                label = new JLabel(fileName, icon, 0);
                label.setVerticalTextPosition(3);
                label.setHorizontalTextPosition(0);
                if (hasFocus) {
                    label.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.red));
                }
            }
            catch (MalformedURLException mfe) {
                mfe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            label = new JLabel();
            label.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.white));
        }
        return label;
    }
}

