/*
 * Decompiled with CFR 0.152.
 */
package jess.xml;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jess.Funcall;
import jess.FuncallValue;
import jess.Jesp;
import jess.JessException;
import jess.Rete;
import jess.Visitable;
import jess.xml.XMLVisitor;

public class XMLPrinter
implements Serializable {
    private static final Set s_keepers = new HashSet();
    private static final String s_lineSeparator = System.getProperty("line.separator");
    private Writer m_writer;
    private Rete m_engine = new Rete();

    public XMLPrinter(Writer writer) {
        this.m_writer = writer;
        StringWriter stringWriter = new StringWriter();
        this.m_engine.addOutputRouter("t", stringWriter);
        this.m_engine.addOutputRouter("WSTDOUT", stringWriter);
        this.m_engine.addOutputRouter("WSTDERR", stringWriter);
    }

    public void close() throws IOException {
        this.m_writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException, JessException {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        FileReader fileReader = new FileReader(stringArray[0]);
        XMLPrinter xMLPrinter = new XMLPrinter(printWriter);
        try {
            xMLPrinter.printFrontMatter();
            xMLPrinter.translateToXML(fileReader);
            xMLPrinter.printBackMatter();
        }
        finally {
            xMLPrinter.close();
        }
    }

    public void translateToXML(Reader reader) throws JessException {
        Object object;
        Jesp jesp = new Jesp(reader, this.m_engine);
        PrintWriter printWriter = new PrintWriter(this.m_writer, true);
        do {
            Object object2;
            if ((object = jesp.parseExpression(this.m_engine.getGlobalContext(), false)) instanceof Visitable) {
                object2 = new XMLVisitor((Visitable)object);
                printWriter.println(((XMLVisitor)object2).toString());
                continue;
            }
            if (object instanceof List) {
                object2 = (List)object;
                for (int i = 0; i < object2.size(); ++i) {
                    XMLVisitor xMLVisitor = new XMLVisitor((Visitable)object2.get(i));
                    printWriter.println(xMLVisitor.toString());
                }
            } else {
                if (!(object instanceof FuncallValue)) continue;
                object2 = ((FuncallValue)object).funcallValue(null);
                if (XMLPrinter.shouldExecute((Funcall)object2)) {
                    ((Funcall)object2).execute(this.m_engine.getGlobalContext());
                }
                printWriter.println(new XMLVisitor((Visitable)object2));
            }
        } while (!Funcall.EOF.equals(object));
        printWriter.flush();
    }

    public void printBackMatter() throws IOException {
        this.m_writer.write("</rulebase>");
        this.m_writer.write(s_lineSeparator);
    }

    public void printFrontMatter() throws IOException {
        this.m_writer.write("<?xml version='1.0' encoding='US-ASCII'?>");
        this.m_writer.write(s_lineSeparator);
        this.m_writer.write("<rulebase xmlns='http://www.jessrules.com/JessML/1.0'>");
        this.m_writer.write(s_lineSeparator);
    }

    private static boolean shouldExecute(Funcall funcall) {
        return s_keepers.contains(funcall.getName());
    }

    static {
        s_keepers.add("import");
        s_keepers.add("defclass");
        s_keepers.add("add");
        s_keepers.add("do-backward-chaining");
        s_keepers.add("set-current-module");
        s_keepers.add("clear");
    }
}

