/*
 * Decompiled with CFR 0.152.
 */
package jess.speedup;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jess.Accelerator;
import jess.BindingValue;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.TestBase;
import jess.Value;
import jess.ValueVector;
import jess.Variable;

public class SimpleAccelerator
implements Accelerator,
Serializable {
    static Hashtable maths = new Hashtable();
    static String[][] mathnames = new String[][]{{"+", "+"}, {"-", "-"}, {"*", "*"}, {"mod", "%"}, {"/", "/"}, {"=", "=="}, {"eq", "=="}, {"eq*", "=="}, {"or", "||"}, {"and", "&&"}};
    private static int s_idx;

    public TestBase speedup(Funcall funcall, Rete rete) throws JessException {
        TestBase testBase;
        Hashtable hashtable = new Hashtable();
        int n = SimpleAccelerator.fetchVariables(funcall, hashtable, 0);
        if (!(SimpleAccelerator.confirmMathOnly(funcall) && SimpleAccelerator.confirmAllNumbers(hashtable) && (funcall.get(0).equals("=") || funcall.get(0).equals("or") || funcall.get(0).equals("and")))) {
            return null;
        }
        ValueVector valueVector = SimpleAccelerator.buildTree(funcall, hashtable);
        String string = SimpleAccelerator.emit(valueVector, hashtable, n);
        try {
            if (System.getProperty("KEEP") == null) {
                System.out.println("Compiling jess/tmp/" + string + ".java");
                Process process = Runtime.getRuntime().exec("jikes jess/tmp/" + string + ".java");
                process.waitFor();
            }
            testBase = (TestBase)rete.findClass("jess.tmp." + string).newInstance();
        }
        catch (Throwable throwable) {
            throw new JessException("speedup", "Problem loading generated class", throwable.toString());
        }
        return testBase;
    }

    private static String emit(ValueVector valueVector, Hashtable hashtable, int n) throws JessException {
        String string = SimpleAccelerator.varName();
        StringBuffer stringBuffer = new StringBuffer("package jess.tmp;\n\n");
        stringBuffer.append("import jess.*;\n\n");
        stringBuffer.append("public class ");
        stringBuffer.append(string);
        stringBuffer.append(" implements TestBase\n{\n");
        stringBuffer.append("  public boolean doTest(Context context)\n");
        stringBuffer.append("      throws JessException\n  {\n");
        stringBuffer.append("    Token lt = context.getToken();\n");
        stringBuffer.append("    ValueVector rf = context.getFact();\n");
        SimpleAccelerator.emitVarTable(hashtable, stringBuffer, n);
        SimpleAccelerator.emitCode(valueVector, stringBuffer);
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        String string2 = "jess/tmp/" + string + ".java";
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new JessException("speedUp", "IO Error", iOException.toString());
        }
        return string;
    }

    private static void emitCode(ValueVector valueVector, StringBuffer stringBuffer) throws JessException {
        stringBuffer.append("    return ");
        SimpleAccelerator.emitActualCode(valueVector, stringBuffer);
        stringBuffer.append(";\n");
    }

    private static void emitActualCode(ValueVector valueVector, StringBuffer stringBuffer) throws JessException {
        SimpleAccelerator.emitCodeOneSide(valueVector.get(1), stringBuffer);
        stringBuffer.append(SimpleAccelerator.getOperator(valueVector.get(0)));
        SimpleAccelerator.emitCodeOneSide(valueVector.get(2), stringBuffer);
    }

    private static void emitCodeOneSide(Value value, StringBuffer stringBuffer) throws JessException {
        stringBuffer.append(" ");
        switch (value.type()) {
            case 8: {
                stringBuffer.append(value.variableValue(null));
                break;
            }
            case 4: {
                stringBuffer.append(value.symbolValue(null));
                break;
            }
            case 512: {
                ValueVector valueVector = value.listValue(null);
                stringBuffer.append("(");
                for (int i = 1; i < valueVector.size(); ++i) {
                    SimpleAccelerator.emitCodeOneSide(valueVector.get(i), stringBuffer);
                    if (i >= valueVector.size() - 1) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(SimpleAccelerator.getOperator(valueVector.get(0)));
                    stringBuffer.append(" ");
                }
                stringBuffer.append(")");
            }
        }
        stringBuffer.append(" ");
    }

    private static void emitVarTable(Hashtable hashtable, StringBuffer stringBuffer, int n) throws JessException {
        Enumeration enumeration = hashtable.elements();
        block10: while (enumeration.hasMoreElements()) {
            BindingValue bindingValue = (BindingValue)enumeration.nextElement();
            String string = bindingValue.getFactNumber() == n ? "rf" : "lt.fact(" + bindingValue.getFactNumber() + ")";
            switch (bindingValue.getType()) {
                case 4: {
                    stringBuffer.append("    int ");
                    break;
                }
                case 32: 
                case 36: {
                    stringBuffer.append("    float ");
                    break;
                }
                case 1: 
                case 2: {
                    stringBuffer.append("    String ");
                    break;
                }
                default: {
                    throw new JessException("Accelerator::emitVarTable", "invalid type", String.valueOf(bindingValue.getType()));
                }
            }
            stringBuffer.append(bindingValue.getName());
            stringBuffer.append(" = ");
            stringBuffer.append(string);
            stringBuffer.append(".get(");
            stringBuffer.append(bindingValue.getSlotIndex());
            switch (bindingValue.getType()) {
                case 4: {
                    stringBuffer.append(").intValue(null);\n");
                    continue block10;
                }
                case 32: 
                case 36: {
                    stringBuffer.append(").floatValue(null);\n");
                    continue block10;
                }
                case 1: 
                case 2: {
                    stringBuffer.append(").stringValue(null).intern();\n");
                    continue block10;
                }
            }
            throw new JessException("Accelerator::emitVarTable", "invalid type", String.valueOf(bindingValue.getType()));
        }
    }

    private static String getOperator(Value value) throws JessException {
        return (String)maths.get(value.symbolValue(null));
    }

    private static boolean confirmAllNumbers(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            BindingValue bindingValue = (BindingValue)enumeration.nextElement();
            if ((bindingValue.getType() & 4) != 0 || (bindingValue.getType() & 0x20) != 0) continue;
            return false;
        }
        return true;
    }

    private static boolean confirmMathOnly(ValueVector valueVector) throws JessException {
        if (maths.get(valueVector.get(0).stringValue(null)) == null) {
            return false;
        }
        block3: for (int i = 1; i < valueVector.size(); ++i) {
            Value value = valueVector.get(i);
            switch (value.type()) {
                case 64: {
                    if (SimpleAccelerator.confirmMathOnly(value.funcallValue(null))) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    private static ValueVector buildTree(ValueVector valueVector, Hashtable hashtable) throws JessException {
        ValueVector valueVector2 = new ValueVector();
        block4: for (int i = 0; i < valueVector.size(); ++i) {
            Value value = valueVector.get(i);
            switch (value.type()) {
                case 64: {
                    valueVector2.add(new Value(SimpleAccelerator.buildTree(value.funcallValue(null), hashtable), 512));
                    continue block4;
                }
                case 4096: {
                    Integer n = new Integer(value.hashCode());
                    valueVector2.add(new Variable(((BindingValue)hashtable.get(n)).getName(), 8));
                    continue block4;
                }
                default: {
                    valueVector2.add(value);
                }
            }
        }
        return valueVector2;
    }

    private static int fetchVariables(Funcall funcall, Hashtable hashtable, int n) throws JessException {
        block4: for (int i = 1; i < funcall.size(); ++i) {
            Value value = funcall.get(i);
            switch (value.type()) {
                case 4096: {
                    BindingValue bindingValue = (BindingValue)value;
                    Integer n2 = new Integer(value.hashCode());
                    if (hashtable.get(n2) != null) continue block4;
                    hashtable.put(n2, value);
                    if (bindingValue.getFactNumber() <= n) continue block4;
                    n = bindingValue.getFactNumber();
                    continue block4;
                }
                case 64: {
                    n = SimpleAccelerator.fetchVariables(value.funcallValue(null), hashtable, n);
                }
            }
        }
        return n;
    }

    private static String varName() {
        return "var" + s_idx++;
    }

    static {
        for (int i = 0; i < mathnames.length; ++i) {
            maths.put(mathnames[i][0], mathnames[i][1]);
        }
        s_idx = 0;
    }
}

