/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import jess.FieldFunction;
import jess.JessException;
import jess.MethodFunction;
import jess.Multimap;
import jess.Rete;
import jess.Userfunction;

class StaticMemberImporter {
    private Class m_clazz;

    public StaticMemberImporter(Class clazz) {
        this.m_clazz = clazz;
    }

    public Userfunction createFieldFunction(Field field) throws JessException {
        return new FieldFunction(field);
    }

    public Userfunction createMethodFunctions(List list) {
        return new MethodFunction(list);
    }

    public void addAllStaticFields(Rete rete) throws JessException {
        Field[] fieldArray = this.m_clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!this.isPublicStatic(field)) continue;
            Userfunction userfunction = this.createFieldFunction(field);
            rete.addUserfunction(userfunction);
        }
    }

    public void addAllStaticMethods(Rete rete) {
        Object object;
        Method[] methodArray = this.m_clazz.getMethods();
        Multimap multimap = new Multimap();
        for (int i = 0; i < methodArray.length; ++i) {
            object = methodArray[i];
            if (!this.isPublicStatic((Member)object)) continue;
            multimap.put(((Method)object).getName(), object);
        }
        Iterator iterator = multimap.keySet().iterator();
        while (iterator.hasNext()) {
            object = this.createMethodFunctions((List)multimap.get(iterator.next()));
            rete.addUserfunction((Userfunction)object);
        }
    }

    private boolean isPublicStatic(Member member) {
        return Modifier.isStatic(member.getModifiers()) && Modifier.isPublic(member.getModifiers());
    }
}

