/*
 * Decompiled with CFR 0.152.
 */
package jess;

import jess.HasLHS;
import jess.PrettyPrinter;
import jess.Rete;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PrettyPrinterTest
extends TestCase {
    static /* synthetic */ Class class$jess$PrettyPrinterTest;

    public static TestSuite suite() {
        return new TestSuite(class$jess$PrettyPrinterTest == null ? (class$jess$PrettyPrinterTest = PrettyPrinterTest.class$("jess.PrettyPrinterTest")) : class$jess$PrettyPrinterTest);
    }

    public PrettyPrinterTest(String string) {
        super(string);
    }

    public void testVisitPattern() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule (B ?a) (not ?a <- (A))=>)");
        HasLHS hasLHS = rete.findDefrule("rule");
        String string = new PrettyPrinter(hasLHS).toString();
        PrettyPrinterTest.assertEquals((int)3, (int)string.split("\\?a").length);
    }

    public void testVisitAccumulate() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule (accumulate (bind ?i 0) (++ ?i) ?i (x ?)) =>)");
        HasLHS hasLHS = rete.findDefrule("rule");
        String string = new PrettyPrinter(hasLHS).toString();
        PrettyPrinterTest.assertEquals((String)"(defrule MAIN::rule \n   (initial-fact) \n   (accumulate (bind ?i 0) (++ ?i) ?i (x ?_20__blank_0)) \n   =>)", (String)string);
    }

    public void testContextualize() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defmodule FOO)");
        rete.eval("(defrule FOO::rule (MAIN::A) (B ?a) =>)");
        HasLHS hasLHS = rete.findDefrule("FOO::rule");
        PrettyPrinterTest.assertEquals((String)"MAIN::A", (String)PrettyPrinter.contextualize(hasLHS, "MAIN::A"));
        PrettyPrinterTest.assertEquals((String)"B", (String)PrettyPrinter.contextualize(hasLHS, "FOO::B"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

