/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.StringReader;
import java.util.HashMap;
import jess.ConditionalElementX;
import jess.Jesp;
import jess.JessException;
import jess.Pattern;
import jess.Rete;
import jess.Test1;
import jess.Value;
import jess.Variable;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PatternTest
extends TestCase {
    private Rete m_engine;
    static /* synthetic */ Class class$jess$PatternTest;

    public PatternTest(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$jess$PatternTest == null ? (class$jess$PatternTest = PatternTest.class$("jess.PatternTest")) : class$jess$PatternTest);
    }

    protected void setUp() throws JessException {
        this.m_engine = new Rete();
    }

    public void testMultitools() throws JessException {
        this.m_engine.eval("(deftemplate DT (slot slot) (multislot mslot))");
        Pattern pattern = new Pattern("DT", this.m_engine);
        pattern.addTest(new Test1(0, "slot", 0, new Variable("X", 8)));
        pattern.addTest(new Test1(0, "slot", 0, new Value("foo", 1)));
        pattern.addTest(new Test1(0, "mslot", 0, new Variable("A", 8)));
        pattern.addTest(new Test1(0, "mslot", 1, new Variable("B", 8192)));
        pattern.addTest(new Test1(0, "mslot", 2, new Variable("C", 8)));
        pattern.addTest(new Test1(0, "mslot", 3, new Variable("D", 8192)));
        pattern.setSlotLength("mslot", 4);
        PatternTest.assertTrue((pattern.getSlotLength(0) == -1 ? 1 : 0) != 0);
        PatternTest.assertTrue((pattern.getSlotLength(1) == 4 ? 1 : 0) != 0);
        PatternTest.assertTrue((pattern.getNMultifieldsInSlot(1) == 2 ? 1 : 0) != 0);
        PatternTest.assertTrue((!pattern.isMultifieldSubslot(1, 0) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)pattern.isMultifieldSubslot(1, 1));
        PatternTest.assertTrue((!pattern.isMultifieldSubslot(1, 2) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)pattern.isMultifieldSubslot(1, 3));
    }

    public void testParseLogical() throws Exception {
        StringReader stringReader = new StringReader("(logical (A))");
        Jesp jesp = new Jesp(stringReader, this.m_engine);
        ConditionalElementX conditionalElementX = jesp.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp.getTokenStream()).getConditionalElementX(0);
        PatternTest.assertTrue((boolean)conditionalElementX.getLogical());
    }

    public void testEquals() throws Exception {
        Jesp jesp = new Jesp(new StringReader("(A ?X)"), this.m_engine);
        ConditionalElementX conditionalElementX = jesp.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp.getTokenStream());
        Jesp jesp2 = new Jesp(new StringReader("(A)"), this.m_engine);
        ConditionalElementX conditionalElementX2 = jesp2.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp2.getTokenStream());
        Jesp jesp3 = new Jesp(new StringReader("(B ?X)"), this.m_engine);
        ConditionalElementX conditionalElementX3 = jesp3.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp3.getTokenStream());
        Jesp jesp4 = new Jesp(new StringReader("(B ?X ?Y)"), this.m_engine);
        ConditionalElementX conditionalElementX4 = jesp4.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp4.getTokenStream());
        Jesp jesp5 = new Jesp(new StringReader("(A ?X)"), this.m_engine);
        ConditionalElementX conditionalElementX5 = jesp5.parsePattern(new HashMap(), "MAIN", this.m_engine, jesp5.getTokenStream());
        PatternTest.assertTrue((boolean)conditionalElementX.equals(conditionalElementX));
        PatternTest.assertTrue((!conditionalElementX.equals(conditionalElementX2) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX.equals(conditionalElementX3) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX.equals(conditionalElementX4) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX.equals(conditionalElementX5));
        PatternTest.assertTrue((!conditionalElementX2.equals(conditionalElementX) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX2.equals(conditionalElementX2));
        PatternTest.assertTrue((!conditionalElementX2.equals(conditionalElementX3) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX2.equals(conditionalElementX4) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX2.equals(conditionalElementX5) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX3.equals(conditionalElementX) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX3.equals(conditionalElementX2) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX3.equals(conditionalElementX3));
        PatternTest.assertTrue((!conditionalElementX3.equals(conditionalElementX4) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX3.equals(conditionalElementX5) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX4.equals(conditionalElementX) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX4.equals(conditionalElementX2) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX4.equals(conditionalElementX3) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX4.equals(conditionalElementX4));
        PatternTest.assertTrue((!conditionalElementX4.equals(conditionalElementX5) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX5.equals(conditionalElementX));
        PatternTest.assertTrue((!conditionalElementX5.equals(conditionalElementX2) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX5.equals(conditionalElementX3) ? 1 : 0) != 0);
        PatternTest.assertTrue((!conditionalElementX5.equals(conditionalElementX4) ? 1 : 0) != 0);
        PatternTest.assertTrue((boolean)conditionalElementX5.equals(conditionalElementX5));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

