/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jess.Context;
import jess.Fact;
import jess.MatchInfoSource;
import jess.Rete;
import jess.Token;

class NodeLogicalDependencyHandler
implements Serializable {
    private HashMap m_logicalDepends = new HashMap();
    private MatchInfoSource m_matchInfoSource;
    private int m_tokenSize;

    public NodeLogicalDependencyHandler(int n) {
        this.m_tokenSize = n;
    }

    public void setMatchInfoSource(MatchInfoSource matchInfoSource) {
        this.m_matchInfoSource = matchInfoSource;
    }

    void removeLogicalSupportFrom(Token token, Context context) {
        ArrayList arrayList = (ArrayList)this.m_logicalDepends.remove(token);
        if (arrayList != null) {
            Rete rete = context.getEngine();
            for (int i = 0; i < arrayList.size(); ++i) {
                Fact fact = (Fact)arrayList.get(i);
                rete.removeLogicalSupportFrom(token, fact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependsOn(Fact fact, Token token) {
        ArrayList<Fact> arrayList = (ArrayList<Fact>)this.m_logicalDepends.get(token);
        if (arrayList == null) {
            arrayList = new ArrayList<Fact>();
            this.m_logicalDepends.put(token, arrayList);
        }
        ArrayList<Fact> arrayList2 = arrayList;
        synchronized (arrayList2) {
            arrayList.add(fact);
        }
    }

    Map getMap() {
        return this.m_logicalDepends;
    }

    void clear() {
        this.m_logicalDepends.clear();
    }

    public void tokenMatched(int n, Token token, Context context) {
        switch (n) {
            case 3: {
                this.m_logicalDepends.clear();
                break;
            }
            case 2: {
                break;
            }
            case 4: 
            case 5: {
                if (!this.m_matchInfoSource.isRelevantChange(this.m_tokenSize, token, context)) break;
                this.removeLogicalSupportFrom(token, context);
                break;
            }
            default: {
                this.removeLogicalSupportFrom(token, context);
            }
        }
    }
}

