/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

abstract class NVPairOperation
implements Serializable {
    NVPairOperation() {
    }

    protected static Fact getFactArgument(ValueVector valueVector, Context context, Rete rete, String string) throws JessException {
        Fact fact;
        int n;
        Value value = valueVector.get(1).resolveValue(context);
        if (value.type() == 4) {
            n = value.intValue(context);
            fact = rete.findFactByID(n);
        } else if (value.type() == 16) {
            fact = (Fact)value.javaObjectValue(context);
            n = fact.getFactId();
        } else if (value.type() == 2048) {
            fact = value.factValue(context);
            n = fact.getFactId();
        } else {
            throw Value.typeError(value, valueVector.get(0).symbolValue(context), "a fact", value.type());
        }
        if (fact == null || fact.getFactId() == -1) {
            throw new JessException(string, "no such fact", n);
        }
        return fact;
    }

    protected static String getSlotName(ValueVector valueVector, Context context) throws JessException {
        return valueVector.get(0).stringValue(context);
    }

    protected static Value getSlotValue(ValueVector valueVector, Context context, int n) throws JessException {
        if (n == 16384) {
            Value value = valueVector.get(1).resolveValue(context);
            while (value.type() == 512) {
                value = value.listValue(context).get(0).resolveValue(context);
            }
            return value;
        }
        ValueVector valueVector2 = new ValueVector();
        for (int i = 1; i < valueVector.size(); ++i) {
            Value value = valueVector.get(i).resolveValue(context);
            if (value.type() == 512) {
                ValueVector valueVector3 = value.listValue(context);
                for (int j = 0; j < valueVector3.size(); ++j) {
                    valueVector2.add(valueVector3.get(j).resolveValue(context));
                }
                continue;
            }
            valueVector2.add(value);
        }
        return new Value(valueVector2, 512);
    }
}

