/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jess.Batch;
import jess.ErrorHandler;
import jess.Funcall;
import jess.Jesp;
import jess.JessException;
import jess.ParseException;
import jess.Rete;
import jess.TerminatedException;
import jess.Value;
import jess.server.DebugListener;

public class Main
implements Observer {
    private Rete m_engine;
    private boolean m_exitOnError = false;
    private boolean m_fullStackTraces = false;
    private boolean m_running = false;
    private String m_filename;
    private boolean m_showWarnings;

    public static void main(String[] stringArray) {
        Main main = new Main();
        main.initialize(stringArray, new Rete());
        main.execute(main.m_filename == null);
    }

    public void showLogo() {
        PrintWriter printWriter = this.m_engine.getOutStream();
        if (this.m_engine != null && printWriter != null) {
            printWriter.println("\nJess, the Rule Engine for the Java Platform");
            printWriter.println("Copyright (C) 2006 Sandia Corporation");
            printWriter.println("Jess Version 7.0p1 12/21/2006");
            printWriter.println();
        }
    }

    public Main initialize(String[] stringArray, Rete rete) {
        int n;
        this.m_engine = rete;
        boolean bl = true;
        if (stringArray.length > 0) {
            for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
                if (stringArray[n].equals("-nologo")) {
                    bl = false;
                    continue;
                }
                if (stringArray[n].equals("-stacktrace")) {
                    this.m_fullStackTraces = true;
                    continue;
                }
                if (stringArray[n].equals("-warnings")) {
                    this.m_showWarnings = true;
                    continue;
                }
                if (stringArray[n].equals("-exit")) {
                    this.m_exitOnError = true;
                    continue;
                }
                if (!stringArray[n].equals("-debugPorts")) continue;
                try {
                    int n2 = Integer.parseInt(stringArray[++n]);
                    int n3 = Integer.parseInt(stringArray[++n]);
                    this.setDebugMode(n2, n3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("Invalid syntax for debugPorts flag");
                }
            }
        }
        if (bl) {
            this.showLogo();
        }
        this.m_filename = stringArray.length <= n ? null : stringArray[n];
        return this;
    }

    public void setDebugMode(int n, int n2) {
        DebugListener debugListener = new DebugListener(this.m_engine);
        if (!debugListener.waitForConnections(n, n2)) {
            this.m_engine.getErrStream().println("Could not open debug channels");
            System.exit(-1);
        }
        this.m_engine.addDebugListener(debugListener);
        debugListener.addObserver(this);
        this.m_engine.setDebug(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean bl) {
        PushbackReader pushbackReader;
        block18: {
            pushbackReader = null;
            if (this.m_filename != null) {
                try {
                    bl = false;
                    pushbackReader = Batch.findDocument(this.m_engine, this.m_filename);
                    if (!Batch.isXMLDocument(pushbackReader)) break block18;
                    try {
                        Batch.parseXMLDocument(this.m_engine, pushbackReader, new ErrorHandler.DefaultHandler());
                    }
                    finally {
                        this.m_filename = null;
                        pushbackReader.close();
                    }
                    return;
                }
                catch (JessException jessException) {
                    this.displayJessException(jessException);
                    return;
                }
                catch (IOException iOException) {
                    this.displayException(this.m_engine.getErrStream(), iOException);
                    return;
                }
            }
        }
        if (pushbackReader == null) {
            pushbackReader = new PushbackReader(this.m_engine.getInputRouter("t"));
        }
        Jesp jesp = new Jesp(pushbackReader, this.m_engine);
        jesp.setFileName(this.m_filename);
        if (this.m_showWarnings) {
            jesp.setIssueWarnings(true);
        }
        this.m_running = true;
        Value value = Funcall.NIL;
        do {
            Object var10_15;
            try {
                block20: {
                    try {
                        value = jesp.promptAndParseOneExpression(bl, this.m_engine.getGlobalContext());
                        if (!this.m_showWarnings) break block20;
                        List list = jesp.getWarnings();
                        PrintWriter printWriter = this.m_engine.getErrStream();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ParseException parseException = (ParseException)iterator.next();
                            printWriter.println("Warning: " + parseException.getMessage());
                        }
                        this.m_engine.getOutStream().flush();
                        jesp.clearWarnings();
                    }
                    catch (TerminatedException terminatedException) {
                        var10_15 = null;
                        this.m_engine.getErrStream().flush();
                        this.m_engine.getOutStream().flush();
                        break;
                    }
                    catch (JessException jessException) {
                        this.displayJessException(jessException);
                        var10_15 = null;
                        this.m_engine.getErrStream().flush();
                        this.m_engine.getOutStream().flush();
                        continue;
                    }
                    catch (Exception exception) {
                        this.m_engine.getErrStream().println("Unexpected exception:");
                        this.displayException(this.m_engine.getErrStream(), exception);
                        if (this.m_exitOnError) {
                            this.m_engine.getErrStream().flush();
                            this.m_engine.getOutStream().flush();
                            System.exit(-1);
                        }
                        var10_15 = null;
                        this.m_engine.getErrStream().flush();
                        this.m_engine.getOutStream().flush();
                        continue;
                    }
                }
                var10_15 = null;
                this.m_engine.getErrStream().flush();
                this.m_engine.getOutStream().flush();
            }
            catch (Throwable throwable) {
                var10_15 = null;
                this.m_engine.getErrStream().flush();
                this.m_engine.getOutStream().flush();
                throw throwable;
            }
        } while (!value.equals(Funcall.EOF) && this.isRunning());
    }

    private void displayJessException(JessException jessException) {
        PrintWriter printWriter = this.m_engine.getErrStream();
        this.displayException(printWriter, jessException);
        if (jessException.getCause() != null) {
            printWriter.write("\nNested exception is:\n");
            this.displayException(printWriter, jessException.getCause());
        }
        if (this.m_exitOnError) {
            System.exit(-1);
        }
    }

    public synchronized boolean isRunning() {
        return this.m_running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        if ("QUIT".equals(object)) {
            Main main = this;
            synchronized (main) {
                try {
                    this.m_engine.halt();
                }
                catch (JessException jessException) {
                    // empty catch block
                }
                this.m_running = false;
            }
        }
    }

    private void displayException(PrintWriter printWriter, Throwable throwable) {
        if (this.m_fullStackTraces) {
            throwable.printStackTrace(printWriter);
        } else if (throwable instanceof JessException) {
            printWriter.println(throwable.toString());
        } else {
            printWriter.println(throwable.getMessage());
        }
        this.m_engine.getErrStream().flush();
        this.m_engine.getOutStream().flush();
    }
}

