/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Stack;
import jess.JessException;
import jess.JessToken;
import jess.Tokenizer;

class JessTokenStream
implements Serializable {
    private Stack m_stack;
    private Tokenizer m_tokenizer;
    private int m_lineno;
    private StringBuffer m_string = new StringBuffer();
    private JessToken m_lastToken;

    public JessTokenStream(Tokenizer tokenizer) {
        this.m_tokenizer = tokenizer;
        this.m_stack = new Stack();
    }

    public JessToken getLastToken() {
        return this.m_lastToken;
    }

    public int getLineNumber() {
        return this.m_lineno;
    }

    public JessToken nextToken() throws JessException {
        JessToken jessToken = this.m_stack.empty() ? this.m_tokenizer.nextToken() : (JessToken)this.m_stack.pop();
        this.m_string.append(jessToken.toString());
        this.m_string.append(" ");
        this.m_lineno = jessToken.m_lineno;
        this.m_lastToken = jessToken;
        return this.m_lastToken;
    }

    public void pushBack(JessToken jessToken) {
        if (jessToken.m_ttype == 0) {
            return;
        }
        this.m_lineno = jessToken.m_lineno;
        this.m_stack.push(jessToken);
        this.m_string.setLength(this.m_string.length() - (jessToken.toString().length() + 1));
    }

    void clear() {
        this.m_string.setLength(0);
    }

    public String toString() {
        return this.m_string.toString();
    }

    public int getStreamPos() {
        return this.m_tokenizer.getStreamPos();
    }

    void eatWhitespace() throws JessException {
        this.m_tokenizer.eatWhitespace();
    }

    public JessToken nextNonCommentToken() throws JessException {
        JessToken jessToken = this.nextToken();
        while (jessToken.isComment()) {
            jessToken = this.nextToken();
        }
        return jessToken;
    }
}

