/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import jess.Accumulate;
import jess.ArgumentChecker;
import jess.BindingValue;
import jess.ConditionalElement;
import jess.Context;
import jess.Defrule;
import jess.Deftemplate;
import jess.ErrorSink;
import jess.Funcall;
import jess.Jesp;
import jess.JessException;
import jess.JessToken;
import jess.ParseException;
import jess.Rete;
import jess.Value;
import jess.Variable;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JespTest
extends TestCase {
    static /* synthetic */ Class class$jess$JespTest;
    static /* synthetic */ Class class$jess$Accumulate;
    static /* synthetic */ Class class$jess$BindingValue;

    public static TestSuite suite() {
        return new TestSuite(class$jess$JespTest == null ? (class$jess$JespTest = JespTest.class$("jess.JespTest")) : class$jess$JespTest);
    }

    public void testDeftemplateDefinitionsRequired() throws Exception {
        Rete rete = new Rete();
        String string = "(defrule rule-1 (foo) =>)";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.setIssueWarnings(false);
        jesp.clearWarnings();
        jesp.parseExpression(rete.getGlobalContext(), false);
        JespTest.assertEquals((int)0, (int)jesp.getWarnings().size());
        stringReader.reset();
        rete.clear();
        jesp.setIssueWarnings(true);
        jesp.parseExpression(rete.getGlobalContext(), false);
        List list = jesp.getWarnings();
        JespTest.assertEquals((int)1, (int)list.size());
        ParseException parseException = (ParseException)list.get(0);
        JespTest.assertEquals((String)"foo", (String)parseException.getErrorToken().toString());
    }

    public void testFunctionDefinitionsRequired() throws Exception {
        Rete rete = new Rete();
        String string = "(defrule rule-1 => (foo))";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.setIssueWarnings(false);
        jesp.clearWarnings();
        jesp.parseExpression(rete.getGlobalContext(), false);
        JespTest.assertEquals((int)0, (int)jesp.getWarnings().size());
        stringReader.reset();
        jesp.setIssueWarnings(true);
        jesp.parseExpression(rete.getGlobalContext(), false);
        List list = jesp.getWarnings();
        JespTest.assertEquals((int)1, (int)list.size());
        ParseException parseException = (ParseException)list.get(0);
        JespTest.assertEquals((String)"foo", (String)parseException.getErrorToken().toString());
    }

    public void testLineNumberOnError1() throws Exception {
        Rete rete = new Rete();
        String string = "(\ndefrule\n1";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        try {
            jesp.parseExpression(rete.getGlobalContext(), false);
            JespTest.fail((String)"Missed expected exception");
        }
        catch (JessException jessException) {
            JespTest.assertEquals((int)jessException.getLineNumber(), (int)3);
        }
    }

    public void testLineNumberOnError2() throws Exception {
        Rete rete = new Rete();
        String string = ";Comment\n(\ndefrule\n\"multiline\nstring\"";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        try {
            jesp.parseExpression(rete.getGlobalContext(), false);
            JespTest.fail((String)"Missed expected exception");
        }
        catch (JessException jessException) {
            JespTest.assertEquals((int)5, (int)jessException.getLineNumber());
        }
    }

    public void testParseAccumulate() throws Exception {
        Rete rete = new Rete();
        String string = "(defrule foo ?a<- (accumulate + 1 ?X (foo ?X)) => )\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        Defrule defrule = jesp.parseDefrule(rete.getGlobalContext(), rete, jesp.getTokenStream());
        JespTest.assertEquals((int)2, (int)defrule.getPatternCount());
        ConditionalElement conditionalElement = defrule.getConditionalElements();
        ConditionalElement conditionalElement2 = conditionalElement.getConditionalElement(1);
        JespTest.assertSame((Object)(class$jess$Accumulate == null ? (class$jess$Accumulate = JespTest.class$("jess.Accumulate")) : class$jess$Accumulate), conditionalElement2.getClass());
        JespTest.assertEquals((String)"accumulate", (String)conditionalElement2.getName());
        JespTest.assertEquals((int)1, (int)conditionalElement2.getGroupSize());
        Accumulate accumulate = (Accumulate)conditionalElement2;
        JespTest.assertEquals((String)"1", (String)accumulate.getBody().symbolValue(null));
        JespTest.assertEquals((Object)new Value("+", 1), (Object)accumulate.getInitializer());
        Value value = accumulate.getReturn();
        JespTest.assertSame(value.getClass(), (Object)(class$jess$BindingValue == null ? (class$jess$BindingValue = JespTest.class$("jess.BindingValue")) : class$jess$BindingValue));
        JespTest.assertTrue((boolean)((BindingValue)value).getName().endsWith("X"));
        JespTest.assertEquals((Object)new Variable("a", 8), (Object)accumulate.getBoundName());
        ConditionalElement conditionalElement3 = accumulate.getConditionalElement(0);
        JespTest.assertEquals((String)"MAIN::foo", (String)conditionalElement3.getName());
    }

    public void testParseExpressions() throws Exception {
        Rete rete = new Rete();
        Context context = rete.getGlobalContext();
        String string = "(defrule foo ?a<- (accumulate (sym-cat \"+\") (+ 1 1) ?X (foo ?X)) => )\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        Defrule defrule = jesp.parseDefrule(rete.getGlobalContext(), rete, jesp.getTokenStream());
        JespTest.assertEquals((int)2, (int)defrule.getPatternCount());
        ConditionalElement conditionalElement = defrule.getConditionalElements();
        ConditionalElement conditionalElement2 = conditionalElement.getConditionalElement(1);
        JespTest.assertSame((Object)(class$jess$Accumulate == null ? (class$jess$Accumulate = JespTest.class$("jess.Accumulate")) : class$jess$Accumulate), conditionalElement2.getClass());
        JespTest.assertEquals((String)"accumulate", (String)conditionalElement2.getName());
        JespTest.assertEquals((int)1, (int)conditionalElement2.getGroupSize());
        Accumulate accumulate = (Accumulate)conditionalElement2;
        JespTest.assertEquals((String)"+", (String)accumulate.getInitializer().symbolValue(context));
        JespTest.assertEquals((int)2, (int)accumulate.getBody().intValue(context));
        Value value = accumulate.getReturn();
        JespTest.assertSame(value.getClass(), (Object)(class$jess$BindingValue == null ? (class$jess$BindingValue = JespTest.class$("jess.BindingValue")) : class$jess$BindingValue));
        JespTest.assertTrue((boolean)((BindingValue)value).getName().endsWith("X"));
        JespTest.assertEquals((Object)new Variable("a", 8), (Object)accumulate.getBoundName());
        ConditionalElement conditionalElement3 = accumulate.getConditionalElement(0);
        JespTest.assertEquals((String)"MAIN::foo", (String)conditionalElement3.getName());
    }

    public void testParseAccumulateErrors() throws Exception {
        Rete rete = new Rete();
        String[] stringArray = new String[]{"(defrule foo (initial-fact) (not (accumulate + 1 ?X (foo ?X))) => )\n", "(defrule foo (initial-fact) (exists (accumulate + 1 ?X (foo ?X))) => )\n", "(defrule foo (initial-fact) (explicit (accumulate + 1 ?X (foo ?X))) => )\n", "(defrule foo (logical (initial-fact) (accumulate + 1 ?X (foo ?X))) => )\n"};
        for (int i = 0; i < stringArray.length; ++i) {
            StringReader stringReader = new StringReader(stringArray[i]);
            Jesp jesp = new Jesp(stringReader, rete);
            try {
                jesp.parseDefrule(rete.getGlobalContext(), rete, jesp.getTokenStream());
                JespTest.fail((String)"Didn't get expected exception");
                continue;
            }
            catch (JessException jessException) {
                JespTest.assertEquals((String)jessException.getDetail(), (String)"accumulate can't be enclosed by");
            }
        }
    }

    public void testWarnings() throws Exception {
        Rete rete = new Rete();
        String string = "(foo 1 2 3)\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.setIssueWarnings(true);
        try {
            jesp.parse(false, rete.getGlobalContext());
        }
        catch (JessException jessException) {
            List list = jesp.getWarnings();
            JespTest.assertEquals((int)1, (int)list.size());
            ParseException parseException = (ParseException)list.get(0);
            List<String> list2 = Arrays.asList(parseException.getAlternatives());
            JespTest.assertTrue((boolean)list2.contains("defrule"));
            JespTest.assertTrue((boolean)list2.contains("assert"));
        }
    }

    public void testParseExpression() throws Exception {
        Rete rete = new Rete();
        String string = "(bind ?x 3)\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        Value value = (Value)jesp.parseExpression(rete.getGlobalContext(), true);
        JespTest.assertEquals((int)3, (int)rete.getGlobalContext().getVariable("x").intValue(rete.getGlobalContext()));
        JespTest.assertEquals((int)4, (int)value.type());
        rete.clear();
        try {
            rete.getGlobalContext().getVariable("x");
            JespTest.fail((String)"Didn't get expected exception.");
        }
        catch (JessException jessException) {
            // empty catch block
        }
        stringReader.reset();
        value = (Value)jesp.parseExpression(rete.getGlobalContext(), false);
        try {
            rete.getGlobalContext().getVariable("x");
            JespTest.fail((String)"Didn't get expected exception.");
        }
        catch (JessException jessException) {
            // empty catch block
        }
        JespTest.assertEquals((int)value.type(), (int)64);
    }

    public void testParseDeftemplate() throws Exception {
        Rete rete = new Rete();
        String string = "(deftemplate foo (slot x))\n(deftemplate bar (declare (slot-specific FALSE)) (slot x))\n(deftemplate baz (declare (slot-specific TRUE)) (slot x))\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.parse(false);
        JespTest.assertFalse((boolean)rete.findDeftemplate("foo").isSlotSpecific());
        JespTest.assertFalse((boolean)rete.findDeftemplate("bar").isSlotSpecific());
        JespTest.assertTrue((boolean)rete.findDeftemplate("baz").isSlotSpecific());
    }

    public void testParseDeftemplateNullParent() throws Exception {
        Rete rete = new Rete();
        String string = "(deftemplate foo extends bar (slot x))\n";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        try {
            jesp.parse(false);
            JespTest.fail((String)"No exception?");
        }
        catch (JessException jessException) {
            // empty catch block
        }
        JespTest.assertNull((Object)rete.findDeftemplate("foo"));
    }

    public void testParseDeftemplatePublicMemberVariables() throws Exception {
        Rete rete = new Rete();
        String string = "(deftemplate foo (declare (from-class jess.JespTest$MockPoint)))";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.parse(false);
        Deftemplate deftemplate = rete.findDeftemplate("foo");
        JespTest.assertTrue((deftemplate.getSlotIndex("z") > -1 ? 1 : 0) != 0);
        JespTest.assertEquals((int)-1, (int)deftemplate.getSlotIndex("x"));
        JespTest.assertEquals((int)-1, (int)deftemplate.getSlotIndex("y"));
        rete.clear();
        string = "(deftemplate foo (declare (from-class jess.JespTest$MockPoint) (include-variables TRUE)))";
        stringReader = new StringReader(string);
        jesp = new Jesp(stringReader, rete);
        jesp.parse(false);
        deftemplate = rete.findDeftemplate("foo");
        JespTest.assertTrue((deftemplate.getSlotIndex("z") != -1 ? 1 : 0) != 0);
        JespTest.assertTrue((deftemplate.getSlotIndex("x") > 0 ? 1 : 0) != 0);
        JespTest.assertTrue((deftemplate.getSlotIndex("y") > 0 ? 1 : 0) != 0);
        rete.clear();
        string = "(deftemplate foo (declare (include-variables TRUE)))";
        stringReader = new StringReader(string);
        jesp = new Jesp(stringReader, rete);
        try {
            jesp.parse(false);
            JespTest.fail((String)"Missed expected exception");
        }
        catch (JessException jessException) {
            // empty catch block
        }
    }

    public void testParseUnorderedAsOrdered() throws Exception {
        Rete rete = new Rete();
        String string = "(deftemplate foo (slot bar))\n(defrule onerule (foo ?name ?value true\n";
        StringReader stringReader = new StringReader(string);
        try {
            Jesp jesp = new Jesp(stringReader, rete);
            jesp.parse(false);
            JespTest.fail((String)"Missed expected exception");
        }
        catch (ParseException parseException) {
            JespTest.assertEquals((String)"name", (String)parseException.getErrorToken().m_sval);
        }
    }

    public void testParseDefclass() throws Exception {
        Rete rete = new Rete();
        String string = "(defclass foo no.such.class)";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.addArgumentChecker("defclass", new MockClassNameArgumentChecker(2));
        jesp.setIssueWarnings(true);
        JespTest.assertEquals((int)0, (int)jesp.getWarnings().size());
        jesp.parseExpression(rete.getGlobalContext(), false);
        JespTest.assertEquals((int)1, (int)jesp.getWarnings().size());
    }

    public void testParseRecursiveDeffunctionCall() throws Exception {
        Rete rete = new Rete();
        String string = "(deffunction foo () (foo))";
        StringReader stringReader = new StringReader(string);
        Jesp jesp = new Jesp(stringReader, rete);
        jesp.setIssueWarnings(true);
        jesp.parseExpression(rete.getGlobalContext(), false);
        JespTest.assertEquals((int)0, (int)jesp.getWarnings().size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MockClassNameArgumentChecker
    implements ArgumentChecker {
        private int m_index;

        public MockClassNameArgumentChecker(int n) {
            this.m_index = n;
        }

        public boolean check(Funcall funcall, JessToken jessToken, ErrorSink errorSink) {
            if (funcall.size() == this.m_index) {
                try {
                    errorSink.getEngine().findClass(jessToken.m_sval);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorSink.warning("Jesp.parseFuncall", "No such class", null, 1001, jessToken);
                    return false;
                }
            }
            return true;
        }
    }

    public class MockPoint {
        public int x;
        public int y;

        public int getZ() {
            return 0;
        }
    }
}

