/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Iterator;
import jess.Activation;
import jess.Strategy;

class HeapPriorityQueue
implements Serializable {
    private Activation[] m_queue;
    private Strategy m_strategy;
    private int m_size;

    public HeapPriorityQueue(Strategy strategy) {
        this.m_queue = new Activation[10];
        this.m_strategy = strategy;
    }

    private HeapPriorityQueue(HeapPriorityQueue heapPriorityQueue) {
        this.m_queue = (Activation[])heapPriorityQueue.m_queue.clone();
        for (int i = 1; i <= heapPriorityQueue.m_size; ++i) {
            this.m_queue[i] = new Activation(this.m_queue[i]);
        }
        this.m_size = heapPriorityQueue.m_size;
        this.m_strategy = heapPriorityQueue.m_strategy;
    }

    public Strategy setStrategy(Strategy strategy) {
        Strategy strategy2 = this.m_strategy;
        this.m_strategy = strategy;
        return strategy2;
    }

    public Strategy getStrategy() {
        return this.m_strategy;
    }

    public boolean isEmpty() {
        return this.m_size == 0;
    }

    public synchronized void remove(Activation activation) {
        if (this.m_size > 0) {
            int n = activation.getIndex();
            activation.setIndex(-1);
            this.m_queue[n] = this.m_queue[this.m_size];
            this.m_queue[n].setIndex(n);
            this.m_queue[this.m_size] = null;
            --this.m_size;
            this.fixDown(n);
        }
    }

    public synchronized void push(Activation activation) {
        if (this.m_size == this.m_queue.length - 1) {
            Activation[] activationArray = new Activation[this.m_size * 2];
            System.arraycopy(this.m_queue, 1, activationArray, 1, this.m_size);
            this.m_queue = activationArray;
        }
        ++this.m_size;
        this.m_queue[this.m_size] = activation;
        activation.setIndex(this.m_size);
        this.fixUp(this.m_size);
        this.notify();
    }

    public synchronized Activation pop() {
        if (this.isEmpty()) {
            return null;
        }
        Activation activation = this.m_queue[1];
        this.remove(activation);
        return activation;
    }

    public synchronized Activation peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.m_queue[1];
    }

    public void clear() {
        this.m_queue = new Activation[10];
        this.m_size = 0;
    }

    public Iterator iterator() {
        final HeapPriorityQueue heapPriorityQueue = new HeapPriorityQueue(this);
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return !heapPriorityQueue.isEmpty();
            }

            public Object next() {
                return heapPriorityQueue.pop();
            }
        };
    }

    private void fixDown(int n) {
        Activation[] activationArray = this.m_queue;
        while (2 * n <= this.m_size) {
            int n2 = 2 * n;
            if (n2 < this.m_size && this.m_strategy.compare(activationArray[n2], activationArray[n2 + 1]) > 0) {
                ++n2;
            }
            if (this.m_strategy.compare(activationArray[n], activationArray[n2]) <= 0) break;
            this.exch(n, n2);
            n = n2;
        }
    }

    private void fixUp(int n) {
        Activation[] activationArray = this.m_queue;
        while (n > 1 && this.m_strategy.compare(activationArray[n / 2], activationArray[n]) > 0) {
            int n2 = n / 2;
            this.exch(n, n2);
            n = n2;
        }
    }

    private void exch(int n, int n2) {
        Activation[] activationArray = this.m_queue;
        Activation activation = activationArray[n];
        activationArray[n] = activationArray[n2];
        activationArray[n2] = activation;
        activationArray[n].setIndex(n);
        activationArray[n2].setIndex(n2);
    }

    public int size() {
        return this.m_size;
    }
}

