/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jess.BindingValue;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Context;
import jess.Defglobal;
import jess.Deftemplate;
import jess.Fact;
import jess.FactIDValue;
import jess.Funcall;
import jess.FuncallValue;
import jess.Group;
import jess.JessException;
import jess.Modular;
import jess.Node;
import jess.NodeSink;
import jess.Pattern;
import jess.PatternIterator;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.Token;
import jess.Value;
import jess.ValueVector;
import jess.Variable;
import jess.Visitable;
import jess.Visitor;

public abstract class HasLHS
extends Node
implements Serializable,
Visitable,
Modular,
NodeSink {
    String m_module;
    String m_name;
    String m_displayName;
    String m_docstring = "";
    private ArrayList m_nodes = new ArrayList();
    private Map m_bindings = new HashMap();
    private Group m_CEs;
    private int m_nodeIndexHash = 0;
    private StringBuffer m_compilationTrace;
    boolean m_new = true;
    boolean m_frozen = false;
    private HasLHS m_next = null;
    private int m_seqNum;

    HasLHS(String string, String string2, Rete rete) throws JessException {
        int n = string.indexOf("::");
        if (n != -1) {
            this.m_module = string.substring(0, n);
            rete.verifyModule(this.m_module);
            this.m_name = string;
        } else {
            this.m_module = rete.getCurrentModule();
            this.m_name = rete.resolveName(string);
        }
        int n2 = this.m_name.indexOf(38);
        this.m_displayName = n2 == -1 ? this.m_name : this.m_name.substring(0, n2);
        this.m_docstring = string2;
        this.m_CEs = new Group("and");
    }

    public int getGroupSize() {
        return this.m_CEs.getGroupSize();
    }

    ConditionalElementX getLHSComponent(int n) {
        return this.m_CEs.getConditionalElementX(n);
    }

    public ConditionalElement getConditionalElements() {
        return this.getLHSComponents();
    }

    ConditionalElementX getLHSComponents() {
        return this.m_CEs;
    }

    public String listNodes() {
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i = 0; i < this.m_nodes.size(); ++i) {
            stringBuffer.append(this.m_nodes.get(i));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public HasLHS getNext() {
        return this.m_next;
    }

    void setNext(HasLHS hasLHS) {
        this.m_next = hasLHS;
    }

    void freeze(Rete rete) throws JessException {
        this.m_frozen = true;
    }

    public int getPatternCount() {
        return this.getLHSComponents().getPatternCount();
    }

    void insertCEAt(ConditionalElementX conditionalElementX, int n, Rete rete) throws JessException {
        Group group = this.m_CEs;
        this.m_bindings = new HashMap();
        this.m_CEs = new Group("and");
        if (group.getGroupSize() == 0) {
            this.addCE(conditionalElementX, rete);
            return;
        }
        for (int i = 0; i < group.getGroupSize(); ++i) {
            if (i == n) {
                this.addCE(conditionalElementX, rete);
            }
            this.addCE(group.getConditionalElementX(i), rete);
        }
    }

    public void setLHS(Group group, Rete rete) throws JessException {
        group = (Group)group.canonicalize();
        this.createChain(group, rete);
    }

    abstract void createChain(ConditionalElementX var1, Rete var2) throws JessException;

    void doSetLHS(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        Group group = new Group("and");
        conditionalElementX.addToGroup(group);
        for (int i = 0; i < conditionalElementX.getGroupSize(); ++i) {
            ConditionalElementX conditionalElementX2 = (ConditionalElementX)conditionalElementX.getConditionalElement(i);
            this.addCE(conditionalElementX2, rete);
        }
    }

    protected void addCE(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        conditionalElementX = (ConditionalElementX)conditionalElementX.clone();
        this.m_seqNum += 10;
        if (conditionalElementX.getName().equals("not") || conditionalElementX.getName().equals("accumulate")) {
            this.m_CEs.renameVariables(conditionalElementX, this.getSequenceNumber());
        }
        this.storeBoundName(conditionalElementX);
        this.m_CEs.add(conditionalElementX);
        conditionalElementX.findVariableDefinitions(this.getPatternCount() - conditionalElementX.getPatternCount(), this.m_bindings, this.m_bindings);
        this.findUndefinedVariables(conditionalElementX);
        this.transformOrConjunctionsIntoOrFuncalls(conditionalElementX, rete);
        this.addNOTToSupressUnneededBackwardChaining(conditionalElementX, rete);
    }

    private void addNOTToSupressUnneededBackwardChaining(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        if (conditionalElementX.isBackwardChainingTrigger()) {
            Pattern pattern = (Pattern)conditionalElementX;
            Pattern pattern2 = new Pattern(pattern, pattern.getNameWithoutBackchainingPrefix());
            Group group = new Group("not");
            group.add(pattern2);
            this.addCE(group, rete);
        }
    }

    private void storeBoundName(ConditionalElementX conditionalElementX) {
        String string = conditionalElementX.getBoundName();
        if (string != null && this.m_bindings.get(string) == null) {
            if (conditionalElementX.getName().equals("accumulate")) {
                this.addBinding(string, conditionalElementX, this.getGroupSize(), -1, -4);
            } else {
                while (!(conditionalElementX instanceof Pattern)) {
                    conditionalElementX = conditionalElementX.getConditionalElementX(0);
                }
                this.addBinding(string, conditionalElementX, this.getGroupSize(), -1, -1);
            }
        }
    }

    private void findUndefinedVariables(ConditionalElementX conditionalElementX) throws JessException {
        PatternIterator patternIterator = new PatternIterator(conditionalElementX);
        while (patternIterator.hasNext()) {
            Pattern pattern = (Pattern)patternIterator.next();
            for (int i = 0; i < pattern.getNSlots(); ++i) {
                for (int j = 0; j < pattern.getNTests(i); ++j) {
                    Test1 test1 = pattern.getTest(i, j);
                    Value value = test1.m_slotValue;
                    if (value instanceof Variable) {
                        String string = value.variableValue(null);
                        if (this.m_bindings.get(string) != null || Defglobal.isADefglobalName(string)) continue;
                        throw new JessException("HasLHS.addPattern", "First use of variable negated:", RU.removePrefix(string));
                    }
                    if (!(value instanceof FuncallValue)) continue;
                    this.searchFuncallForUndefinedVariables((FuncallValue)value, (Map)((HashMap)this.m_bindings).clone());
                }
            }
        }
    }

    private void searchFuncallForUndefinedVariables(FuncallValue funcallValue, Map map) throws JessException {
        Funcall funcall = funcallValue.funcallValue(null);
        for (int i = 0; i < funcall.size(); ++i) {
            if (funcall.get(i) instanceof Variable) {
                String string = funcall.get(i).variableValue(null);
                if (this.isADefinition(funcall, i)) {
                    map.put(string, string);
                    continue;
                }
                if (map.get(string) != null || Defglobal.isADefglobalName(string)) continue;
                throw new JessException("HasLHS.addPattern", "Variable used before definition:", string);
            }
            if (!(funcall.get(i) instanceof FuncallValue)) continue;
            this.searchFuncallForUndefinedVariables((FuncallValue)funcall.get(i), map);
        }
    }

    private boolean isADefinition(Funcall funcall, int n) throws JessException {
        String string = funcall.get(0).stringValue(null);
        return n == 1 && (string.equals("bind") || string.equals("foreach"));
    }

    private void transformOrConjunctionsIntoOrFuncalls(ConditionalElementX conditionalElementX, Rete rete) throws JessException {
        PatternIterator patternIterator = new PatternIterator(conditionalElementX);
        int n = this.getPatternCount() - conditionalElementX.getPatternCount();
        while (patternIterator.hasNext()) {
            Pattern pattern = (Pattern)patternIterator.next();
            Deftemplate deftemplate = pattern.getDeftemplate();
            for (int i = 0; i < pattern.getNSlots(); ++i) {
                int n2;
                int n3 = pattern.getNTests(i);
                if (n3 == 0) continue;
                ArrayList<Test1> arrayList = new ArrayList<Test1>();
                String string = deftemplate.getSlotName(i);
                int n4 = pattern.getTest((int)i, (int)0).m_subIdx;
                int n5 = 0;
                block2: while (n5 < n3) {
                    int n6;
                    Object object;
                    Value value;
                    Test1 test1;
                    boolean bl = false;
                    for (n2 = n5; n2 < n3; ++n2) {
                        test1 = pattern.getTest(i, n2);
                        if (test1.m_subIdx != n4) break;
                        if (test1.m_conjunction != 2) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        for (int j = n5; j < n3; ++j) {
                            Test1 test12 = pattern.getTest(i, j);
                            if (test12.m_subIdx != n4) {
                                n4 = test12.m_subIdx;
                                continue block2;
                            }
                            arrayList.add(test12);
                            ++n5;
                        }
                        continue;
                    }
                    test1 = pattern.getTest(i, n5);
                    Value value2 = test1.m_slotValue;
                    if (this.isAVariableDefinition(value2, pattern, i)) {
                        value = value2;
                        ++n5;
                    } else {
                        object = RU.gensym("_blank_");
                        value = new Variable((String)object, 8);
                        this.m_bindings.put(object, new BindingValue((String)object, pattern, n, i, n4, deftemplate.getSlotDataType(i)));
                    }
                    arrayList.add(new Test1(0, string, n4, value));
                    object = new Funcall("or", rete);
                    do {
                        n6 = 1;
                        for (int j = n5 + 1; j < n3; ++j) {
                            Test1 test13 = pattern.getTest(i, j);
                            if (test13.m_conjunction == 2 || test13.m_subIdx != n4) break;
                            ++n6;
                        }
                        if (n6 == 1) {
                            ((ValueVector)object).add(this.testToFuncall(pattern.getTest(i, n5), value, rete));
                            continue;
                        }
                        Funcall funcall = new Funcall("and", rete);
                        for (int j = n5; j < n5 + n6; ++j) {
                            funcall.add(this.testToFuncall(pattern.getTest(i, j), value, rete));
                        }
                        ((ValueVector)object).add(new FuncallValue(funcall));
                    } while ((n5 += n6) != n3 && pattern.getTest((int)i, (int)n5).m_subIdx == n4);
                    arrayList.add(new Test1(0, string, n4, new FuncallValue((Funcall)object)));
                    if (n5 >= n3 || pattern.getTest((int)i, (int)n5).m_subIdx == n4) continue;
                    n4 = pattern.getTest((int)i, (int)n5).m_subIdx;
                }
                Test1[] test1Array = new Test1[arrayList.size()];
                for (n2 = 0; n2 < test1Array.length; ++n2) {
                    test1Array[n2] = (Test1)arrayList.get(n2);
                }
                pattern.replaceTests(i, test1Array);
            }
            ++n;
        }
    }

    private boolean isAVariableDefinition(Value value, ConditionalElementX conditionalElementX, int n) throws JessException {
        if (value.type() != 8) {
            return false;
        }
        String string = value.variableValue(null);
        if (Defglobal.isADefglobalName(string)) {
            return false;
        }
        BindingValue bindingValue = (BindingValue)this.m_bindings.get(string);
        return bindingValue.getCE() == conditionalElementX && bindingValue.getSlotIndex() == n;
    }

    private Value testToFuncall(Test1 test1, Value value, Rete rete) throws JessException {
        Value value2 = test1.m_slotValue;
        switch (test1.m_slotValue.type()) {
            case 64: {
                if (test1.m_test == 1) {
                    return new FuncallValue(new Funcall("not", rete).arg(value2));
                }
                return value2;
            }
        }
        return new FuncallValue(new Funcall(test1.m_test == 0 ? "eq" : "neq", rete).arg(value2).arg(value));
    }

    private void addBinding(String string, ConditionalElementX conditionalElementX, int n, int n2, int n3) {
        this.m_bindings.put(string, new BindingValue(string, conditionalElementX, n, n3, n2, 16));
    }

    Map getBindings() {
        return this.m_bindings;
    }

    public Iterator getNodes() {
        return this.m_nodes.iterator();
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    void ready(Token token, Context context) {
        Iterator iterator = this.getBindings().values().iterator();
        while (iterator.hasNext()) {
            BindingValue bindingValue = (BindingValue)iterator.next();
            if (bindingValue.getSlotIndex() == -2) continue;
            Fact fact = token.fact(bindingValue.getFactNumber());
            try {
                Value value;
                if (bindingValue.getSlotIndex() == -1) {
                    value = new FactIDValue(fact.getIcon());
                } else if (bindingValue.getSubIndex() == -1) {
                    value = fact.get(bindingValue.getSlotIndex());
                } else {
                    ValueVector valueVector = fact.get(bindingValue.getSlotIndex()).listValue(context);
                    value = valueVector.get(bindingValue.getSubIndex());
                }
                context.setVariable(bindingValue.getName(), value);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addNode(Node node) throws JessException {
        if (node == null) {
            new JessException("HasLHS.addNode", "Compiler fault", "null Node added");
        } else {
            for (int i = 0; i < this.m_nodes.size(); ++i) {
                if (node != this.m_nodes.get(i)) continue;
                return;
            }
            this.appendCompilationTrace(node);
            ++node.m_usecount;
            this.m_nodes.add(node);
        }
    }

    void remove(Node node) {
        Iterator iterator = this.m_nodes.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (--node2.m_usecount > 0) continue;
            node.removeSuccessor(node2);
            Iterator iterator2 = this.m_nodes.iterator();
            while (iterator2.hasNext()) {
                Node node3 = (Node)iterator2.next();
                node3.removeSuccessor(node2);
            }
        }
        this.m_nodes.clear();
        if (this.getNext() != null) {
            this.getNext().remove(node);
        }
    }

    private void appendCompilationTrace(Node node) {
        if (this.m_compilationTrace == null) {
            this.m_compilationTrace = new StringBuffer(this.m_name + ": ");
        }
        if (node.m_usecount == 0) {
            this.m_compilationTrace.append("+");
        } else {
            this.m_compilationTrace.append("=");
        }
        this.m_compilationTrace.append(node.getCompilationTraceToken());
    }

    String getCompilationTraceToken() {
        return "t";
    }

    StringBuffer getCompilationTrace() {
        return this.m_compilationTrace;
    }

    public void setNodeIndexHash(int n) {
        this.m_nodeIndexHash = n;
        if (this.getNext() != null) {
            this.getNext().setNodeIndexHash(n);
        }
    }

    public int getNodeIndexHash() {
        return this.m_nodeIndexHash;
    }

    public final String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public final String getDocstring() {
        return this.m_docstring;
    }

    void setOld() {
        this.m_new = false;
    }

    public abstract Object accept(Visitor var1);

    public String getModule() {
        return this.m_module;
    }

    int getSequenceNumber() {
        return this.m_seqNum;
    }

    public int getNodeType() {
        return 5;
    }
}

