/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.PrintThread;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class HaltEtc
implements Userfunction,
Serializable {
    static final int HALT = 0;
    static final int EXIT = 1;
    static final int CLEAR = 2;
    static final int RUN = 3;
    static final int RESET = 4;
    static final int RETURN = 5;
    static final String[] s_names = new String[]{"halt", "exit", "clear", "run", "reset", "return"};
    private int m_name;

    HaltEtc(int n) {
        this.m_name = n;
    }

    public String getName() {
        return s_names[this.m_name];
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        Rete rete = context.getEngine();
        switch (this.m_name) {
            case 0: {
                rete.halt();
                break;
            }
            case 1: {
                PrintThread.getPrintThread().waitForCompletion();
                System.exit(0);
                break;
            }
            case 2: {
                rete.clear();
                break;
            }
            case 3: {
                if (valueVector.size() == 1) {
                    return new Value(rete.run(context), 4);
                }
                return new Value(rete.run(valueVector.get(1).intValue(context), context), 4);
            }
            case 5: {
                if (valueVector.size() > 1) {
                    return context.setReturnValue(valueVector.get(1).resolveValue(context));
                }
                return context.setReturnValue(Funcall.NIL);
            }
            case 4: {
                rete.reset();
            }
        }
        return Funcall.TRUE;
    }
}

