/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jess.Context;
import jess.Deftemplate;
import jess.Fact;
import jess.JessException;
import jess.LogicalSupport;
import jess.Node;
import jess.RU;
import jess.Rete;
import jess.ReteCompiler;
import jess.SerializableD;
import jess.SortedIterator;
import jess.Token;
import jess.Value;
import jess.xml.XMLVisitor;

class FactList
implements Serializable {
    private Map m_table = Collections.synchronizedMap(new HashMap());
    private final ArrayList m_factsToAssert = new ArrayList();
    private final ArrayList m_factsToRetract = new ArrayList();
    private int m_time = 0;
    private final LogicalSupport m_logicalSupport = new LogicalSupport(this.m_factsToRetract);
    private final Object m_idLock = new String("IDLOCK");
    private int m_nextFactId;

    FactList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToken(int n, Fact fact, Rete rete, Context context) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            this.assignTime(fact);
            Token token = Rete.getFactory().newToken(fact, n);
            rete.getCompiler().getRoot().callNodeRight(n, token, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNodes(Rete rete, Set set) throws JessException {
        try {
            JessException jessException = null;
            Iterator iterator = this.listFacts();
            while (iterator.hasNext()) {
                Fact fact = (Fact)iterator.next();
                Token token = Rete.getFactory().newToken(fact, 2);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    ReteCompiler reteCompiler = rete.getCompiler();
                    synchronized (reteCompiler) {
                        Node node = (Node)iterator2.next();
                        try {
                            node.callNodeRight(2, token, rete.getGlobalContext().push());
                        }
                        catch (JessException jessException2) {
                            jessException = jessException2;
                        }
                    }
                }
            }
            this.processPendingFacts(rete);
            if (jessException != null) {
                throw jessException;
            }
        }
        finally {
            rete.commitActivations();
        }
    }

    void clear(Rete rete) throws JessException {
        this.processToken(3, Fact.getClearFact(), rete, rete.getGlobalContext());
        this.m_table.clear();
        this.m_time = 0;
        this.m_factsToAssert.clear();
        this.m_factsToRetract.clear();
        this.m_logicalSupport.clear();
        this.m_nextFactId = 0;
    }

    int getTime() {
        return this.m_time;
    }

    void assignTime(Fact fact) {
        fact.updateTime(++this.m_time);
    }

    int doPreAssertionProcessing(Fact fact) {
        return this.m_table.containsKey(fact) ? -1 : 0;
    }

    Fact findFactByFact(Fact fact) {
        return (Fact)this.m_table.get(fact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact findFactByID(int n) {
        Map map = this.m_table;
        synchronized (map) {
            Iterator iterator = this.m_table.keySet().iterator();
            while (iterator.hasNext()) {
                Fact fact = (Fact)iterator.next();
                if (fact.getFactId() != n) continue;
                return fact;
            }
            return null;
        }
    }

    void ppFacts(String string, Writer writer, boolean bl) throws IOException {
        if (bl) {
            writer.write("<?xml version='1.0' encoding='US-ASCII'?>\n");
            writer.write("<fact-list>\n");
        }
        Iterator iterator = this.listFacts();
        while (iterator.hasNext()) {
            Fact fact = (Fact)iterator.next();
            if (string != null && !fact.getName().equals(string)) continue;
            if (bl) {
                writer.write(new XMLVisitor(fact).toString());
            } else {
                writer.write(fact.toString());
            }
            writer.write("\n");
        }
        if (bl) {
            writer.write("</fact-list>\n");
        }
    }

    void ppFacts(Writer writer, boolean bl) throws IOException {
        this.ppFacts(null, writer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator listFacts() {
        Map map = this.m_table;
        synchronized (map) {
            return new SortedIterator(this.m_table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int consumeFactId() {
        Object object = this.m_idLock;
        synchronized (object) {
            return this.m_nextFactId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int peekFactId() {
        Object object = this.m_idLock;
        synchronized (object) {
            return this.m_nextFactId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingFacts(Rete rete) throws JessException {
        Fact fact;
        ArrayList arrayList = this.m_factsToAssert;
        synchronized (arrayList) {
            while (this.m_factsToAssert.size() > 0) {
                fact = (Fact)this.m_factsToAssert.get(0);
                this.m_factsToAssert.remove(0);
                this._assert(fact, rete, rete.getGlobalContext());
            }
        }
        arrayList = this.m_factsToRetract;
        synchronized (arrayList) {
            while (this.m_factsToRetract.size() > 0) {
                fact = (Fact)this.m_factsToRetract.get(0);
                this.m_factsToRetract.remove(0);
                if (fact.isShadow()) {
                    Object object = fact.getSlotValue("OBJECT").javaObjectValue(null);
                    rete.undefinstanceNoRetract(object);
                }
                this._retract(fact, rete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact assertFact(Fact fact, Rete rete, Context context) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            Fact fact2 = this._assert(fact, rete, context);
            if (fact2 != null) {
                this.processPendingFacts(rete);
            }
            return fact2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Fact _assert(Fact fact, Rete rete, Context context) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            try {
                boolean bl = rete.doPreAssertionProcessing(fact) != 0;
                this.m_logicalSupport.factAsserted(context, fact, bl);
                if (bl) {
                    Fact fact2 = null;
                    return fact2;
                }
                fact.setFactId(this.consumeFactId());
                rete.broadcastEvent(16, fact, context);
                this.m_table.put(fact, fact);
                this.processToken(0, fact, rete, rete.getGlobalContext().push());
                Fact fact3 = fact;
                return fact3;
            }
            finally {
                rete.commitActivations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFacts(String string, Rete rete) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            Fact fact;
            ArrayList<Fact> arrayList = new ArrayList<Fact>();
            string = rete.resolveName(string);
            Iterator<Object> iterator = this.m_table.keySet().iterator();
            while (iterator.hasNext()) {
                fact = (Fact)iterator.next();
                if (!fact.getDeftemplate().getName().equals(string)) continue;
                arrayList.add(fact);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                fact = (Fact)iterator.next();
                rete.retract(fact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact retract(Fact fact, Rete rete) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            Fact fact2 = (Fact)this.m_table.get(fact);
            if (fact2 != null) {
                this._retract(fact2, rete);
                this.processPendingFacts(rete);
            }
            return fact2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retract(Fact fact, Rete rete) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            try {
                rete.broadcastEvent(-2147483632, fact, null);
                this.m_table.remove(fact);
                this.m_logicalSupport.removeAllLogicalSupportFor(fact);
                this.processToken(1, fact, rete, rete.getGlobalContext().push());
            }
            finally {
                rete.commitActivations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Fact modify(Fact fact, String[] stringArray, Value[] valueArray, Context context, Rete rete) throws JessException {
        if (stringArray.length != valueArray.length) {
            throw new JessException("modify", "Wrong number of values, expected " + stringArray.length + ", got", valueArray.length);
        }
        ReteCompiler reteCompiler = rete.getCompiler();
        // MONITORENTER : reteCompiler
        try {
            switch (fact.getShadowMode()) {
                case 0: {
                    fact = this.modifyRegularFact(fact, stringArray, valueArray, rete, context);
                    return fact;
                }
                case 1: {
                    fact = this.modifyDefinstancedObject(fact, stringArray, valueArray, rete, context);
                    return fact;
                }
                case 2: {
                    valueArray = (Value[])valueArray.clone();
                    int n = 0;
                    while (true) {
                        if (n >= valueArray.length) {
                            this.modifyDefinstancedObject(fact, stringArray, valueArray, rete, context);
                            fact = this.modifyRegularFact(fact, stringArray, valueArray, rete, context);
                            return fact;
                        }
                        valueArray[n] = valueArray[n].resolveValue(context);
                        ++n;
                    }
                }
            }
            throw new JessException("modify", "Impossible shadow mode", fact.getShadowMode());
        }
        finally {
            rete.commitActivations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fact prepareToModifyRegularFact(Fact fact, String[] stringArray, Rete rete) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            Context context = rete.getGlobalContext().push();
            if (fact.getDeftemplate().isSlotSpecific()) {
                context.setSlotSpecificModifiedFact(fact);
                context.setModifiedSlots(stringArray);
            }
            this.processToken(5, fact, rete, context);
            fact = (Fact)this.m_table.remove(fact);
            this.m_logicalSupport.removeAllLogicalSupportFor(fact);
            return fact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fact finishModifyRegularFact(Fact fact, Rete rete, String[] stringArray, Context context) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            rete.broadcastEvent(0x40000010, fact, context);
            this.m_logicalSupport.factAsserted(context, fact, false);
            if (rete.doPreAssertionProcessing(fact) == 0) {
                this.m_table.put(fact, fact);
                Context context2 = rete.getGlobalContext().push();
                if (fact.getDeftemplate().isSlotSpecific()) {
                    context2.setSlotSpecificModifiedFact(fact);
                    context2.setModifiedSlots(stringArray);
                }
                this.processToken(4, fact, rete, context2);
                this.processPendingFacts(rete);
                return fact;
            }
            return Fact.getNullFact();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Fact modifyRegularFact(Fact fact, String[] stringArray, Value[] valueArray, Rete rete, Context context) throws JessException {
        ReteCompiler reteCompiler = rete.getCompiler();
        synchronized (reteCompiler) {
            int n;
            if (this.m_table.get(fact) == null) {
                throw new JessException("modify", "Fact object not in working memory", fact.toStringWithParens());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Value> arrayList2 = new ArrayList<Value>();
            for (n = 0; n < valueArray.length; ++n) {
                Value value = valueArray[n].resolveValue(context);
                if (fact.getSlotValue(stringArray[n]).equals(value)) continue;
                arrayList.add(stringArray[n]);
                arrayList2.add(value);
            }
            if (arrayList.size() == 0) {
                return fact;
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            fact = this.prepareToModifyRegularFact(fact, stringArray, rete);
            try {
                for (n = 0; n < arrayList.size(); ++n) {
                    fact.setSlotValue((String)arrayList.get(n), (Value)arrayList2.get(n));
                }
            }
            finally {
                fact = this.finishModifyRegularFact(fact, rete, stringArray, context);
            }
        }
        return fact;
    }

    private Fact modifyDefinstancedObject(Fact fact, String[] stringArray, Value[] valueArray, Rete rete, Context context) throws JessException {
        try {
            Deftemplate deftemplate = fact.getDeftemplate();
            Object object = fact.getSlotValue("OBJECT").javaObjectValue(context);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = deftemplate.getSlotIndex(stringArray[i]);
                Value value = deftemplate.getSlotDefault(n);
                SerializableD serializableD = (SerializableD)value.javaObjectValue(context);
                Class clazz = serializableD.getPropertyType(rete);
                serializableD.setPropertyValue(rete, object, RU.valueToObject(clazz, valueArray[i], context));
            }
        }
        catch (Exception exception) {
            throw new JessException("modify", "Error setting slot value", exception);
        }
        return fact;
    }

    public List getSupportedFacts(Fact fact) {
        return this.m_logicalSupport.getSupportedFacts(fact);
    }

    public List getSupportingTokens(Fact fact) {
        return this.m_logicalSupport.getSupportingTokens(fact);
    }

    public void removeLogicalSupportFrom(Token token, Fact fact) {
        this.m_logicalSupport.removeLogicalSupportFrom(token, fact);
    }

    public void setPendingFact(Fact fact, boolean bl) {
        if (bl) {
            this.m_factsToAssert.add(fact);
        } else if ((fact = (Fact)this.m_table.get(fact)) != null) {
            this.m_factsToRetract.add(fact);
        }
    }
}

