/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.HashMap;
import jess.Accumulate;
import jess.Funcall;
import jess.JessException;
import jess.Modular;
import jess.RU;
import jess.Rete;
import jess.SerializableVD;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;
import jess.Visitor;

public class Deftemplate
implements Serializable,
Visitable,
Modular {
    private static final HashMap s_typeCodes = new HashMap();
    private static final HashMap s_typeNames = new HashMap();
    static final String[] TYPE_NAMES = new String[]{"ANY", "INTEGER", "FLOAT", "NUMBER", "ATOM", "SYMBOL", "STRING", "LEXEME", "OBJECT", "LONG"};
    static final int[] TYPE_CODES = new int[]{-1, 4, 32, 65572, 1, 1, 2, 3, 2048, 65536};
    private static final Deftemplate s_rootTemplate = new Deftemplate("__fact", "Parent template");
    private static final Deftemplate s_clearTemplate = new Deftemplate("__clear", "(Implied)");
    private static final Deftemplate s_nullTemplate = new Deftemplate("__not_or_test_CE", "(Implied)");
    private static final Deftemplate s_initialTemplate = new Deftemplate("initial-fact", "(Implied)");
    private static final Deftemplate s_testTemplate = new Deftemplate("test", "(Implied)");
    private static final Deftemplate s_accumulateTemplate = new Deftemplate(Accumulate.RESULT, "(Accumulate result)");
    private boolean m_slotSpecific;
    private boolean m_backchain;
    private final String m_baseName;
    private final String m_fullName;
    private String m_docstring = "";
    private Deftemplate m_parent;
    final ValueVector m_data = new ValueVector();
    private final HashMap m_indexes;
    private final String m_module;

    public static Deftemplate getRootTemplate() {
        return s_rootTemplate;
    }

    public static Deftemplate getInitialTemplate() {
        return s_initialTemplate;
    }

    public static Deftemplate getClearTemplate() {
        return s_clearTemplate;
    }

    public static Deftemplate getNullTemplate() {
        return s_nullTemplate;
    }

    public static Deftemplate getTestTemplate() {
        return s_testTemplate;
    }

    public static Deftemplate getAccumTemplate() {
        return s_accumulateTemplate;
    }

    static void addStandardTemplates(Rete rete) throws JessException {
        rete.addDeftemplate(Deftemplate.getRootTemplate());
        rete.addDeftemplate(Deftemplate.getNullTemplate());
        rete.addDeftemplate(Deftemplate.getClearTemplate());
        rete.addDeftemplate(Deftemplate.getInitialTemplate());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Deftemplate)) {
            return false;
        }
        Deftemplate deftemplate = (Deftemplate)object;
        return this.m_fullName.equals(deftemplate.m_fullName) && this.m_backchain == deftemplate.m_backchain && this.m_parent == deftemplate.m_parent && this.m_data.equals(deftemplate.m_data);
    }

    public int hashCode() {
        return this.m_fullName.hashCode();
    }

    public Deftemplate getParent() {
        return this.m_parent;
    }

    private void forgetParent() {
        this.m_parent = s_rootTemplate;
    }

    public final String getName() {
        return this.m_fullName;
    }

    public final String getBaseName() {
        return this.m_baseName;
    }

    public final String getDocstring() {
        return this.m_docstring;
    }

    public final void doBackwardChaining(Rete rete) throws JessException {
        this.m_backchain = true;
        Deftemplate deftemplate = this.getBackchainingTemplate(rete);
        deftemplate.forgetParent();
        rete.addDeftemplate(deftemplate);
    }

    public final boolean getBackwardChaining() {
        return this.m_backchain;
    }

    public Deftemplate(String string, String string2, Rete rete) throws JessException {
        this(string, string2, s_rootTemplate, rete);
    }

    public Deftemplate(String string, String string2, Deftemplate deftemplate, Rete rete) throws JessException {
        int n = string.indexOf("::");
        if (n != -1) {
            this.m_module = string.substring(0, n);
            rete.verifyModule(this.m_module);
            this.m_baseName = string.substring(n + 2);
            this.m_fullName = string;
        } else {
            this.m_module = rete.getCurrentModule();
            this.m_baseName = string;
            this.m_fullName = rete.resolveName(string);
        }
        this.m_parent = deftemplate;
        this.m_docstring = string2;
        for (int i = 0; i < deftemplate.m_data.size(); ++i) {
            this.m_data.add(deftemplate.m_data.get(i));
        }
        this.m_indexes = (HashMap)deftemplate.m_indexes.clone();
    }

    private Deftemplate(String string, String string2) {
        this.m_module = "MAIN";
        this.m_baseName = string;
        this.m_fullName = RU.scopeName(this.m_module, this.m_baseName);
        this.m_docstring = string2;
        if (!string.equals("__fact")) {
            this.m_parent = s_rootTemplate;
        }
        this.m_indexes = new HashMap();
    }

    public void addSlot(String string, Value value, String string2) throws JessException {
        Value value2 = Deftemplate.getSlotTypeCode(string2);
        int n = this.getSlotIndex(string);
        if (n != -1) {
            this.m_data.set(value, n * 3 + 1);
            this.m_data.set(value2, n * 3 + 2);
        } else {
            int n2 = this.m_data.size();
            this.m_data.setLength(n2 + 3);
            this.m_data.set(new Value(string, 16384), n2 + 0);
            this.m_data.set(value, n2 + 1);
            this.m_data.set(value2, n2 + 2);
            this.m_indexes.put(string, new Integer(n2 / 3));
        }
    }

    static boolean isValidSlotType(String string) {
        return s_typeCodes.containsKey(string.toUpperCase());
    }

    private static Value getSlotTypeCode(String string) throws JessException {
        Value value = (Value)s_typeCodes.get(string.toUpperCase());
        if (value == null) {
            throw new JessException("Deftemplate.getSlotTypeCode", "Bad slot type:", string);
        }
        return value;
    }

    static String getSlotTypeName(Value value) throws JessException {
        String string = (String)s_typeNames.get(value);
        if (string == null) {
            throw new JessException("Deftemplate.getSlotTypeName", "Bad slot type:", value.toString());
        }
        return string;
    }

    public void addMultiSlot(String string, Value value, String string2) throws JessException {
        Value value2 = Deftemplate.getSlotTypeCode(string2);
        int n = this.getSlotIndex(string);
        if (n != -1) {
            this.m_data.set(value, Deftemplate.absoluteIndex(n) + 1);
        } else {
            int n2 = this.m_data.size();
            this.m_data.setLength(n2 + 3);
            this.m_data.set(new Value(string, 32768), n2 + 0);
            this.m_data.set(value, n2 + 1);
            this.m_data.set(value2, n2 + 2);
            this.m_indexes.put(string, new Integer(n2 / 3));
        }
    }

    public void addMultiSlot(String string, Value value) throws JessException {
        this.addMultiSlot(string, value, "ANY");
    }

    private static int absoluteIndex(int n) {
        return n * 3;
    }

    public int getSlotDataType(int n) throws JessException {
        return this.m_data.get(Deftemplate.absoluteIndex(n) + 2).intValue(null);
    }

    public Value getSlotDefault(int n) throws JessException {
        return this.m_data.get(Deftemplate.absoluteIndex(n) + 1);
    }

    public int getSlotType(int n) throws JessException {
        return this.m_data.get(Deftemplate.absoluteIndex(n) + 0).type();
    }

    public int getSlotType(String string) throws JessException {
        int n = this.getSlotIndex(string);
        if (n == -1) {
            throw new JessException("Deftemplate.getSlotType", "No such slot " + string + " in template", this.m_fullName);
        }
        return this.getSlotType(n);
    }

    public boolean isMultislot(int n) throws JessException {
        return this.getSlotType(n) == 32768;
    }

    public int getSlotIndex(String string) {
        Integer n = (Integer)this.m_indexes.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public String getSlotName(int n) throws JessException {
        return this.m_data.get(Deftemplate.absoluteIndex(n) + 0).stringValue(null);
    }

    public String[] getSlotNames() {
        String[] stringArray = new String[this.getNSlots()];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = this.getSlotName(i);
                continue;
            }
            catch (JessException jessException) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public int getNSlots() {
        return this.m_data.size() / 3;
    }

    public String toString() {
        return "[deftemplate " + this.m_fullName + "]";
    }

    public Object accept(Visitor visitor) {
        return visitor.visitDeftemplate(this);
    }

    public String getModule() {
        return this.m_module;
    }

    public boolean isBackwardChainingTrigger() {
        return this.m_baseName.startsWith("need-");
    }

    public String getBackchainingTemplateName() {
        return RU.scopeName(this.m_module, "need-" + this.m_baseName);
    }

    public String getNameWithoutBackchainingPrefix() {
        if (!this.isBackwardChainingTrigger()) {
            return this.m_fullName;
        }
        return RU.scopeName(this.m_module, this.m_baseName.substring("need-".length()));
    }

    public Deftemplate getBackchainingTemplate(Rete rete) throws JessException {
        return new Deftemplate(this.getBackchainingTemplateName(), "Goal seeker for " + this.m_fullName, this, rete);
    }

    public boolean isOrdered() {
        return this.getSlotIndex("__data") == 0;
    }

    public void setSlotSpecific(boolean bl) {
        this.m_slotSpecific = bl;
    }

    public boolean isSlotSpecific() {
        return this.m_slotSpecific;
    }

    public final String getConstructType() {
        return "deftemplate";
    }

    public String getShadowClassName() {
        if (this.isShadowTemplate()) {
            return this.m_docstring.substring("$JAVA-OBJECT$ ".length());
        }
        return null;
    }

    public boolean isShadowTemplate() {
        return this.getSlotIndex("OBJECT") != -1 && this.m_docstring.indexOf("$JAVA-OBJECT$ ") == 0;
    }

    public boolean includesVariables() throws JessException {
        if (!this.isShadowTemplate()) {
            return false;
        }
        Value value = this.getSlotDefault(this.getNSlots() - 2);
        if (value.type() != 2048) {
            return false;
        }
        return value.javaObjectValue(null) instanceof SerializableVD;
    }

    public static boolean isSpecialName(String string) {
        return string.equals("test") || string.equals("initial-fact");
    }

    public static Deftemplate getSpecialTemplate(String string) {
        if (string.equals("test")) {
            return s_testTemplate;
        }
        if (string.equals("initial-fact")) {
            return s_initialTemplate;
        }
        return null;
    }

    static {
        try {
            for (int i = 0; i < TYPE_NAMES.length; ++i) {
                Value value = new Value(TYPE_CODES[i], 4);
                s_typeCodes.put(TYPE_NAMES[i], value);
                s_typeNames.put(value, TYPE_NAMES[i]);
            }
            s_accumulateTemplate.addSlot("value", Funcall.NIL, "ANY");
            s_testTemplate.addSlot("__data", Funcall.NILLIST, "ANY");
        }
        catch (JessException jessException) {
            // empty catch block
        }
    }
}

