/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.ArrayList;
import java.util.Map;
import jess.BindingValue;
import jess.Context;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.FuncallValue;
import jess.JessException;
import jess.LogicalNode;
import jess.Node2;
import jess.NodeNot2;
import jess.Pattern;
import jess.Rete;
import jess.Test1;
import jess.Token;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.Variable;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DefruleTest
extends TestCase {
    private Rete m_engine;
    static /* synthetic */ Class class$jess$DefruleTest;

    public DefruleTest(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$jess$DefruleTest == null ? (class$jess$DefruleTest = DefruleTest.class$("jess.DefruleTest")) : class$jess$DefruleTest);
    }

    protected void setUp() throws JessException {
        this.m_engine = new Rete();
    }

    public void testLogicalBindings() throws JessException {
        this.m_engine.eval("(deftemplate Super (slot ref))");
        this.m_engine.eval("(deftemplate A extends Super)");
        this.m_engine.eval("(deftemplate B extends Super)");
        this.m_engine.eval("(deftemplate C extends Super)");
        this.m_engine.eval("(deftemplate D extends Super)");
        this.m_engine.eval("(defrule ARule (logical (A (ref ?a)) (B (ref ?b))) (C (ref ?c)) => (store CONTEXT (context))(store ACTIVATION ((engine) getThisActivation)))");
        this.m_engine.assertString("(A (ref a))");
        this.m_engine.assertString("(B (ref b))");
        this.m_engine.assertString("(C (ref c))");
        DefruleTest.assertEquals((int)1, (int)this.m_engine.run());
        Context context = (Context)this.m_engine.fetch("CONTEXT").javaObjectValue(null);
        Defrule defrule = (Defrule)this.m_engine.findDefrule("ARule");
        Map map = defrule.getBindings();
        BindingValue bindingValue = (BindingValue)map.get("a");
        DefruleTest.assertEquals((int)0, (int)bindingValue.getFactNumber());
        DefruleTest.assertEquals((int)0, (int)bindingValue.getSlotIndex());
        DefruleTest.assertEquals((int)-1, (int)bindingValue.getSubIndex());
        DefruleTest.assertEquals((String)"a", (String)context.getVariable("a").stringValue(null));
        BindingValue bindingValue2 = (BindingValue)map.get("b");
        DefruleTest.assertEquals((int)1, (int)bindingValue2.getFactNumber());
        DefruleTest.assertEquals((int)0, (int)bindingValue2.getSlotIndex());
        DefruleTest.assertEquals((int)-1, (int)bindingValue2.getSubIndex());
        DefruleTest.assertEquals((String)"b", (String)context.getVariable("b").stringValue(null));
        BindingValue bindingValue3 = (BindingValue)map.get("c");
        DefruleTest.assertEquals((int)2, (int)bindingValue3.getFactNumber());
        DefruleTest.assertEquals((int)0, (int)bindingValue3.getSlotIndex());
        DefruleTest.assertEquals((int)-1, (int)bindingValue3.getSubIndex());
        DefruleTest.assertEquals((String)"c", (String)context.getVariable("c").stringValue(null));
    }

    public void testInstallLogicalSupport() throws JessException {
        class Probe
        implements Userfunction {
            Probe() {
            }

            public String getName() {
                return "probe";
            }

            public Value call(ValueVector valueVector, Context context) {
                Defrule defrule = (Defrule)context.getEngine().findDefrule("rule-1");
                Assert.assertEquals((String)"Rule logical size", (int)2, (int)defrule.getLogicalNode().getTokenSize());
                LogicalNode logicalNode = defrule.getLogicalNode();
                Assert.assertTrue((boolean)(logicalNode instanceof Node2));
                Assert.assertNotNull((String)"Logical node not set", (Object)logicalNode);
                Map map = logicalNode.getLogicalDependencies();
                Assert.assertNotNull((String)"Logical node not constructed", (Object)map);
                Assert.assertEquals((String)"Dependency not set", (int)1, (int)map.size());
                Fact fact = (Fact)((ArrayList)map.values().iterator().next()).get(0);
                Assert.assertEquals((String)"Wrong fact", (String)fact.getName(), (String)"MAIN::D");
                Token token = (Token)map.keySet().iterator().next();
                Assert.assertEquals((String)"Wrong token", (int)2, (int)token.size());
                Assert.assertEquals((String)"MAIN::B", (String)token.fact(0).getName());
                Assert.assertEquals((String)"MAIN::C", (String)token.fact(1).getName());
                return Funcall.NIL;
            }
        }
        this.m_engine.addUserfunction(new Probe());
        this.m_engine.eval("(defrule rule-1 (logical (B) (C)) (A) => (assert (D)) (probe))");
        this.m_engine.assertFact(new Fact("A", this.m_engine));
        this.m_engine.assertFact(new Fact("B", this.m_engine));
        this.m_engine.assertFact(new Fact("C", this.m_engine));
        this.m_engine.run();
    }

    public void testLogicalNot() throws JessException {
        class Probe
        implements Userfunction {
            Probe() {
            }

            public String getName() {
                return "probe";
            }

            public Value call(ValueVector valueVector, Context context) {
                Defrule defrule = (Defrule)context.getEngine().findDefrule("rule-2");
                Assert.assertEquals((String)"Rule logical size", (int)2, (int)defrule.getLogicalNode().getTokenSize());
                LogicalNode logicalNode = defrule.getLogicalNode();
                Assert.assertTrue((boolean)(logicalNode instanceof NodeNot2));
                Assert.assertNotNull((String)"Logical node not set", (Object)logicalNode);
                Map map = logicalNode.getLogicalDependencies();
                Assert.assertNotNull((String)"Logical node not constructed", (Object)map);
                Assert.assertEquals((String)"Dependency not set", (int)1, (int)map.size());
                Fact fact = (Fact)((ArrayList)map.values().iterator().next()).get(1);
                Assert.assertEquals((String)"MAIN::C", (String)fact.getName());
                return Funcall.NIL;
            }
        }
        this.m_engine.addUserfunction(new Probe());
        this.m_engine.eval("(defrule rule-2 (logical (A) (not (B))) => (assert (C)) (probe))");
        this.m_engine.reset();
        this.m_engine.run();
    }

    public void testAnalyzeCEForUseOfUndefinedVariables() throws Exception {
        Rete rete = new Rete();
        Defrule defrule = new Defrule("foo", "rule", rete);
        Deftemplate deftemplate = rete.createDeftemplate("foo");
        Pattern pattern = new Pattern(deftemplate);
        Funcall funcall = new Funcall("eq", rete);
        funcall.arg(new Value(1, 4));
        funcall.arg(new Variable("x", 8));
        Test1 test1 = new Test1(0, "__data", 0, new FuncallValue(funcall));
        pattern.addTest(test1);
        try {
            defrule.addCE(pattern, rete);
            DefruleTest.fail((String)"Didn't catch expected exception");
        }
        catch (JessException jessException) {
            // empty catch block
        }
    }

    public void testIsTestedSlot() throws Exception {
        Rete rete = new Rete();
        rete.eval("(deftemplate foo (slot a) (slot b))");
        rete.eval("(deftemplate bar (slot c) (slot d))");
        rete.eval("(deftemplate baz (slot e) (slot f))");
        rete.eval("(defrule foo (foo (a 1)) (bar (d 2)) (baz (e 3)) => )");
        Defrule defrule = (Defrule)rete.findDefrule("foo");
        DefruleTest.assertTrue((boolean)defrule.isSlotTested(0, 0));
        DefruleTest.assertFalse((boolean)defrule.isSlotTested(0, 1));
        DefruleTest.assertFalse((boolean)defrule.isSlotTested(1, 0));
        DefruleTest.assertTrue((boolean)defrule.isSlotTested(1, 1));
        DefruleTest.assertTrue((boolean)defrule.isSlotTested(2, 0));
        DefruleTest.assertFalse((boolean)defrule.isSlotTested(2, 1));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

