/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Call;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class Definstance
implements Userfunction,
Serializable {
    Definstance() {
    }

    public String getName() {
        return "definstance";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value call(ValueVector valueVector, Context context) throws JessException {
        boolean bl;
        Value value = valueVector.get(2).resolveValue(context);
        if (value.equals(Funcall.NIL)) {
            throw new JessException("definstance", "Argument is nil:", value.toString());
        }
        Rete rete = context.getEngine();
        String string = valueVector.get(1).stringValue(context);
        Object object = value.javaObjectValue(context);
        if (valueVector.size() == 4) {
            String string2 = valueVector.get(3).symbolValue(context);
            if (string2.equals("dynamic")) {
                bl = true;
                return rete.definstance(string, object, bl, context);
            } else if (string2.equals("static")) {
                bl = false;
                return rete.definstance(string, object, bl, context);
            } else {
                if (!string2.equals("auto")) throw new JessException("definstance", "invalid shadow type", string2);
                bl = Definstance.acceptsPropertyChangeListeners(object, rete);
            }
            return rete.definstance(string, object, bl, context);
        } else {
            bl = Definstance.acceptsPropertyChangeListeners(object, rete);
        }
        return rete.definstance(string, object, bl, context);
    }

    static boolean acceptsPropertyChangeListeners(Object object, Rete rete) throws JessException {
        try {
            if (Call.hasMethodOfName(object.getClass(), "addPropertyChangeListener")) {
                Class clazz = rete.findClass("java.beans.PropertyChangeListener");
                Class[] classArray = new Class[]{clazz};
                object.getClass().getMethod("addPropertyChangeListener", classArray);
                object.getClass().getMethod("removePropertyChangeListener", classArray);
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JessException("definstance", "Class not found", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

