/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import jess.Context;
import jess.Funcall;
import jess.FuncallValue;
import jess.JessException;
import jess.Named;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;
import jess.Visitor;

public class Deffunction
implements Userfunction,
Serializable,
Visitable,
Named {
    private String m_name;
    private String m_docstring = "";
    private ArrayList m_arguments = new ArrayList();
    private ArrayList m_actions = new ArrayList();
    private boolean m_hasWildcard = false;

    public final String getName() {
        return this.m_name;
    }

    public final String getDocstring() {
        return this.m_docstring;
    }

    public final void setDocstring(String string) {
        this.m_docstring = string;
    }

    public Deffunction(String string, String string2) {
        this.m_name = string;
        this.m_docstring = string2;
    }

    public Iterator getArguments() {
        return this.m_arguments.iterator();
    }

    public Iterator getActions() {
        return this.m_actions.iterator();
    }

    public void addArgument(String string, int n) throws JessException {
        this.addArgument(new Argument(string, n));
    }

    public void addArgument(Argument argument) throws JessException {
        if (this.m_hasWildcard) {
            throw new JessException("Deffunction.addArgument", "Deffunction " + this.m_name + " already has a wildcard argument:", argument.getName());
        }
        this.m_arguments.add(argument);
        if (argument.getType() == 8192) {
            this.m_hasWildcard = true;
        }
    }

    public void addAction(Funcall funcall) throws JessException {
        this.m_actions.add(new FuncallValue(funcall));
    }

    public void addValue(Value value) {
        this.m_actions.add(value);
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        Context context2 = context.push();
        context2.clearReturnValue();
        Value value = Funcall.NIL;
        try {
            int n;
            int n2 = this.m_arguments.size() - (this.m_hasWildcard ? 1 : 0);
            if (valueVector.size() < n2 + 1) {
                throw new JessException(this.m_name, "Too few arguments to deffunction", this.m_name);
            }
            block7: for (n = 0; n < this.m_arguments.size(); ++n) {
                Argument argument = (Argument)this.m_arguments.get(n);
                switch (argument.m_type) {
                    case -2: {
                        continue block7;
                    }
                    case 8: {
                        context2.setVariable(argument.m_name, valueVector.get(n + 1).resolveValue(context));
                        continue block7;
                    }
                    case 8192: {
                        ValueVector valueVector2 = new ValueVector();
                        for (int i = n + 1; i < valueVector.size(); ++i) {
                            Value value2 = valueVector.get(i).resolveValue(context);
                            if (value2.type() == 512) {
                                ValueVector valueVector3 = value2.listValue(context);
                                for (int j = 0; j < valueVector3.size(); ++j) {
                                    valueVector2.add(valueVector3.get(j).resolveValue(context));
                                }
                                continue;
                            }
                            valueVector2.add(value2);
                        }
                        context2.setVariable(argument.m_name, new Value(valueVector2, 512));
                    }
                }
            }
            n = this.m_actions.size();
            for (int i = 0; i < n; ++i) {
                value = ((Value)this.m_actions.get(i)).resolveValue(context2);
                if (!context2.returning()) continue;
                value = context2.getReturnValue();
                context2.clearReturnValue();
                break;
            }
        }
        catch (JessException jessException) {
            jessException.addContext("deffunction " + this.m_name);
            throw jessException;
        }
        return value.resolveValue(context2);
    }

    public String toString() {
        return "[deffunction " + this.m_name + "]";
    }

    public Object accept(Visitor visitor) {
        return visitor.visitDeffunction(this);
    }

    public final String getConstructType() {
        return "deffunction";
    }

    public static class Argument
    implements Serializable {
        String m_name;
        int m_type;

        Argument(String string, int n) {
            this.m_name = string;
            this.m_type = n;
        }

        public String getName() {
            return this.m_name;
        }

        public int getType() {
            return this.m_type;
        }
    }
}

