/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Advice;
import jess.AfterAdvice;
import jess.BeforeAdvice;
import jess.Context;
import jess.Funcall;
import jess.FunctionHolder;
import jess.JessException;
import jess.ListFunctions;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class Defadvice
implements Userfunction,
Serializable {
    static final String BEFORE = "before";
    static final String AFTER = "after";
    static final String ADVICE = "defadvice";
    static final String UNADVICE = "undefadvice";
    private String m_name;

    public String getName() {
        return this.m_name;
    }

    Defadvice(String string) {
        this.m_name = string;
    }

    private ValueVector functionList(Value value, Rete rete) throws JessException {
        switch (value.type()) {
            case 512: {
                return value.listValue(null);
            }
            case 1: {
                if (!value.equals("ALL")) break;
                return ListFunctions.toValueVector(ListFunctions.listAllFunctions(rete));
            }
        }
        ValueVector valueVector = new ValueVector();
        valueVector.add(value);
        return valueVector;
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        Rete rete = context.getEngine();
        if (this.m_name.equals(ADVICE)) {
            String string = valueVector.get(1).stringValue(context);
            ValueVector valueVector2 = this.functionList(valueVector.get(2).resolveValue(context), rete);
            for (int i = 0; i < valueVector2.size(); ++i) {
                FunctionHolder functionHolder = rete.findFunctionHolder(valueVector2.get(i).symbolValue(context));
                if (functionHolder == null) {
                    throw new JessException("Defadvice.call", "Cannot advice a function before defining it", this.m_name);
                }
                Userfunction userfunction = functionHolder.stripAdvice();
                if (userfunction == null) {
                    throw new JessException("Defadvice.call", "Cannot advice a function before defining it", this.m_name);
                }
                Advice advice = string.equals(BEFORE) ? new BeforeAdvice(userfunction) : new AfterAdvice(userfunction);
                for (int j = 3; j < valueVector.size(); ++j) {
                    advice.addAction(valueVector.get(j));
                }
                rete.addUserfunction(advice);
            }
        } else {
            ValueVector valueVector3 = this.functionList(valueVector.get(1).resolveValue(context), rete);
            for (int i = 0; i < valueVector3.size(); ++i) {
                FunctionHolder functionHolder = rete.findFunctionHolder(valueVector3.get(i).symbolValue(context));
                if (functionHolder == null) {
                    throw new JessException("Defadvice.call", "Cannot advice a function before defining it", this.m_name);
                }
                Userfunction userfunction = functionHolder.stripAdvice();
                if (userfunction == null) {
                    throw new JessException("Defadvice.call", "Cannot advice a function before defining it", this.m_name);
                }
                rete.addUserfunction(userfunction);
            }
        }
        return Funcall.TRUE;
    }
}

