/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.ArrayList;
import java.util.Iterator;
import jess.AccumulateFact;
import jess.Activation;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.Token;
import junit.framework.TestCase;

public class AccumulateTest
extends TestCase {
    public void testResolveVariableInitialValue() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule(A ?Y ?I)?a <- (accumulate (bind ?sum ?I) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>(store A ?a))");
        rete.assertString("(B 1 1)");
        rete.assertString("(B 1 2)");
        rete.assertString("(B 1 3)");
        rete.assertString("(A 1 23)");
        rete.run();
        AccumulateTest.assertEquals((int)29, (int)rete.fetch("A").intValue(null));
    }

    public void testVariableNotDefined() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule(A ?Y)(accumulate (bind ?sum 0) (bind ?sum (+ ?sum 1)) ?sum (B ?Y ?X))=>(printout t ?X crlf))");
        rete.assertString("(B 1 1)");
        rete.assertString("(A 1)");
        try {
            rete.run();
            AccumulateTest.fail((String)"Didn't get expected exception");
        }
        catch (JessException jessException) {
            AccumulateTest.assertTrue((jessException.toString().indexOf("No such variable X") > -1 ? 1 : 0) != 0);
        }
    }

    public void testBoundName() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule(A ?Y)?a <- (accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>(store A ?a))");
        rete.assertString("(B 1 1)");
        rete.assertString("(B 1 2)");
        rete.assertString("(B 1 3)");
        rete.assertString("(B 1 4)");
        rete.assertString("(A 1)");
        rete.run();
        AccumulateTest.assertEquals((int)10, (int)rete.fetch("A").intValue(null));
    }

    public void testAccumulateResultFromLeft() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule(A ?Y)(accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>)");
        rete.assertString("(B 1 1)");
        rete.assertString("(B 1 2)");
        rete.assertString("(B 1 3)");
        rete.assertString("(B 2 5)");
        rete.assertString("(B 2 6)");
        rete.assertString("(B 2 7)");
        rete.assertString("(A 1)");
        Defrule defrule = (Defrule)rete.findDefrule("rule");
        Iterator iterator = rete.listActivations();
        Activation activation = (Activation)iterator.next();
        AccumulateTest.assertFalse((boolean)iterator.hasNext());
        AccumulateTest.assertSame((Object)defrule, (Object)activation.getRule());
        Token token = activation.getToken();
        Fact fact = token.topFact();
        AccumulateTest.assertSame((Object)Deftemplate.getAccumTemplate(), (Object)fact.getDeftemplate());
        AccumulateTest.assertEquals((int)6, (int)fact.getSlotValue("value").intValue(null));
    }

    public void testAccumulateResultFromRight() throws Exception {
        Rete rete = new Rete();
        rete.store("A", new ArrayList());
        rete.eval("(defrule rule(A ?Y)?a <- (accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>((fetch A) add ?a))");
        rete.assertString("(A 1)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        rete.assertString("(B 1 1)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        rete.assertString("(B 1 2)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        rete.assertString("(B 1 3)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        ArrayList arrayList = (ArrayList)rete.fetch("A").javaObjectValue(null);
        AccumulateTest.assertEquals((int)4, (int)arrayList.size());
        AccumulateTest.assertEquals((Object)new Integer(0), arrayList.get(0));
        AccumulateTest.assertEquals((Object)new Integer(1), arrayList.get(1));
        AccumulateTest.assertEquals((Object)new Integer(3), arrayList.get(2));
        AccumulateTest.assertEquals((Object)new Integer(6), arrayList.get(3));
    }

    public void testPruneDuplicates() throws Exception {
        Rete rete = new Rete();
        rete.store("A", new ArrayList());
        rete.eval("(defrule rule ?a <- (accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?X))=>((fetch A) add ?a))");
        rete.reset();
        rete.assertString("(B 1)");
        rete.assertString("(B 2)");
        rete.assertString("(B 3)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        ArrayList arrayList = (ArrayList)rete.fetch("A").javaObjectValue(null);
        AccumulateTest.assertEquals((int)1, (int)arrayList.size());
        AccumulateTest.assertEquals((Object)new Integer(6), arrayList.get(0));
    }

    public void testDeactivateLeft() throws Exception {
        Rete rete = new Rete();
        rete.store("A", new ArrayList());
        rete.eval("(defrule rule(A ?Y)?a <- (accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>)");
        rete.assertString("(A 1)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        rete.assertString("(B 1 1)");
        AccumulateTest.assertTrue((boolean)rete.listActivations().hasNext());
        rete.retractString("(A 1)");
        AccumulateTest.assertEquals((int)0, (int)rete.run());
    }

    public void testDeactivateRight() throws Exception {
        Rete rete = new Rete();
        rete.store("A", new ArrayList());
        rete.eval("(defrule rule(A ?Y)?a <- (accumulate (bind ?sum 0) (bind ?sum (+ ?sum ?X)) ?sum (B ?Y ?X))=>)");
        rete.assertString("(A 1)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
        rete.assertString("(B 1 1)");
        AccumulateTest.assertTrue((boolean)rete.listActivations().hasNext());
        rete.retractString("(B 1 1)");
        AccumulateTest.assertEquals((int)1, (int)rete.run());
    }

    public void testAccumulateFactEquality() throws Exception {
        Rete rete = new Rete();
        Fact fact = rete.assertString("(fact-1)");
        Token token = Rete.getFactory().newToken(fact, 0);
        Token token2 = Rete.getFactory().newToken(token, new AccumulateFact());
        AccumulateFact accumulateFact = new AccumulateFact();
        accumulateFact.setSlotValue("value", Funcall.FALSE);
        Token token3 = Rete.getFactory().newToken(token, accumulateFact);
        AccumulateTest.assertEquals((Object)token2, (Object)token3);
    }

    public void testCount() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule(A ?Y)(accumulate (bind ?count 0) (bind ?count (+ ?count 1)) ?count (B ?Y ?X))=>)");
        rete.assertString("(B 1 1)");
        rete.assertString("(B 1 2)");
        rete.assertString("(B 1 3)");
        rete.assertString("(B 2 5)");
        rete.assertString("(B 2 6)");
        rete.assertString("(B 2 7)");
        rete.assertString("(A 1)");
        Defrule defrule = (Defrule)rete.findDefrule("rule");
        Iterator iterator = rete.listActivations();
        Activation activation = (Activation)iterator.next();
        AccumulateTest.assertFalse((boolean)iterator.hasNext());
        AccumulateTest.assertSame((Object)defrule, (Object)activation.getRule());
        Token token = activation.getToken();
        Fact fact = token.topFact();
        AccumulateTest.assertSame((Object)Deftemplate.getAccumTemplate(), (Object)fact.getDeftemplate());
        AccumulateTest.assertEquals((int)3, (int)fact.getSlotValue("value").intValue(null));
    }
}

