/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.Map;
import java.util.Set;
import jess.BindingValue;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Funcall;
import jess.Group;
import jess.JessException;
import jess.Pattern;
import jess.PatternIterator;
import jess.Value;
import jess.Variable;
import jess.Visitable;
import jess.Visitor;

public class Accumulate
implements ConditionalElement,
ConditionalElementX,
Visitable {
    private ConditionalElementX m_pattern;
    private Value m_body;
    private Value m_initializer;
    private Value m_return;
    private String m_boundName;
    public static String RESULT = "accumulate-result";

    public void setBoundName(String string) throws JessException {
        this.m_boundName = string;
    }

    public void setNegated() throws JessException {
        throw new JessException("Accumulate.setExplicit", "accumulate can't be enclosed by", "negated");
    }

    public void setExplicit() throws JessException {
        throw new JessException("Accumulate.setExplicit", "accumulate can't be enclosed by", "explicit");
    }

    public void setLogical() throws JessException {
        throw new JessException("Accumulate.setLogical", "accumulate can't be enclosed by", "logical");
    }

    public boolean getLogical() {
        return false;
    }

    public boolean getNegated() {
        return false;
    }

    public ConditionalElementX canonicalize() throws JessException {
        return this;
    }

    public boolean getBackwardChaining() {
        return false;
    }

    public void addToGroup(Group group) throws JessException {
        group.add((Accumulate)this.clone());
    }

    public void addDirectlyMatchedVariables(Set set) throws JessException {
        if (this.getBoundName() != null) {
            set.add(this.getBoundName());
        }
    }

    public void renameUnmentionedVariables(Set set, Map map, int n) throws JessException {
        this.m_pattern.renameUnmentionedVariables(set, map, n);
        this.m_body = this.substExpression(this.m_body, map);
        this.m_initializer = this.substExpression(this.m_initializer, map);
        this.m_return = this.substExpression(this.m_return, map);
    }

    public void recordTestedSlots(int n, Set set) {
        this.m_pattern.recordTestedSlots(n, set);
    }

    private Value substExpression(Value value, Map map) throws JessException {
        switch (value.type()) {
            case 8: 
            case 8192: {
                String string = value.variableValue(null);
                if (map.get(string) == null) break;
                value = new Variable((String)map.get(string), 8);
                break;
            }
            case 64: {
                Funcall funcall = value.funcallValue(null);
                for (int i = 0; i < funcall.size(); ++i) {
                    funcall.set(this.substExpression(funcall.get(i), map), i);
                }
                break;
            }
        }
        return value;
    }

    public boolean isBackwardChainingTrigger() {
        return false;
    }

    public int getPatternCount() {
        return 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return "accumulate";
    }

    public String getBoundName() {
        return this.m_boundName;
    }

    public int getGroupSize() {
        return 1;
    }

    public ConditionalElementX getConditionalElementX(int n) {
        if (n == 0) {
            return this.m_pattern;
        }
        return null;
    }

    public boolean isGroup() {
        return true;
    }

    public void add(ConditionalElementX conditionalElementX) {
        this.m_pattern = conditionalElementX;
    }

    public ConditionalElement getConditionalElement(int n) {
        return this.getConditionalElementX(n);
    }

    public void setBody(Value value) {
        this.m_body = value;
    }

    public Value getBody() {
        return this.m_body;
    }

    public Value getInitializer() {
        return this.m_initializer;
    }

    public Value getReturn() {
        return this.m_return;
    }

    public void setInitializer(Value value) {
        this.m_initializer = value;
    }

    public void setReturn(Value value) {
        this.m_return = value;
    }

    public Object accept(Visitor visitor) {
        return visitor.visitAccumulate(this);
    }

    void setupBindingValue(Map map, Map map2) throws JessException {
        this.m_return = this.bindValue(map, this.m_return, map2);
        this.m_body = this.bindValue(map, this.m_body, map2);
        this.m_initializer = this.bindValue(map, this.m_initializer, map2);
    }

    private Value bindValue(Map map, Value value, Map map2) throws JessException {
        if (value.type() == 8 || value.type() == 8192) {
            String string = value.variableValue(null);
            BindingValue bindingValue = (BindingValue)map.get(string);
            if (bindingValue == null) {
                bindingValue = (BindingValue)map2.get(string);
            }
            if (bindingValue == null) {
                return value;
            }
            return new BindingValue(bindingValue);
        }
        if (value.type() == 64) {
            Funcall funcall = value.funcallValue(null);
            for (int i = 0; i < funcall.size(); ++i) {
                funcall.set(this.bindValue(map, funcall.get(i), map2), i);
            }
            return value;
        }
        return value;
    }

    public void findVariableDefinitions(int n, Map map, Map map2) throws JessException {
        Object object;
        if (this.m_boundName != null) {
            object = new BindingValue(this.m_boundName, this, n, 0, -1, 0);
            map2.put(this.m_boundName, object);
        }
        object = new PatternIterator(this.m_pattern);
        int n2 = n;
        while (((PatternIterator)object).hasNext()) {
            Pattern pattern = (Pattern)((PatternIterator)object).next();
            pattern.findVariableDefinitions(n2, map, map2);
            ++n2;
        }
        this.setupBindingValue(map, map2);
    }
}

