/*
 * Decompiled with CFR 0.152.
 */
package araword.configuration;

import araword.G;
import araword.configuration.TLanguage;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TSetup {
    private static String CONFIGURATION_SYSTEM_FILE_PATH = "." + File.separator + "conf" + File.separator + "AWSystem.conf";
    private static String CONFIGURATION_USER_FILE_PATH = "." + File.separator + "conf" + File.separator + "AWUserDefaults.conf";
    private static File CONFIGURATION_SYSTEM_FILE = new File(CONFIGURATION_SYSTEM_FILE_PATH);
    private static File CONFIGURATION_USER_FILE = new File(CONFIGURATION_USER_FILE_PATH);

    public static void load() {
        Element root;
        Document docXML;
        File fileXML = CONFIGURATION_SYSTEM_FILE;
        SAXBuilder builder = new SAXBuilder(false);
        try {
            Element e;
            docXML = builder.build(fileXML);
            root = docXML.getRootElement();
            List languages = root.getChild("applicationLanguages").getChildren("language");
            Iterator j = languages.iterator();
            G.applicationLanguages = new String[languages.size()];
            int i = 0;
            while (j.hasNext()) {
                Element e2 = (Element)j.next();
                G.applicationLanguages[i] = e2.getText();
                ++i;
            }
            List tts = root.getChild("tts_options").getChildren("tts_option");
            Iterator jtts = tts.iterator();
            G.ttsOptions = new String[tts.size()];
            int k = 0;
            while (jtts.hasNext()) {
                e = (Element)jtts.next();
                G.ttsOptions[k] = e.getText();
                ++k;
            }
            languages = root.getChild("documentLanguages").getChildren("language");
            j = languages.iterator();
            G.documentLanguages = new String[languages.size()];
            i = 0;
            while (j.hasNext()) {
                e = (Element)j.next();
                G.documentLanguages[i] = e.getText();
                ++i;
            }
            List wordTypes = root.getChild("wordTypeColors").getChildren("wordtype");
            for (Element element : wordTypes) {
                String key = element.getAttributeValue("id");
                Element color = element.getChild("color");
                Element r = color.getChild("r");
                int red = Integer.parseInt(r.getText());
                Element g = color.getChild("g");
                int green = Integer.parseInt(g.getText());
                Element b = color.getChild("b");
                int blue = Integer.parseInt(b.getText());
                G.borders.put(key, new CompoundBorder(new EmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(new Color(red, green, blue), 3)));
            }
            Element element = root.getChild("databaseName");
            G.databaseName = element.getText();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        fileXML = CONFIGURATION_USER_FILE;
        builder = new SAXBuilder(false);
        try {
            String language;
            Element b;
            String language2;
            docXML = builder.build(fileXML);
            root = docXML.getRootElement();
            Element preferencesElement = root.getChild("preferences");
            List list = preferencesElement.getChildren("applicationLanguage");
            for (Element element : list) {
                String language22 = element.getText();
                if (language22 == null || !TLanguage.languageExists(language22)) continue;
                G.applicationLanguage = language22;
            }
            list = preferencesElement.getChildren("documentLanguage");
            for (Element element : list) {
                language2 = element.getText();
                if (language2 == null) continue;
                G.defaultDocumentLanguage = language2;
            }
            list = preferencesElement.getChildren("imagesSize");
            for (Element element : list) {
                String imageSize = element.getText();
                if (imageSize == null) continue;
                G.defaultImagesSize = Integer.parseInt(imageSize);
            }
            list = preferencesElement.getChildren("showBorders");
            for (Element element : list) {
                language2 = element.getText();
                if (language2 == null) continue;
                G.showBorders = language2.equals("yes");
            }
            Element ttsRate = preferencesElement.getChild("ttsRate");
            if (ttsRate != null) {
                String ttsRateValue = ttsRate.getText();
                G.ttsRate = Integer.parseInt(ttsRateValue);
            }
            list = preferencesElement.getChildren("ttsoption");
            for (Element element : list) {
                String tts = element.getText();
                if (tts == null) continue;
                G.defaultTTS = tts;
            }
            list = preferencesElement.getChildren("classicIcons");
            for (Element element : list) {
                String language3 = element.getText();
                if (language3 == null) continue;
                G.classicIcons = language3.equals("yes");
            }
            list = preferencesElement.getChildren("iconsSize");
            for (Element element : list) {
                String language4 = element.getText();
                if (language4 == null) continue;
                G.iconsSize = Integer.parseInt(language4);
            }
            Color iconBorderColor = null;
            list = preferencesElement.getChildren("iconsBorderColor");
            for (Element color : list) {
                Element r = color.getChild("r");
                int n = Integer.parseInt(r.getText());
                Element g = color.getChild("g");
                int green = Integer.parseInt(g.getText());
                b = color.getChild("b");
                int blue = Integer.parseInt(b.getText());
                iconBorderColor = new Color(n, green, blue);
            }
            list = preferencesElement.getChildren("iconsBorderSize");
            for (Element element : list) {
                String borderSize = element.getText();
                if (borderSize == null) continue;
                G.iconsBorderSize = Integer.parseInt(borderSize);
                if (G.borders == null) continue;
                for (Map.Entry entry : G.borders.entrySet()) {
                    entry.setValue(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(iconBorderColor, G.iconsBorderSize)));
                }
            }
            list = preferencesElement.getChildren("maxLengthCompoundWords");
            for (Element element : list) {
                language = element.getText();
                if (language == null) continue;
                G.maxLengthCompoundWords = Integer.parseInt(language);
            }
            list = preferencesElement.getChildren("maxUndoLevel");
            for (Element element : list) {
                language = element.getText();
                if (language == null) continue;
                G.maxUndoLevel = Integer.parseInt(language);
            }
            list = preferencesElement.getChildren("font");
            Iterator l = list.iterator();
            while (l.hasNext()) {
                boolean bl;
                String name2;
                String name = "";
                int size = 12;
                boolean bl2 = false;
                boolean italic = false;
                Element element = (Element)l.next();
                List list2 = element.getChildren("name");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    name = name2;
                }
                list2 = element.getChildren("size");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    size = Integer.parseInt(name2);
                }
                list2 = element.getChildren("bold");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    bl = name2.equals("yes");
                }
                list2 = element.getChildren("italic");
                for (Element element2 : list2) {
                    name2 = element2.getText();
                    if (name2 == null) continue;
                    italic = name2.equals("yes");
                }
                int style = 0;
                if (bl) {
                    style ^= 1;
                }
                if (italic) {
                    style ^= 2;
                }
                G.defaultFont = new Font(name, style, size);
            }
            list = preferencesElement.getChildren("color");
            for (Element e : list) {
                Element r = e.getChild("r");
                int n = Integer.parseInt(r.getText());
                Element g = e.getChild("g");
                int green = Integer.parseInt(g.getText());
                b = e.getChild("b");
                int blue = Integer.parseInt(b.getText());
                G.defaultColor = new Color(n, green, blue);
            }
            list = preferencesElement.getChildren("textBelowPictogram");
            for (Element element : list) {
                String language5 = element.getText();
                if (language5 == null) continue;
                G.defaultTextBelowPictogram = language5.equals("yes");
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static void save() {
        try {
            Element config = new Element("config");
            Element preferences = new Element("preferences");
            Element applicationLanguage = new Element("applicationLanguage");
            applicationLanguage.addContent(G.applicationLanguage);
            preferences.addContent((Content)applicationLanguage);
            Element documentLanguage = new Element("documentLanguage");
            documentLanguage.addContent(G.defaultDocumentLanguage);
            preferences.addContent((Content)documentLanguage);
            Element tts = new Element("ttsoption");
            tts.addContent(G.defaultTTS);
            preferences.addContent((Content)tts);
            Element ttsRate = new Element("ttsRate");
            String ttsRateValue = Integer.toString(G.ttsRate);
            ttsRate.addContent(ttsRateValue);
            preferences.addContent((Content)ttsRate);
            Element showBorders = new Element("showBorders");
            showBorders.addContent("no");
            preferences.addContent((Content)showBorders);
            Element imagesSize = new Element("imagesSize");
            imagesSize.addContent(Integer.toString(G.defaultImagesSize));
            preferences.addContent((Content)imagesSize);
            Element classicIcons = new Element("classicIcons");
            if (G.classicIcons) {
                classicIcons.addContent("yes");
            }
            preferences.addContent((Content)classicIcons);
            Element iconsSize = new Element("iconsSize");
            iconsSize.addContent(Integer.toString(G.iconsSize));
            preferences.addContent((Content)iconsSize);
            Element iconsBorderColor = new Element("iconsBorderColor");
            Element rBorderColor = new Element("r");
            Element gBorderColor = new Element("g");
            Element bBorderColor = new Element("b");
            if (G.borders != null) {
                Iterator<Map.Entry<String, Border>> iterator = G.borders.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, Border> entry = iterator.next();
                    LineBorder border = (LineBorder)((CompoundBorder)entry.getValue()).getInsideBorder();
                    Color borderColor = border.getLineColor();
                    rBorderColor.addContent(Integer.toString(borderColor.getRed()));
                    gBorderColor.addContent(Integer.toString(borderColor.getGreen()));
                    bBorderColor.addContent(Integer.toString(borderColor.getBlue()));
                }
            } else {
                rBorderColor.addContent("0");
                gBorderColor.addContent("0");
                bBorderColor.addContent("0");
            }
            iconsBorderColor.addContent((Content)rBorderColor);
            iconsBorderColor.addContent((Content)gBorderColor);
            iconsBorderColor.addContent((Content)bBorderColor);
            preferences.addContent((Content)iconsBorderColor);
            Element iconsBorderSize = new Element("iconsBorderSize");
            iconsBorderSize.addContent(Integer.toString(G.iconsBorderSize));
            preferences.addContent((Content)iconsBorderSize);
            Element maxLengthCompoundWords = new Element("maxLengthCompoundWords");
            maxLengthCompoundWords.addContent(Integer.toString(G.maxLengthCompoundWords));
            preferences.addContent((Content)maxLengthCompoundWords);
            Element maxUndoLevel = new Element("maxUndoLevel");
            maxUndoLevel.addContent(Integer.toString(G.maxUndoLevel));
            preferences.addContent((Content)maxUndoLevel);
            Element font = new Element("font");
            Element name = new Element("name");
            name.addContent(G.defaultFont.getName());
            font.addContent((Content)name);
            Element size = new Element("size");
            size.addContent(Integer.toString(G.defaultFont.getSize()));
            font.addContent((Content)size);
            Element bold = new Element("bold");
            if (G.defaultFont.isBold()) {
                bold.addContent("yes");
            } else {
                bold.addContent("no");
            }
            font.addContent((Content)bold);
            Element italic = new Element("italic");
            if (G.defaultFont.isItalic()) {
                italic.addContent("yes");
            } else {
                italic.addContent("no");
            }
            font.addContent((Content)italic);
            preferences.addContent((Content)font);
            Element color = new Element("color");
            Element r = new Element("r");
            r.addContent(Integer.toString(G.defaultColor.getRed()));
            color.addContent((Content)r);
            Element g = new Element("g");
            g.addContent(Integer.toString(G.defaultColor.getGreen()));
            color.addContent((Content)g);
            Element b = new Element("b");
            b.addContent(Integer.toString(G.defaultColor.getBlue()));
            color.addContent((Content)b);
            preferences.addContent((Content)color);
            Element textBelowPictogram = new Element("textBelowPictogram");
            if (G.defaultTextBelowPictogram) {
                textBelowPictogram.addContent("yes");
            } else {
                textBelowPictogram.addContent("no");
            }
            preferences.addContent((Content)textBelowPictogram);
            config.addContent((Content)preferences);
            Document doc = new Document(config);
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            FileOutputStream f = new FileOutputStream(CONFIGURATION_USER_FILE_PATH);
            out.output(doc, (OutputStream)f);
            f.flush();
            f.close();
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    public static String getImagesFolder() {
        return G.pictogramsPath;
    }
}

