/*
 * Decompiled with CFR 0.152.
 */
package de.humatic.dsj;

import de.humatic.dsj.DSEnvironment;
import de.humatic.dsj.DSFilter;
import de.humatic.dsj.DSFilterInfo;
import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import de.humatic.dsj.DSMediaType;
import de.humatic.dsj.MovieTrack;
import de.humatic.dsj.au;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSMovie
extends DSFiltergraph {
    private int s;
    private int t;
    private int u;
    private boolean A;
    private boolean B = true;
    private boolean C;
    private boolean D = true;
    String savePath;
    public static final int INIT_EDITABLE = 2048;
    public static final int DES_SRE = 8192;
    public static final int TIME_FORMAT_MSEC = 0;
    public static final int TIME_FORMAT_FRAMES = 1;
    private Vector c;

    DSMovie() {
    }

    public DSMovie(String string, int n2, PropertyChangeListener propertyChangeListener) {
        if (string == null || string.length() < 4 || string.substring(string.lastIndexOf(File.separator) + 1, string.length()).equalsIgnoreCase("null")) {
            throw new DSJException("Invalid file, DSMovie construction failed", -11);
        }
        try {
            if (string.indexOf("://") < 0) {
                string = new File(string).getAbsolutePath();
            }
            if (string.indexOf("%20") != -1) {
                string = DSJUtils.urlDecode(string);
            }
        }
        catch (Exception exception) {
            throw new DSJException("Invalid file, DSMovie construction failed", -40);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(string, n2, null, null);
    }

    public DSMovie(String string, int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2, PropertyChangeListener propertyChangeListener) {
        if (string == null || string.length() < 4 || string.substring(string.lastIndexOf(File.separator) + 1, string.length()).equalsIgnoreCase("null")) {
            throw new DSJException("Invalid file, DSMovie construction failed", -11);
        }
        try {
            if (string.indexOf(":/") < 0) {
                string = new File(string).getAbsolutePath();
            }
            if (string.indexOf("%20") != -1) {
                string = DSJUtils.urlDecode(string);
            }
        }
        catch (Exception exception) {
            throw new DSJException("Invalid file, DSMovie construction failed", -40);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
        this.a(string, n2, dSFilterInfo, dSFilterInfo2);
    }

    private void a(String stringArray, int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2) {
        this.a(n2);
        if ((n2 & 0x800) != 0 || stringArray.indexOf(".xtl") > 0) {
            this.a((String)stringArray, n2);
            return;
        }
        if (this.g) {
            this.setIgnoreRepaint(true);
            this.setVisible(false);
        }
        this.type = 0;
        this.a = stringArray;
        this.j = n2;
        try {
            this.a = this.initInstance(0);
            DSJUtils.logln(2, "Java - inited(): " + this.a);
            if (!this.initializeGraph(this.a, DSEnvironment.b())) {
                throw new DSJException("dsj, can not initialize", -1);
            }
            this.f = this.setupDSMovie(this.a, this.a, n2, dSFilterInfo, dSFilterInfo2);
        }
        catch (Exception exception) {
            this.e = true;
            throw new DSJException("dsj, unknown error in dll", -1);
        }
        if (this.f < 0) {
            this.e = true;
            String string = "DSMovie construction failed, errorCode: " + this.f;
            if (this.f < -10000) {
                string = "DSMovie construction failed, errorCode: " + DSJException.hresultToHexString(this.f);
            }
            if (this.f == -10) {
                string = "DSMovie: can't find decoder.";
            } else if (this.f == -15) {
                string = "DSMovie: can't find audio codec.";
            } else if (this.f == -14) {
                string = "DSMovie: can't connect to sink, colorspace mismatch, no converter found";
            } else if (this.f == -18) {
                string = "DSMovie: can't instantiate VMR";
            } else if (this.f == -104) {
                string = "DSMovie: can't handle protocol: " + this.a;
            }
            if (this.f == -1072887838 || this.f == -1072889818 || this.f < -10000 && DSEnvironment.d() >= 6 && stringArray.indexOf(".asx") != -1) {
                DSJUtils.logln(2, "DSMovie, stream not recognized: " + this.f);
                this.f = -17;
            }
            if (this.f == -17) {
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                try {
                    new StringBuffer();
                    stringArray = null;
                    stringArray = null;
                    try {
                        stringArray = new URL(this.a);
                        stringArray = stringArray.openStream();
                    }
                    catch (MalformedURLException malformedURLException) {
                        stringArray = new FileInputStream(new File(this.a).getAbsoluteFile());
                    }
                    byte[] byArray = new byte[stringArray.available()];
                    stringArray.read(byArray, 0, byArray.length);
                    stringArray = new String(byArray);
                    stringArray = DSMovie.a((String)stringArray);
                    if (stringArray.length != 0) {
                        this.e = false;
                        this.a(stringArray, 16, 2);
                        this.a(stringArray[0], n2, dSFilterInfo, dSFilterInfo2);
                        return;
                    }
                    string = "DSMovie: can't read URLs from xml playlist";
                }
                catch (Exception exception) {}
            }
            this.dispose();
            if (this.f != -17) {
                throw new DSJException(string, this.f);
            }
            return;
        }
        if ((this.f & 2) != 0) {
            this.o = false;
            this.j = n2 ^ 2;
        }
        if ((this.f & 8) != 0) {
            this.o = false;
            this.a(-15, 12);
        }
        if (this.o) {
            try {
                this.a = new DSFiltergraph.DSAudioStream(this);
            }
            catch (Exception exception) {
                this.o = false;
                throw new DSJException("error in dll, can't deliver audio.", -20);
            }
        }
        if (this.f == 1) {
            this.a = true;
            this.a = 400;
            this.b = 0;
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.b();
            this.d = true;
            return;
        }
        if (this.k) {
            this.e();
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.d = true;
            return;
        }
        if (this.l || this.m) {
            this.e();
            this.getMovieInfo(this.a, this.a);
            this.b();
            this.a(this.a);
            this.d = true;
            return;
        }
        try {
            while (this.getBufferSize(this.a) == 0) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {}
        this.e();
        this.a = this.b[0];
        this.b = this.b[1];
        this.c = (Vector)this.a;
        this.d = this.b;
        this.getMovieInfo(this.a, this.a);
        this.b();
        stringArray = this;
        this.a(stringArray.a);
        this.d = true;
        if (!(this.g || this.i || this.h || this.n)) {
            return;
        }
        this.setName(String.valueOf(this.a));
        this.c();
    }

    final void a() {
        this.a = -1L;
    }

    public String getCurrentFile() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadFile(String string, int n2) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.getEditable()) {
            throw new DSJException("DSMovie: operation not supported when editable.", -51);
        }
        if (string.indexOf("mms") < 0 && !new File(string).exists()) {
            throw new DSJException("DSMovie: file not found.", -9);
        }
        int n3 = 0;
        try {
            string = new File(string).getAbsolutePath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.a();
        synchronized (object) {
            n3 = this.setMovieFile(this.a, string, n2);
            if (n3 >= 0) {
                this.getMovieInfo(this.a, this.a);
                this.a = string;
            }
        }
        if (n3 < 0) {
            this.e = true;
            this.dispose();
            throw new DSJException("DSMovie: can't load new file into existing graph.", n3);
        }
        return n3;
    }

    public int loadFile(String string) {
        return this.loadFile(string, -1);
    }

    public void setSelection(int n2, int n3) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (n2 > n3 || n3 > this.getDuration() || n2 < 0) {
            throw new DSJException("DSMovie: invalid selction times (in: " + n2 + ", out: " + n3 + ", dur: " + this.getDuration() + ")", -121);
        }
        this.s = n2;
        this.t = n3;
        DSMovie dSMovie = this;
        this.nativeSetSelection(dSMovie.a, this.s, this.t, this.getEditable() ? 1 : 0);
    }

    public int getSelectionStart() {
        return this.s;
    }

    public int getSelectionEnd() {
        return this.t;
    }

    public void setPlaySelection(boolean bl) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.s >= this.t || this.t > this.getDuration() || this.s < 0) {
            throw new DSJException("DSMovie: invalid selction times", -121);
        }
        this.A = bl;
        DSMovie dSMovie = this;
        this.nativeSetPlaySelection(dSMovie.a, bl, this.getEditable() ? 1 : 0);
    }

    public boolean getPlaySelection() {
        return this.A;
    }

    public void setRecueOnStop(boolean bl) {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        this.B = bl;
        DSMovie dSMovie = this;
        this.nativeSetRecue(dSMovie.a, bl, this.getEditable() ? 1 : 0);
    }

    public boolean getRecueOnStop() {
        return this.B;
    }

    public void setTimeFormat(int n2) {
        if (this.C) {
            return;
        }
        int n3 = this.nativeSetParameter(this.getID(), -1, 0, n2);
        if (n3 == 0) {
            this.u = n2;
            DSMovie dSMovie = this;
            this.getMovieInfo(dSMovie.a, this.a);
            return;
        }
        throw new DSJException("Can't change time format " + DSJException.hresultToHexString(n3), n3);
    }

    public int getTimeFormat() {
        return this.u;
    }

    public BufferedImage getThumbnail(int n2, int n3) {
        int n4 = (int)((float)n3 * ((float)this.b / (float)this.a));
        byte[] byArray = new byte[n3 * n4 * 3 + 40];
        int n5 = n3 * 3;
        DSMovie dSMovie = this;
        int n6 = this.nativeGetMovieIcon(dSMovie.a, new int[]{-1, n2, n3, n4, byArray.length}, byArray);
        if (n6 > 0) {
            byArray = new byte[n6];
            if (n6 - n3 * n4 * 3 != 40) {
                n5 = (n6 - 40) / n4;
            }
            DSMovie dSMovie2 = this;
            n6 = this.nativeGetMovieIcon(dSMovie2.a, new int[]{-1, n2, n3, n4, byArray.length}, byArray);
        }
        if (n6 < 0) {
            throw new DSJException("failed to get thumbnail: " + DSJException.hresultToHexString(n6), n6);
        }
        boolean bl = DSJUtils.readInt_LE(byArray, 8, 4) > 0;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 5);
        WritableRaster writableRaster = bufferedImage.getWritableTile(n3, n4);
        if (n5 == n3 * 3) {
            System.arraycopy(byArray, 40, ((DataBufferByte)writableRaster.getDataBuffer()).getData(), 0, n3 * n4 * 3);
        } else {
            int n7 = 40;
            int n8 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                System.arraycopy(byArray, n7, ((DataBufferByte)writableRaster.getDataBuffer()).getData(), n8, n3 * 3);
                n7 += n5;
                n8 += n3 * 3;
            }
        }
        if (bl) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform.translate(0.0, -n4);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            return affineTransformOp.filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    native int nativeGetMovieIcon(long var1, int[] var3, byte[] var4);

    public void setEditable(boolean bl) {
        if (this.C) {
            return;
        }
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        boolean bl2 = this.getRate() != 0.0f;
        int n2 = this.getTime();
        if (this.a != null) {
            this.a.a();
        }
        this.d = false;
        this.q = false;
        DSMovie dSMovie = this;
        this.stopDS(dSMovie.a);
        dSMovie = this;
        this.releaseGraph(dSMovie.a, false, DSEnvironment.getEnvironmentFlags());
        DSEnvironment.unregisterGraph(this);
        dSMovie = this;
        this.a = -1L;
        int n3 = this.j |= bl2 ? 0 : 512;
        this.C = this.a(this.a, n3);
        if (!this.C) {
            throw new DSJException("Cant create editing session", -1);
        }
        if (!(this.a.size() <= 0 || this.a != null && this.a.isAlive())) {
            this.a = new DSFiltergraph.d(this);
            this.a.start();
        }
        this.a(-1, 50);
        if (this.s != this.t) {
            this.setSelection(this.s, this.t);
        }
        if (this.getPlaySelection()) {
            this.setPlaySelection(true);
        }
        this.setTimeValue(n2);
    }

    public boolean getEditable() {
        return this.C;
    }

    public DSMediaType[] getSourceMediaTypes() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (this.getEditable()) {
            throw new DSJException("method unsupported when editable", -4);
        }
        if (this.a != null && this.b != null) {
            return new DSMediaType[]{this.a, this.b};
        }
        if (this.a != null && this.b == null) {
            return new DSMediaType[]{this.a};
        }
        if (this.a == null && this.b != null) {
            return new DSMediaType[]{this.b};
        }
        DSFilter[] dSFilterArray = this.listFilters();
        Vector<DSMediaType> vector = new Vector<DSMediaType>();
        for (int i2 = 0; i2 < dSFilterArray.length; ++i2) {
            Object object = dSFilterArray[i2].getOutputs();
            for (int i3 = 0; i3 < ((DSFilter.DSPin[])object).length; ++i3) {
                DSMediaType dSMediaType = object[i3].getConnectionMediaType();
                if (dSMediaType.getMajorType() == 2) {
                    object = object[0].connectedTo();
                    object = object.getFilter().getOutputs();
                    for (i3 = 0; i3 < ((DSFilter.DSPin[])object).length; ++i3) {
                        dSMediaType = object[i3].getConnectionMediaType();
                        if (dSMediaType == null) continue;
                        if (dSMediaType.getMajorType() == 0) {
                            this.a = dSMediaType;
                        } else {
                            if (dSMediaType.getMajorType() != 1) continue;
                            this.b = dSMediaType;
                        }
                        vector.add(dSMediaType);
                    }
                    break;
                }
                if (dSMediaType.getMajorType() == 0) {
                    this.a = dSMediaType;
                    vector.add(dSMediaType);
                    continue;
                }
                if (dSMediaType.getMajorType() != 1) continue;
                this.b = dSMediaType;
                vector.add(dSMediaType);
            }
            if (vector.size() <= 0) continue;
            DSMediaType[] dSMediaTypeArray = new DSMediaType[vector.size()];
            vector.toArray(dSMediaTypeArray);
            return dSMediaTypeArray;
        }
        return null;
    }

    public String getVideoCodec() {
        if (!((DSMovie)object).d) {
            throw new DSJException("Graph not active", -2);
        }
        if (((DSMovie)object).a[3] <= 0L) {
            return "n.a.";
        }
        if (((DSMovie)object).a[3] <= 500L) {
            return DSEnvironment.getMediaSubTypeString((int)((DSMovie)object).a[3]);
        }
        Object object = new byte[]{(byte)(((DSMovie)object).a[3] & 0xFFL), (byte)(((DSMovie)object).a[3] >> 8 & 0xFFL), (byte)(((DSMovie)object).a[3] >> 16 & 0xFFL), (byte)(((DSMovie)object).a[3] >> 24 & 0xFFL)};
        return new String((byte[])object);
    }

    public String getStreamType() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        return DSEnvironment.getMediaSubTypeString((int)this.a[2]);
    }

    public int getStreamType_int() {
        return (int)this.a[2];
    }

    public String getAudioCodec() {
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        return DSEnvironment.getMediaSubTypeString((int)this.a[6]);
    }

    public String getInfo() {
        int[] nArray = ((DSFiltergraph)((Object)string)).getAudioProperties();
        String string = ((DSMovie)((Object)string)).a + "\nwidth: " + ((DSMovie)((Object)string)).a + ", height: " + ((DSMovie)((Object)string)).b + (((DSMovie)((Object)string)).b[5] != 0 && ((DSMovie)((Object)string)).b[6] != 0 ? "\naspect: " + ((DSMovie)((Object)string)).b[5] + ":" + ((DSMovie)((Object)string)).b[6] : "") + "\n" + "bitDepth: " + ((DSMovie)((Object)string)).b[2] + "\nduration: " + ((DSMovie)((Object)string)).a[0] + (((DSMovie)((Object)string)).a[1] > 0L ? "\nframeRate: " + ((DSFiltergraph)((Object)string)).getFrameRate() : "") + (((DSMovie)((Object)string)).a[2] > 0L ? "\nstreamtype: " + DSEnvironment.getMediaSubTypeString((int)((DSMovie)((Object)string)).a[2]) : "") + (((DSMovie)((Object)string)).a[3] > 0L ? "\nvideo: " + ((DSMovie)((Object)string)).getVideoCodec() : "") + (((DSMovie)((Object)string)).p && ((DSMovie)((Object)string)).b[7] != 0 ? "\nyuv type: " + DSJUtils.toFCC(((DSMovie)((Object)string)).b[7]) : "") + (((DSMovie)((Object)string)).a[6] > 0L ? "\naudio: " + DSEnvironment.getMediaSubTypeString((int)((DSMovie)((Object)string)).a[6]) : "") + (nArray != null && nArray[0] != 0 ? (((DSMovie)((Object)string)).a[6] > 0L ? ", " : "\naudio: ") + nArray[0] + " Hz, " + nArray[1] + " bit, " + nArray[2] + " ch." : "");
        return string;
    }

    public String[][] getMetaData() {
        if (stringArray.getEditable()) {
            return new String[2][];
        }
        Vector vector = new Vector();
        stringArray.nativeGetMetaData(stringArray.a, vector);
        if (vector.size() == 0) {
            return new String[2][0];
        }
        String[][] stringArray = new String[2][vector.size() / 2];
        for (int i2 = 0; i2 < vector.size(); i2 += 2) {
            try {
                stringArray[0][i2 / 2] = vector.get(i2).toString().indexOf("|") > 0 ? vector.get(i2).toString().substring(0, vector.get(i2).toString().indexOf("|")) : DSJUtils.a(vector.get(i2).toString());
                stringArray[1][i2 / 2] = DSJUtils.a(vector.get(i2 + 1).toString());
                if (stringArray[1][i2 / 2].indexOf("|") <= 0) continue;
                stringArray[1][i2 / 2] = stringArray[1][i2 / 2].substring(0, stringArray[1][i2 / 2].indexOf("|"));
                continue;
            }
            catch (Exception exception) {}
        }
        vector.removeAllElements();
        return stringArray;
    }

    public String[][] getChapters() {
        if (stringArray.getEditable()) {
            return new String[2][];
        }
        Vector vector = new Vector();
        stringArray.nativeGetChapters(stringArray.a, vector);
        if (vector.size() == 0) {
            return new String[2][0];
        }
        String[][] stringArray = new String[2][vector.size() / 2];
        for (int i2 = 0; i2 < vector.size(); i2 += 2) {
            try {
                stringArray[0][i2 / 2] = vector.get(i2).toString().indexOf("|") > 0 ? vector.get(i2).toString().substring(0, vector.get(i2).toString().indexOf("|")) : DSJUtils.a(vector.get(i2).toString());
                stringArray[1][i2 / 2] = DSJUtils.a(vector.get(i2 + 1).toString());
                if (stringArray[1][i2 / 2].indexOf("|") <= 0) continue;
                stringArray[1][i2 / 2] = stringArray[1][i2 / 2].substring(0, stringArray[1][i2 / 2].indexOf("|"));
                continue;
            }
            catch (Exception exception) {}
        }
        vector.removeAllElements();
        return stringArray;
    }

    private static String[] a(String string) {
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        while (n2 < string.length()) {
            try {
                int n3 = string.indexOf("HREF", n2);
                if (n3 < 0) {
                    n3 = string.indexOf("href", n2);
                }
                if (n3 < 0) break;
                n2 = n3;
                n3 = string.indexOf("\"", n2) + 1;
                int n4 = string.indexOf("\"", n3);
                vector.add(string.substring(n3, n4));
                n2 = n4 + 1;
            }
            catch (Exception exception) {}
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    final long a() {
        return this.a;
    }

    native int doExport(long var1, String var3, DSFilterInfo var4, DSFilterInfo var5);

    native boolean nativeCancelExport(long var1);

    native int setupDSMovie(long var1, String var3, int var4, DSFilterInfo var5, DSFilterInfo var6);

    native int setMovieFile(long var1, String var3, int var4);

    native boolean nativeGetMetaData(long var1, Vector var3);

    native boolean nativeGetChapters(long var1, Vector var3);

    native boolean nativeSetSelection(long var1, int var3, int var4, int var5);

    native boolean nativeSetPlaySelection(long var1, boolean var3, int var4);

    native boolean nativeSetRecue(long var1, boolean var3, int var4);

    public int export(String string, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2) {
        int n2;
        if (!this.d) {
            throw new DSJException("Graph not active", -2);
        }
        if (!new File(new File(string).getAbsoluteFile().getParent()).exists()) {
            throw new DSJException("Parent directory does not exist", -9);
        }
        if (dSFilterInfo == null) {
            dSFilterInfo = DSFilterInfo.doNotRender();
        }
        if (DSMovie.a(string)) {
            n2 = dSFilterInfo.getPreferredFormat();
            dSFilterInfo = dSFilterInfo != null && dSFilterInfo.getName().indexOf("none") == -1 ? this.a(dSFilterInfo) : this.a(string);
            dSFilterInfo.setPreferredFormat(n2);
        }
        this.x = DSMovie.b(string);
        this.b(true);
        n2 = this.doExport(this.a, string.replace('/', '\\'), dSFilterInfo == null ? DSFilterInfo.doNotRender() : dSFilterInfo, dSFilterInfo2 == null ? DSFilterInfo.doNotRender() : dSFilterInfo2);
        this.v = true;
        this.b(false);
        this.a(-1, 103, 2);
        return n2;
    }

    public void cancelExport() {
        if (!this.v) {
            return;
        }
        this.v = false;
        if (this.nativeCancelExport(this.a)) {
            this.a(-1, 105, 2);
            if (this.l) {
                this.dispose();
                return;
            }
        } else {
            throw new DSJException("DSMovie, error on reseting export graph", -16);
        }
    }

    private boolean a(String string, int n2) {
        n2 = n2 >> 8 << 8;
        this.a(n2);
        if (this.g) {
            this.setIgnoreRepaint(true);
            this.setVisible(false);
        }
        this.a = new File(string).getAbsolutePath();
        this.j = n2;
        try {
            this.a = this.initInstance(7);
            DSJUtils.logln(2, "Java - inited: " + this.a);
            if (!this.initializeGraph(this.a, DSEnvironment.b())) {
                throw new DSJException("dsj, can not initialize", -1);
            }
            this.f = this.setupEditable(this.a, this.a, n2);
        }
        catch (Exception exception) {
            this.e = true;
            throw new DSJException("dsj, unknown error in dll", -1);
        }
        this.type = 7;
        if (this.f < 0) {
            this.e = true;
            string = "DSMovie construction failed, errorCode: " + this.f;
            if (this.f < -10000) {
                string = "DSMovie construction failed, errorCode: " + DSJException.hresultToHexString(this.f);
                String string2 = DSEnvironment.a(this.a);
                if (string2 != null && string2.length() > 0) {
                    string = string + ", DES errorcode: " + string2;
                }
            }
            if (this.f == -10) {
                string = "DSMovie: can't find decoder.";
            }
            if (this.f == -15) {
                string = "DSMovie: can't find audio codec.";
            }
            if (this.f == -14) {
                string = "DSMovie: can't connect to sink, colorspace mismatch, no converter found";
            }
            this.dispose();
            throw new DSJException(string, this.f);
        }
        this.C = true;
        if ((this.f & 2) != 0) {
            this.o = false;
            this.j = n2 ^ 2;
        }
        if ((this.f & 8) != 0) {
            this.o = false;
            this.a(-15, 12);
        }
        if (this.o) {
            try {
                this.a = new DSFiltergraph.DSAudioStream(this);
            }
            catch (Exception exception) {
                this.o = false;
                throw new DSJException("error in dll, can't deliver audio.", -20);
            }
        }
        if (this.f == 1) {
            this.a = true;
            this.a = 400;
            this.b = 0;
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.d = true;
            return true;
        }
        if (this.k) {
            this.getMovieInfo(this.a, this.a);
            this.a(this.a);
            this.d = true;
            return true;
        }
        if (this.l || this.m) {
            this.e();
            this.getMovieInfo(this.a, this.a);
            this.b();
            this.a(this.a);
            this.d = true;
            return true;
        }
        try {
            while (this.getBufferSize(this.a) == 0) {
                Thread.currentThread();
                Thread.sleep(20L);
            }
        }
        catch (Exception exception) {}
        this.e();
        this.a = this.b[0];
        this.b = this.b[1];
        this.c = (Vector)this.a;
        this.d = this.b;
        this.getMovieInfo(this.a, this.a);
        this.b();
        this.d = true;
        this.a(this.a);
        if (!(this.g || this.i || this.h || this.n)) {
            return true;
        }
        this.setName(String.valueOf(this.a));
        this.c();
        return true;
    }

    void getTracks() {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.c == null) {
            this.c = new Vector();
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeGetTracks(dSMovie.a, this.c);
        if (n2 < 0) {
            throw new DSJException("error reading movie tracks", -1);
        }
        for (n2 = 0; n2 < this.c.size(); ++n2) {
            ((MovieTrack)this.c.get(n2)).a(this);
        }
    }

    public int getTrackCount() {
        if (this.c == null) {
            this.getTracks();
        }
        return this.c.size();
    }

    public int getTrackCount(int n2) {
        MovieTrack movieTrack;
        if (n2 != 0 && n2 != 1) {
            return 0;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < this.getTrackCount() && (movieTrack = this.getIndTrackType(n2, i2)) != null; ++i2) {
            n3 = i2 + 1;
        }
        return n3;
    }

    public MovieTrack getIndTrack(int n2) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.c == null) {
            this.getTracks();
        }
        return (MovieTrack)this.c.get(n2);
    }

    public MovieTrack getTrack(int n2) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.c == null) {
            this.getTracks();
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            if (((MovieTrack)this.c.get(i2)).getID() != n2) continue;
            return (MovieTrack)this.c.get(i2);
        }
        return null;
    }

    public MovieTrack getIndTrackType(int n2, int n3) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.c == null) {
            this.getTracks();
        }
        int n4 = 0;
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            if (((MovieTrack)this.c.get(i2)).getMediaMajorType() != n2 || n4++ != n3) continue;
            return (MovieTrack)this.c.get(i2);
        }
        return null;
    }

    public void createBackground(int n2, int n3, int n4, int n5, int n6) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        DSMovie dSMovie = this;
        if ((n2 = this.nativeAdd(dSMovie.a, "none", n2, n3, "none", n4, n5, n6)) == -2) {
            this.a();
        }
    }

    public static DSMovie createEmptyMovie(DSMediaType object, DSMediaType dSMediaType, PropertyChangeListener propertyChangeListener) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (object != null) {
                stringBuffer.append("<timeline framerate=\"" + ((DSMediaType)object).getFrameRate() + "\">");
                stringBuffer.append("<group type=\"video\" bitdepth=\"" + ((DSMediaType)object).getBitDepth() + "\" width=\"" + ((DSMediaType)object).getWidth() + "\" height=\"" + ((DSMediaType)object).getHeight() + "\" framerate=\"" + ((DSMediaType)object).getFrameRate() + "\"></group>");
            }
            if (dSMediaType != null) {
                if (object != null) {
                    stringBuffer.append("<group type=\"audio\" framerate=\"" + ((DSMediaType)object).getFrameRate() + "\"></group>");
                } else {
                    stringBuffer.append("<group type=\"audio\"></group>");
                }
            }
            stringBuffer.append("</timeline>");
            object = new FileOutputStream(DSEnvironment.getProperty(11) + "temp.xtl");
            ((FileOutputStream)object).write(stringBuffer.toString().getBytes());
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            return new DSMovie(DSEnvironment.getProperty(11) + "temp.xtl", 0, propertyChangeListener);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int a() {
        try {
            ((DSMovie)serializable).saveAs(DSEnvironment.getProperty(11) + "temp.xtl", false);
            if (((DSMovie)serializable).a != null) {
                ((DSMovie)serializable).a.a();
            }
            ((DSMovie)serializable).d = false;
            ((DSMovie)serializable).q = false;
            Serializable serializable = serializable;
            ((DSFiltergraph)serializable).stopDS(((DSMovie)serializable).a);
            serializable = serializable;
            ((DSFiltergraph)serializable).releaseGraph(((DSMovie)serializable).a, false, DSEnvironment.getEnvironmentFlags());
            DSEnvironment.unregisterGraph((DSFiltergraph)serializable);
            serializable = serializable;
            ((DSMovie)serializable).a = -1L;
            ((DSMovie)serializable).a = false;
            super.a(DSEnvironment.getProperty(11) + "temp.xtl", ((DSMovie)serializable).j, null, null);
            if (!(((DSMovie)serializable).a.size() <= 0 || ((DSMovie)serializable).a != null && ((DSMovie)serializable).a.isAlive())) {
                ((DSMovie)serializable).a = new DSFiltergraph.d((DSFiltergraph)serializable);
                ((DSMovie)serializable).a.start();
            }
            ((DSFiltergraph)serializable).graphChanged();
            ((DSFiltergraph)serializable).a(-1, 5);
        }
        catch (Exception exception) {
            Serializable serializable = exception;
            exception.printStackTrace();
        }
        return 0;
    }

    boolean hasTrack(int n2) {
        if (this.c == null) {
            return false;
        }
        return this.getTrack(n2) != null;
    }

    void updateTrackParams(int n2, int n3, int n4, int n5) {
        try {
            MovieTrack movieTrack = ((DSMovie)((Object)movieTrack)).getTrack(n2);
            switch (n3) {
                case 0: {
                    movieTrack.setTimelineTimes(n4, n5);
                    break;
                }
                case 1: {
                    movieTrack.setMediaTimes(n4, n5);
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("updateTrack: " + exception.toString());
        }
    }

    void setSourceCount(int n2) {
        if (this.c == null || n2 == this.c.size()) {
            return;
        }
        int n3 = 0;
        if (n2 < this.c.size()) {
            for (n2 = 0; n2 < this.c.size(); ++n2) {
                if (this.getIndTrack(n2) == null) {
                    this.c.removeElementAt(n2);
                    --n2;
                } else {
                    ++n3;
                }
                if (n3 >= this.c.size()) break;
            }
        }
    }

    public void setMasterVolume(float f2) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        MovieTrack movieTrack = this.getIndTrackType(1, 0);
        if (movieTrack == null) {
            throw new DSJException("SetMAsterVolume: no audio track", -52);
        }
        this.nativeSetMultiParameter(this.getID(), new int[]{2, 5, -1, 0, this.getDuration(), 0, 0, 3, 1000, 0, 0, (int)(f2 * 1000.0f), 1, 0, 1000, this.getDuration(), 0}, "none");
    }

    public MovieSelection copy() {
        if (this.t <= this.s) {
            throw new DSJException("DSMovie copy: invalid selection.", -121);
        }
        return new MovieSelection(this, this.s, this.t, this.getEditable());
    }

    public static MovieSelection copyToClipboard(String string, int n2, int n3) {
        return new MovieSelection(new File(string).getAbsolutePath(), n2, n3);
    }

    public void paste(MovieSelection movieSelection) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        boolean bl = this.a;
        if (movieSelection.getOut() <= movieSelection.getIn()) {
            movieSelection.setOut(DSJUtils.getBasicFileStats(movieSelection.getPath())[0]);
            if (movieSelection.getOut() <= movieSelection.getIn()) {
                throw new DSJException("DSMovie add: invalid range.", -121);
            }
        }
        int n2 = this.getTime();
        DSMovie dSMovie = this;
        int n3 = this.nativePaste(dSMovie.a, movieSelection.getPath(), movieSelection.getIn(), movieSelection.getOut(), movieSelection.getName(), movieSelection.a(), movieSelection.a());
        if (n3 == 0) {
            this.getTracks();
            if (bl && this.getIndTrackType(0, 0) != null) {
                this.a();
                return;
            }
            this.graphChanged();
            try {
                this.setSelection(n2, n2 + (movieSelection.getOut() - movieSelection.getIn()));
            }
            catch (Exception exception) {}
            this.a(-1, 50);
            return;
        }
        throw new DSJException("DSMovie paste failed! " + DSJException.hresultToHexString(n3), n3);
    }

    public void add(MovieSelection movieSelection) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        boolean bl = this.a;
        if (movieSelection.getOut() <= movieSelection.getIn()) {
            movieSelection.setOut(DSJUtils.getBasicFileStats(movieSelection.getPath())[0]);
            if (movieSelection.getOut() <= movieSelection.getIn()) {
                throw new DSJException("DSMovie add: invalid range.", -121);
            }
        }
        int n2 = this.getTime();
        DSMovie dSMovie = this;
        int n3 = this.nativeAdd(dSMovie.a, movieSelection.getPath(), movieSelection.getIn(), movieSelection.getOut(), movieSelection.getName(), -1L, 1, -1);
        if (n3 >= 0) {
            this.getTracks();
            if (bl && this.getIndTrackType(0, 0) != null) {
                this.a();
                this.setSelection(n2, n2 + (movieSelection.getOut() - movieSelection.getIn()));
                return;
            }
            this.graphChanged();
            try {
                this.setSelection(n2, n2 + (movieSelection.getOut() - movieSelection.getIn()));
            }
            catch (Exception exception) {}
            this.a(-1, 50);
            return;
        }
        throw new DSJException("DSMovie add failed!", n3);
    }

    public void cut() {
        this.c(true);
    }

    private void c(boolean bl) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.t <= this.s) {
            throw new DSJException("DSMovie cut: invalid selection.", -121);
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeCut(dSMovie.a, this.s, this.t, true);
        if (n2 == 0) {
            if (!bl) {
                return;
            }
            if (this.c != null) {
                this.c.removeAllElements();
            }
            this.getTracks();
            this.graphChanged();
            try {
                this.setSelection(this.s, this.s);
            }
            catch (Exception exception) {}
            this.a(-1, 50);
            return;
        }
        throw new DSJException("DSMovie cut failed!", n2);
    }

    public void clear() {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.t <= this.s) {
            throw new DSJException("DSMovie clear: invalid selection.", -121);
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeCut(dSMovie.a, this.s, this.t, false);
        if (n2 == 0) {
            if (this.c != null) {
                this.c.removeAllElements();
            }
            this.getTracks();
            this.graphChanged();
            try {
                this.setSelection(this.s, this.s);
            }
            catch (Exception exception) {}
            this.a(-1, 50);
            return;
        }
        throw new DSJException("DSMovie clear failed!", n2);
    }

    public void replace(MovieSelection movieSelection) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        this.setTimeValue(this.s);
        try {
            this.c(false);
        }
        catch (DSJException dSJException) {}
        this.setTimeValue(this.s);
        this.paste(movieSelection);
    }

    public void trim() {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (this.t <= this.s) {
            throw new DSJException("DSMovie trim: invalid selection.", -121);
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeTrim(dSMovie.a, this.s, this.t);
        if (n2 == 0) {
            this.getTracks();
            this.graphChanged();
            try {
                this.setSelection(0, this.getDuration());
            }
            catch (Exception exception) {}
            this.a(-1, 50);
        }
    }

    public void removeTrack(MovieTrack object) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (object == null) {
            throw new DSJException("invalid track: " + object, -1);
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeRemoveTrack(dSMovie.a, ((MovieTrack)object).getMediaMajorType(), ((MovieTrack)object).getID());
        if (n2 < 0) {
            throw new DSJException("error removing track: " + n2, n2);
        }
        try {
            if (this.c != null) {
                this.c.remove(object);
            }
            ((MovieTrack)object).a();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        this.getTracks();
        this.graphChanged();
        try {
            this.setSelection(0, this.getDuration());
        }
        catch (Exception exception) {}
        this.a(-1, 50);
    }

    public void setRerendering(boolean bl) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        this.D = bl;
        this.nativeSetParameter(this.getID(), -1, -1, bl ? 1 : 0);
    }

    public boolean getRerendering() {
        return this.D;
    }

    public void setMasterFrameRate(float f2) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        this.nativeSetParameter(this.a, -1, 1, (int)(f2 * 1000.0f));
    }

    public float getMasterFrameRate() {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        return (float)this.nativeGetParameter(this.a, -1, 1) / 1000.0f;
    }

    public String getAsXML() {
        if (!((DSMovie)this).getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (((String)(this = ((DSMovie)this).nativeGetAsXML(((DSMovie)this).a))).getBytes()[0] == 63) {
            return ((String)this).substring(1);
        }
        return this;
    }

    public void saveAs(String string, boolean bl) {
        if (!this.getEditable()) {
            throw new DSJException("DSMovie: not editable.", -50);
        }
        if (string == null || string.equalsIgnoreCase(this.a)) {
            throw new IOException("DSMovie saveAs: invalid or busy targetfile");
        }
        if (string.indexOf("xtl") < 0 && string.indexOf("grf") < 0) {
            this.v = true;
            this.a(-1, 106, 2);
            if (bl) {
                this.savePath = string;
            }
        }
        DSMovie dSMovie = this;
        int n2 = this.nativeSave(dSMovie.a, string.replace('/', '\\'));
        if (n2 != 0) {
            this.a(-1, 107, 2);
            if (n2 == -120) {
                throw new DSJException("DSMovie: format mismatch, can't save.", -120);
            }
            throw new DSJException("DSMovie: error saving file " + DSJException.hresultToHexString(n2), -106);
        }
    }

    final void a(String object) {
        this.d = false;
        this.q = false;
        if (this.a != null) {
            this.a.a();
        }
        DSMovie dSMovie = this;
        this.stopDS(dSMovie.a);
        dSMovie = this;
        this.releaseGraph(dSMovie.a, false, DSEnvironment.getEnvironmentFlags());
        DSEnvironment.unregisterGraph(this);
        dSMovie = this;
        this.a = -1L;
        if (object == null) {
            object = new au(this);
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            this.a((String)object, this.j | 0x200, null, null);
        }
        this.savePath = null;
    }

    public static void mux(String string, String string2, int[] nArray, String string3) {
        if (string3.indexOf("avi") < 0 && string3.indexOf("AVI") < 0) {
            throw new DSJException("Mux: Invalid output file", -40);
        }
        DSMovie.nativeMux(string, string2, string3);
    }

    public boolean rewriteASFIndex() {
        if (!DSJUtils.b(this.a)) {
            return false;
        }
        this.setRate(0.0f);
        DSMovie dSMovie = this;
        return this.nativeRewriteASFIndex(dSMovie.a, this.a);
    }

    native boolean nativeRewriteASFIndex(long var1, String var3);

    static native int nativeMux(String var0, String var1, String var2);

    native int setupEditable(long var1, String var3, int var4);

    native int nativePaste(long var1, String var3, int var4, int var5, String var6, boolean var7, long var8);

    native int nativeAdd(long var1, String var3, int var4, int var5, String var6, long var7, int var9, int var10);

    native int nativeTrim(long var1, int var3, int var4);

    native int nativeCut(long var1, int var3, int var4, boolean var5);

    native int nativeSave(long var1, String var3);

    native int nativeGetTracks(long var1, Vector var3);

    native int nativeRemoveTrack(long var1, int var3, int var4);

    native String nativeGetAsXML(long var1);

    static void a(DSMovie dSMovie, String string, int n2, DSFilterInfo dSFilterInfo, DSFilterInfo dSFilterInfo2) {
        dSMovie.a(string, n2, null, null);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class MovieSelection {
        private String a;
        private String b;
        private String c = "none";
        private long a;
        private int a;
        private int b;
        private boolean a = -1L;

        MovieSelection(DSMovie dSMovie, int n2, int n3, boolean bl) {
            Serializable serializable;
            if (n2 < 0) {
                throw new DSJException("invalid selection start", -1);
            }
            if (n3 <= n2) {
                serializable = dSMovie;
                n3 = DSJUtils.getBasicFileStats(serializable.a)[0];
                if (n3 <= n2) {
                    throw new DSJException("invalid selection end", -121);
                }
            }
            serializable = dSMovie;
            this.a = serializable.a;
            this.b = this.a.substring(this.a.lastIndexOf(File.separator) + 1);
            try {
                int n4 = dSMovie.getDuration();
                if (n3 > n4 || n2 > n4) {
                    throw new DSJException("MovieSelection: invalid times, max duration in " + this.b + " is " + n4 + " msec", -1);
                }
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
            }
            this.a = n2;
            this.b = n3;
            this.a = bl;
            this.a = dSMovie.getID();
        }

        public MovieSelection(String object, int n2, int n3) {
            if (n2 < 0) {
                throw new DSJException("invalid selection start", -1);
            }
            if (n3 <= n2 && (n3 = DSJUtils.getBasicFileStats((String)object)[0]) <= n2) {
                throw new DSJException("invalid selection end", -121);
            }
            if (!((File)(object = new File((String)object))).exists()) {
                throw new DSJException("file not found", -1);
            }
            this.a = ((File)object).getAbsolutePath();
            this.b = this.a.substring(this.a.lastIndexOf(File.separator) + 1);
            try {
                int[] nArray = DSJUtils.getBasicFileStats(this.a);
                object = nArray;
                int n4 = nArray[0];
                if (n3 > n4 || n2 > n4) {
                    throw new DSJException("MovieSelection: invalid times, max duration in " + this.b + " is " + n4 + " msec", -1);
                }
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
            this.a = n2;
            this.b = n3;
        }

        public void setName(String string) {
            this.c = string;
        }

        public String getFileName() {
            return this.b;
        }

        public String getPath() {
            return this.a;
        }

        public String getName() {
            return this.c;
        }

        public int getIn() {
            return this.a;
        }

        public int getOut() {
            return this.b;
        }

        public void setIn(int n2) {
            this.a = n2;
        }

        public void setOut(int n2) {
            this.b = n2;
        }

        public String toString() {
            return new String(this.b + "  " + this.a + "  " + this.b);
        }

        final boolean a() {
            return this.a;
        }

        final long a() {
            return this.a;
        }
    }
}

