/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.GraphTransferHandler;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphDropTargetListener;

public class BasicGraphUI
extends GraphUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 20;
    public static int MAXHANDLES = 20;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected JGraph graph;
    protected GraphLayoutCache graphLayoutCache;
    protected GraphCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected GraphModel graphModel;
    protected GraphSelectionModel graphSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected CellView lastFocus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected GraphSelectionListener graphSelectionListener;
    protected GraphModelListener graphModelListener;
    protected GraphLayoutCacheListener graphLayoutCacheListener;
    protected TransferHandler defaultTransferHandler;
    protected GraphDropTargetListener defaultDropTargetListener;
    protected DropTarget dropTarget = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicGraphUI();
    }

    protected void setModel(GraphModel graphModel) {
        this.cancelEditing(this.graph);
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        this.graphModel = graphModel;
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if (this.graphModel != null) {
            this.updateSize();
        }
    }

    protected void setGraphLayoutCache(GraphLayoutCache graphLayoutCache) {
        this.cancelEditing(this.graph);
        if (this.graphLayoutCache != null && this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.removeGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.graphLayoutCache = graphLayoutCache;
        if (this.graphLayoutCache != null && this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.addGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler basicMarqueeHandler) {
        this.marquee = basicMarqueeHandler;
    }

    protected void setSelectionModel(GraphSelectionModel graphSelectionModel) {
        this.cancelEditing(this.graph);
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
        this.graphSelectionModel = graphSelectionModel;
        if (this.graphSelectionModel != null && this.graphSelectionListener != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    public CellHandle getHandle() {
        return this.handle;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    public Dimension2D getPreferredSize(JGraph jGraph, CellView cellView) {
        if (cellView != null) {
            boolean bl;
            Component component;
            boolean bl2;
            Object object = cellView.getCell();
            String string = jGraph.convertValueToString(object);
            boolean bl3 = string != null && string.length() > 0;
            boolean bl4 = bl2 = GraphConstants.getIcon(cellView.getAllAttributes()) != null;
            if ((bl3 || bl2) && (component = cellView.getRendererComponent(jGraph, bl = this.getFocusedCell() == object && jGraph.hasFocus(), false, false)) != null) {
                jGraph.add(component);
                component.validate();
                Dimension dimension = component.getPreferredSize();
                int n = 2 * GraphConstants.getInset(cellView.getAllAttributes());
                dimension.width += n;
                dimension.height += n;
                return dimension;
            }
            if (cellView.getBounds() == null) {
                cellView.update();
            }
            Rectangle2D rectangle2D = cellView.getBounds();
            return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        return null;
    }

    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Point point) {
        this.insertionLocation = point;
    }

    public void selectCellsForEvent(JGraph jGraph, Object[] objectArray, MouseEvent mouseEvent) {
        this.selectCellsForEvent(objectArray, mouseEvent);
    }

    public void selectCellsForEvent(Object[] objectArray, MouseEvent mouseEvent) {
        if (objectArray == null || !this.graph.isSelectionEnabled()) {
            return;
        }
        if (this.isToggleSelectionEvent(mouseEvent)) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.toggleSelectionCellForEvent(objectArray[i], mouseEvent);
            }
        } else if (this.isAddToSelectionEvent(mouseEvent)) {
            this.graph.addSelectionCells(objectArray);
        } else {
            this.graph.setSelectionCells(objectArray);
        }
    }

    public void selectCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.graph.isSelectionEnabled()) {
            if (this.isToggleSelectionEvent(mouseEvent)) {
                this.toggleSelectionCellForEvent(object, mouseEvent);
            } else if (this.isAddToSelectionEvent(mouseEvent)) {
                this.graph.addSelectionCell(object);
            } else {
                this.graph.setSelectionCell(object);
            }
        }
    }

    protected void toggleSelectionCellForEvent(Object object, MouseEvent mouseEvent) {
        if (this.graph.isCellSelected(object)) {
            this.graph.removeSelectionCell(object);
        } else {
            this.graph.addSelectionCell(object);
        }
    }

    public boolean isAddToSelectionEvent(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        switch (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            case 2: {
                return mouseEvent.isControlDown();
            }
            case 8: {
                return mouseEvent.isAltDown();
            }
            case 4: {
                return mouseEvent.isMetaDown();
            }
        }
        return false;
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(mouseEvent);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            return mouseEvent.isShiftDown();
        }
        return false;
    }

    public boolean isEditing(JGraph jGraph) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JGraph jGraph) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JGraph jGraph) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtCell(JGraph jGraph, Object object) {
        jGraph.scrollCellToVisible(object);
        if (object != null) {
            this.startEditing(object, null);
        }
    }

    public Object getEditingCell(JGraph jGraph) {
        return this.editingCell;
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicGraphUI.installUI()");
        }
        this.graph = (JGraph)jComponent;
        this.marquee = this.graph.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setGraphLayoutCache(this.graph.getGraphLayoutCache());
        this.setModel(this.graph.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.graph.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.graph.getBackground() == null || this.graph.getBackground() instanceof UIResource) {
            this.graph.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.graph.getFont() == null || this.graph.getFont() instanceof UIResource) {
            try {
                this.graph.setFont(UIManager.getFont("Tree.font"));
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.graph.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        this.graph.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.graph.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.graph.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.graph.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler transferHandler = this.graph.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            try {
                this.graph.setTransferHandler(this.defaultTransferHandler);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (this.graphLayoutCache != null) {
            this.graphLayoutCacheListener = this.createGraphLayoutCacheListener();
            this.graphLayoutCache.addGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        this.dropTarget = this.graph.getDropTarget();
        try {
            if (this.dropTarget != null) {
                this.defaultDropTargetListener = new GraphDropTargetListener();
                this.dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.graph.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.graph.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.graph.addKeyListener(this.keyListener);
        }
        if ((this.graphModelListener = this.createGraphModelListener()) != null && this.graphModel != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if ((this.graphSelectionListener = this.createGraphSelectionListener()) != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.graph, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.graph, 0, inputMap);
        SwingUtilities.replaceUIActionMap(this.graph, this.createActionMap());
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (n == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("selectPrevious", new GraphIncrementAction(1, "selectPrevious"));
        actionMapUIResource.put("selectPreviousChangeLead", new GraphIncrementAction(1, "selectPreviousLead"));
        actionMapUIResource.put("selectPreviousExtendSelection", new GraphIncrementAction(1, "selectPreviousExtendSelection"));
        actionMapUIResource.put("selectParent", new GraphIncrementAction(4, "selectParent"));
        actionMapUIResource.put("selectParentChangeLead", new GraphIncrementAction(4, "selectParentChangeLead"));
        actionMapUIResource.put("selectNext", new GraphIncrementAction(3, "selectNext"));
        actionMapUIResource.put("selectNextChangeLead", new GraphIncrementAction(3, "selectNextLead"));
        actionMapUIResource.put("selectNextExtendSelection", new GraphIncrementAction(3, "selectNextExtendSelection"));
        actionMapUIResource.put("selectChild", new GraphIncrementAction(2, "selectChild"));
        actionMapUIResource.put("selectChildChangeLead", new GraphIncrementAction(2, "selectChildChangeLead"));
        actionMapUIResource.put("cancel", new GraphCancelEditingAction("cancel"));
        actionMapUIResource.put("startEditing", new GraphEditAction("startEditing"));
        actionMapUIResource.put("selectAll", new GraphSelectAllAction("selectAll", true));
        actionMapUIResource.put("clearSelection", new GraphSelectAllAction("clearSelection", false));
        return actionMapUIResource;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.graph.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new GraphTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected GraphSelectionListener createGraphSelectionListener() {
        return new GraphSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected GraphLayoutCacheListener createGraphLayoutCacheListener() {
        return new GraphLayoutCacheHandler();
    }

    protected GraphModelListener createGraphModelListener() {
        return new GraphModelHandler();
    }

    public void uninstallUI(JComponent jComponent) {
        this.cancelEditing(this.graph);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.graphLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.graph = null;
        this.graphModel = null;
        this.graphSelectionModel = null;
        this.graphSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler transferHandler = this.graph.getTransferHandler();
        if (transferHandler == this.defaultTransferHandler) {
            this.graph.setTransferHandler(null);
        }
        if (this.graphLayoutCacheListener != null) {
            this.graphLayoutCache.removeGraphLayoutCacheListener(this.graphLayoutCacheListener);
        }
        if (this.dropTarget != null && this.defaultDropTargetListener != null) {
            this.dropTarget.removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.graph.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.graph.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.graph.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.graph.removeKeyListener(this.keyListener);
        }
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.graph, null);
        SwingUtilities.replaceUIInputMap(this.graph, 1, null);
        SwingUtilities.replaceUIInputMap(this.graph, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.graph.remove(this.rendererPane);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.graph != jComponent) {
            throw new InternalError("BasicGraphUI cannot paint " + jComponent.toString() + "; " + this.graph + " was expected.");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
        Rectangle2D rectangle2D = this.graph.fromScreen(new Rectangle2D.Double(((RectangularShape)double_).getX(), ((RectangularShape)double_).getY(), ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight()));
        this.paintBackground(graphics);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.graph.isAntiAliased()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double d = this.graph.getScale();
        graphics2D.scale(d, d);
        CellView[] cellViewArray = this.graphLayoutCache.getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Rectangle2D rectangle2D2 = cellViewArray[i].getBounds();
            if (rectangle2D2 == null || rectangle2D == null || !rectangle2D2.intersects(rectangle2D)) continue;
            this.paintCell(graphics, cellViewArray[i], rectangle2D2, false);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (!this.graph.isPortsScaled()) {
            graphics2D.setTransform(affineTransform);
        }
        this.paintForeground(graphics);
        graphics2D.setTransform(affineTransform);
        if (this.handle != null) {
            this.handle.paint(graphics);
        }
        if (this.marquee != null) {
            this.marquee.paint(this.graph, graphics);
        }
        if (this.rendererPane != null) {
            this.rendererPane.removeAll();
        }
    }

    public void paintCell(Graphics graphics, CellView cellView, Rectangle2D rectangle2D, boolean bl) {
        int n;
        if (cellView != null && rectangle2D != null) {
            boolean bl2 = cellView == this.focus;
            n = this.graph.isCellSelected(cellView.getCell()) ? 1 : 0;
            Component component = cellView.getRendererComponent(this.graph, n != 0, bl2, bl);
            this.rendererPane.paintComponent(graphics, component, this.graph, (int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), true);
        }
        if (!cellView.isLeaf()) {
            CellView[] cellViewArray = cellView.getChildViews();
            for (n = 0; n < cellViewArray.length; ++n) {
                this.paintCell(graphics, cellViewArray[n], cellViewArray[n].getBounds(), bl);
            }
        }
    }

    protected void paintBackground(Graphics graphics) {
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), graphics, graphics.getClipBounds());
        }
    }

    protected void paintGrid(double d, Graphics graphics, Rectangle2D rectangle2D) {
        Rectangle rectangle = graphics.getClipBounds();
        double d2 = rectangle.x;
        double d3 = rectangle.y;
        double d4 = d2 + (double)rectangle.width;
        double d5 = d3 + (double)rectangle.height;
        double d6 = Math.max(2.0, d * this.graph.getScale());
        int n = (int)(Math.floor(d2 / d6) * d6);
        int n2 = (int)(Math.ceil(d4 / d6) * d6);
        int n3 = (int)(Math.floor(d3 / d6) * d6);
        int n4 = (int)(Math.ceil(d5 / d6) * d6);
        graphics.setColor(this.graph.getGridColor());
        switch (this.graph.getGridMode()) {
            case 1: {
                int n5 = d6 > 16.0 ? 2 : (d6 < 8.0 ? 0 : 1);
                for (double d7 = (double)n; d7 <= (double)n2; d7 += d6) {
                    for (double d8 = (double)n3; d8 <= (double)n4; d8 += d6) {
                        int n6 = (int)Math.round(d7);
                        int n7 = (int)Math.round(d8);
                        graphics.drawLine(n6 - n5, n7, n6 + n5, n7);
                        graphics.drawLine(n6, n7 - n5, n6, n7 + n5);
                    }
                }
                break;
            }
            case 2: {
                int n8;
                double d9;
                n2 += (int)Math.ceil(d6);
                n4 += (int)Math.ceil(d6);
                for (d9 = (double)n; d9 <= (double)n2; d9 += d6) {
                    n8 = (int)Math.round(d9);
                    graphics.drawLine(n8, n3, n8, n4);
                }
                for (d9 = (double)n3; d9 <= (double)n4; d9 += d6) {
                    n8 = (int)Math.round(d9);
                    graphics.drawLine(n, n8, n2, n8);
                }
                break;
            }
            default: {
                for (double d10 = (double)n; d10 <= (double)n2; d10 += d6) {
                    for (double d11 = (double)n3; d11 <= (double)n4; d11 += d6) {
                        int n9 = (int)Math.round(d10);
                        int n10 = (int)Math.round(d11);
                        graphics.drawLine(n9, n10, n9, n10);
                    }
                }
            }
        }
    }

    protected void paintForeground(Graphics graphics) {
        if (this.graph.isPortsVisible()) {
            this.paintPorts(graphics, this.graphLayoutCache.getPorts());
        }
    }

    public void paintPorts(Graphics graphics, CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Rectangle rectangle = graphics.getClipBounds();
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                Rectangle2D rectangle2D = cellViewArray[i].getBounds();
                Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                Point2D point2D = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
                if (!this.graph.isPortsScaled()) {
                    point2D = this.graph.toScreen(point2D);
                }
                double_.setFrame(point2D.getX() - ((RectangularShape)double_).getWidth() / 2.0, point2D.getY() - ((RectangularShape)double_).getHeight() / 2.0, ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
                if (rectangle != null && !double_.intersects(rectangle)) continue;
                this.paintCell(graphics, cellViewArray[i], double_, false);
            }
        }
    }

    public void updateHandle() {
        if (this.graphLayoutCache != null) {
            Object[] objectArray = this.graphLayoutCache.getVisibleCells(this.graph.getSelectionCells());
            this.handle = objectArray != null && objectArray.length > 0 ? this.createHandle(this.createContext(this.graph, objectArray)) : null;
        }
    }

    protected GraphContext createContext(JGraph jGraph, Object[] objectArray) {
        return new GraphContext(jGraph, objectArray);
    }

    public CellHandle createHandle(GraphContext graphContext) {
        if (graphContext != null && !graphContext.isEmpty() && this.graph.isEnabled()) {
            try {
                return new RootHandle(graphContext);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.graph.graphDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Rectangle2D rectangle2D = AbstractCellView.getBounds(this.graphLayoutCache.getRoots());
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
        }
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        Dimension dimension = this.graph.getMinimumSize();
        Point point = dimension != null ? this.graph.toScreen(new Point(dimension.width, dimension.height)) : new Point(0, 0);
        Point2D point2D = this.graph.toScreen(double_);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)point).getX(), point2D.getX()), (int)Math.max(((Point2D)point).getY(), point2D.getY()));
        Insets insets = this.graph.getInsets();
        if (insets != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)insets.left + (double)insets.right, this.preferredSize.getHeight() + (double)insets.top + (double)insets.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.graph != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.graph != null) {
            return this.getPreferredSize(this.graph);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.graph.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            Object object = this.editingCell;
            GraphCellEditor graphCellEditor = this.cellEditor;
            boolean bl4 = this.graph != null && (this.graph.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingCell = null;
            this.editingComponent = null;
            if (bl) {
                graphCellEditor.stopCellEditing();
            } else if (bl2) {
                graphCellEditor.cancelCellEditing();
            }
            this.graph.remove(component);
            if (bl4) {
                this.graph.requestFocus();
            }
            if (bl3) {
                Object object2 = graphCellEditor.getCellEditorValue();
                this.graphLayoutCache.valueForCellChanged(object, object2);
            }
            this.updateSize();
            if (graphCellEditor != null && this.cellEditorListener != null) {
                graphCellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object object, MouseEvent mouseEvent) {
        this.completeEditing();
        if (this.graph.isCellEditable(object)) {
            CellView cellView = this.graphLayoutCache.getMapping(object, false);
            this.cellEditor = cellView.getEditor();
            this.editingComponent = this.cellEditor.getGraphCellEditorComponent(this.graph, object, this.graph.isCellSelected(object));
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                Rectangle2D rectangle2D = this.graph.getCellBounds(object);
                this.editingCell = object;
                Dimension dimension = this.editingComponent.getPreferredSize();
                this.graph.add(this.editingComponent);
                Point2D point2D = this.getEditorLocation(object, dimension, this.graph.toScreen(new Point2D.Double(rectangle2D.getX(), rectangle2D.getY())));
                this.editingComponent.setBounds((int)point2D.getX(), (int)point2D.getY(), (int)((Dimension2D)dimension).getWidth(), (int)((Dimension2D)dimension).getHeight());
                this.editingCell = object;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                Rectangle rectangle = this.graph.getVisibleRect();
                this.graph.paintImmediately((int)point2D.getX(), (int)point2D.getY(), (int)(((RectangularShape)rectangle).getWidth() + ((RectangularShape)rectangle).getX() - rectangle2D.getX()), (int)((Dimension2D)dimension).getHeight());
                if (this.cellEditor.shouldSelectCell(mouseEvent) && this.graph.isSelectionEnabled()) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.graph.setSelectionCell(object);
                    }
                    catch (Exception exception) {
                        System.err.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.graph, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component != null) {
                        new MouseInputHandler(this.graph, component, mouseEvent);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected Point2D getEditorLocation(Object object, Dimension2D dimension2D, Point2D point2D) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            CellViewRenderer cellViewRenderer = edgeView.getRenderer();
            if (cellViewRenderer instanceof EdgeRenderer) {
                Point2D point2D2 = ((EdgeRenderer)cellViewRenderer).getLabelPosition(edgeView);
                point2D = point2D2 != null ? point2D2 : AbstractCellView.getCenterPoint(edgeView);
                point2D.setLocation(Math.max(0.0, point2D.getX() - dimension2D.getWidth() / 2.0), Math.max(0.0, point2D.getY() - dimension2D.getHeight() / 2.0));
            }
            this.graph.toScreen(point2D);
        }
        return point2D;
    }

    public static void autoscroll(JGraph jGraph, Point point) {
        Rectangle rectangle = jGraph.getBounds();
        if (jGraph.getParent() instanceof JViewport) {
            rectangle = ((JViewport)jGraph.getParent()).getViewRect();
        }
        if (rectangle.contains(point)) {
            Point point2 = new Point(point);
            int n = (int)((float)jGraph.getWidth() * SCROLLSTEP);
            int n2 = (int)((float)jGraph.getHeight() * SCROLLSTEP);
            if (point2.x - rectangle.x < SCROLLBORDER) {
                point2.x -= n;
            }
            if (point2.y - rectangle.y < SCROLLBORDER) {
                point2.y -= n2;
            }
            if (rectangle.x + rectangle.width - point2.x < SCROLLBORDER) {
                point2.x += n;
            }
            if (rectangle.y + rectangle.height - point2.y < SCROLLBORDER) {
                point2.y += n2;
            }
            jGraph.scrollPointToVisible(point2);
        }
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean bl) {
        this.snapSelectedView = bl;
    }

    public class GraphDropTargetListener
    extends BasicGraphDropTargetListener
    implements Serializable {
        protected void saveComponentState(JComponent jComponent) {
        }

        protected void restoreComponentState(JComponent jComponent) {
            if (BasicGraphUI.this.handle != null) {
                BasicGraphUI.this.handle.mouseDragged(null);
            }
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            BasicGraphUI.this.setInsertionLocation(point);
            if (BasicGraphUI.this.handle != null) {
                int n = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                BasicGraphUI.this.handle.mouseDragged(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            BasicGraphUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dragEnter(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            BasicGraphUI.this.dropAction = dropTargetDragEvent.getDropAction();
            super.dropActionChanged(dropTargetDragEvent);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class GraphSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public GraphSelectAllAction(String string, boolean bl) {
            this.selectAll = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                if (this.selectAll) {
                    BasicGraphUI.this.graph.setSelectionCells(BasicGraphUI.this.graph.getGraphLayoutCache().getVisibleCells(BasicGraphUI.this.graph.getRoots()));
                } else {
                    BasicGraphUI.this.graph.clearSelection();
                }
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphEditAction
    extends AbstractAction {
        public GraphEditAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled() && BasicGraphUI.this.getFocusedCell() instanceof GraphCell) {
                BasicGraphUI.this.graph.startEditingAtCell(BasicGraphUI.this.getFocusedCell());
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphCancelEditingAction
    extends AbstractAction {
        public GraphCancelEditingAction(String string) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class GraphIncrementAction
    extends AbstractAction {
        protected int direction;

        private GraphIncrementAction(int n, String string) {
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicGraphUI.this.graph != null) {
                int n = 70;
                Rectangle rectangle = BasicGraphUI.this.graph.getVisibleRect();
                if (this.direction == 1) {
                    rectangle.translate(0, -n);
                } else if (this.direction == 2) {
                    rectangle.translate(n, 0);
                } else if (this.direction == 3) {
                    rectangle.translate(0, n);
                } else if (this.direction == 4) {
                    rectangle.translate(-n, 0);
                }
                BasicGraphUI.this.graph.scrollRectToVisible(rectangle);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicGraphUI.this.graph) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("minimumSize")) {
                    BasicGraphUI.this.updateCachedPreferredSize();
                } else if (string.equals("model")) {
                    BasicGraphUI.this.setModel((GraphModel)propertyChangeEvent.getNewValue());
                } else if (string.equals("view")) {
                    BasicGraphUI.this.setGraphLayoutCache((GraphLayoutCache)propertyChangeEvent.getNewValue());
                    BasicGraphUI.this.graph.repaint();
                } else if (string.equals("marquee")) {
                    BasicGraphUI.this.setMarquee((BasicMarqueeHandler)propertyChangeEvent.getNewValue());
                } else if (string.equals("transferHandler")) {
                    if (BasicGraphUI.this.dropTarget != null) {
                        BasicGraphUI.this.dropTarget.removeDropTargetListener(BasicGraphUI.this.defaultDropTargetListener);
                    }
                    BasicGraphUI.this.dropTarget = BasicGraphUI.this.graph.getDropTarget();
                    try {
                        if (BasicGraphUI.this.dropTarget != null) {
                            BasicGraphUI.this.dropTarget.addDropTargetListener(BasicGraphUI.this.defaultDropTargetListener);
                        }
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                } else if (string.equals("editable")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (!bl && BasicGraphUI.this.isEditing(BasicGraphUI.this.graph)) {
                        BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
                    }
                } else if (string.equals("selectionModel")) {
                    BasicGraphUI.this.setSelectionModel(BasicGraphUI.this.graph.getSelectionModel());
                } else if (string.equals("gridVisible") || string.equals("gridSize") || string.equals("gridColor") || string.equals("handleColor") || string.equals("lockedHandleColor") || string.equals("handleSize") || string.equals("portsVisible") || string.equals("antiAliased")) {
                    BasicGraphUI.this.graph.repaint();
                } else if (string.equals("scale")) {
                    BasicGraphUI.this.updateSize();
                } else if (string.equals("font")) {
                    BasicGraphUI.this.completeEditing();
                    BasicGraphUI.this.updateSize();
                } else if (string.equals("componentOrientation") && BasicGraphUI.this.graph != null) {
                    BasicGraphUI.this.graph.graphDidChange();
                }
            }
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient double _mouseToViewDelta_x = 0.0;
        protected transient double _mouseToViewDelta_y = 0.0;
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient CellView targetGroup;
        protected transient CellView ignoreTargetGroup;
        protected transient Rectangle2D cachedBounds;
        protected transient Point2D initialLocation;
        protected transient CellHandle[] handles;
        protected transient Point2D start = null;
        protected transient Point2D last;
        protected transient Point2D snapStart;
        protected transient Point2D snapLast;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient GraphContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(GraphContext graphContext) {
            this.context = graphContext;
            if (!graphContext.isEmpty()) {
                Object[] objectArray;
                this.views = graphContext.createTemporaryCellViews();
                Rectangle2D rectangle2D = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(graphContext.getCells()));
                if (graphContext.getDescendantCount() < MAXCELLS) {
                    this.contextViews = graphContext.createTemporaryContextViews();
                    this.initialLocation = BasicGraphUI.this.graph.toScreen(this.getInitialLocation(graphContext.getCells()));
                } else {
                    this.cachedBounds = rectangle2D;
                }
                if (this.initialLocation == null) {
                    this.initialLocation = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
                }
                if ((objectArray = graphContext.getCells()).length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    for (int i = 0; i < this.views.length; ++i) {
                        this.handles[i] = this.views[i].getHandle(graphContext);
                    }
                    this.portViews = graphContext.createTemporaryPortViews();
                }
            }
        }

        protected Point2D getInitialLocation(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                RectangularShape rectangularShape = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object;
                    if (BasicGraphUI.this.graphModel.isEdge(objectArray[i])) {
                        Point2D point2D;
                        object = BasicGraphUI.this.graphLayoutCache.getMapping(objectArray[i], false);
                        if (!(object instanceof EdgeView)) continue;
                        EdgeView edgeView = (EdgeView)object;
                        if (edgeView.getSource() == null && (point2D = edgeView.getPoint(0)) != null) {
                            if (rectangularShape == null) {
                                rectangularShape = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0);
                            } else {
                                Rectangle2D.union((Rectangle2D)rectangularShape, new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0), (Rectangle2D)rectangularShape);
                            }
                        }
                        if (edgeView.getTarget() != null || (point2D = edgeView.getPoint(edgeView.getPointCount() - 1)) == null) continue;
                        if (rectangularShape == null) {
                            rectangularShape = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0);
                            continue;
                        }
                        Rectangle2D.union((Rectangle2D)rectangularShape, new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.0, 0.0), (Rectangle2D)rectangularShape);
                        continue;
                    }
                    object = BasicGraphUI.this.graph.getCellBounds(objectArray[i]);
                    if (object == null) continue;
                    if (rectangularShape == null) {
                        rectangularShape = (Rectangle2D)((RectangularShape)object).clone();
                    }
                    Rectangle2D.union((Rectangle2D)rectangularShape, (Rectangle2D)object, (Rectangle2D)rectangularShape);
                }
                if (rectangularShape != null) {
                    return new Point2D.Double(rectangularShape.getX(), rectangularShape.getY());
                }
            }
            return null;
        }

        public GraphContext getContext() {
            return this.context;
        }

        public void paint(Graphics graphics) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].paint(graphics);
                }
            }
            this.blockPaint = true;
        }

        public void overlay(Graphics graphics) {
            Object object;
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                graphics.setColor(Color.black);
                graphics.drawRect((int)this.cachedBounds.getX(), (int)this.cachedBounds.getY(), (int)this.cachedBounds.getWidth() - 2, (int)this.cachedBounds.getHeight() - 2);
            } else {
                int n;
                object = (Graphics2D)graphics;
                AffineTransform affineTransform = ((Graphics2D)object).getTransform();
                ((Graphics2D)object).scale(BasicGraphUI.this.graph.getScale(), BasicGraphUI.this.graph.getScale());
                if (this.views != null) {
                    for (n = 0; n < this.views.length; ++n) {
                        BasicGraphUI.this.paintCell(graphics, this.views[n], this.views[n].getBounds(), true);
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    for (n = 0; n < this.contextViews.length; ++n) {
                        BasicGraphUI.this.paintCell(graphics, this.contextViews[n], this.contextViews[n].getBounds(), true);
                    }
                }
                if (!BasicGraphUI.this.graph.isPortsScaled()) {
                    ((Graphics2D)object).setTransform(affineTransform);
                }
                if (this.portViews != null && BasicGraphUI.this.graph.isPortsVisible()) {
                    BasicGraphUI.this.paintPorts(graphics, this.portViews);
                }
                ((Graphics2D)object).setTransform(affineTransform);
            }
            if (this.targetGroup != null) {
                object = BasicGraphUI.this.graph.toScreen((Rectangle2D)this.targetGroup.getBounds().clone());
                graphics.setColor(BasicGraphUI.this.graph.getHandleColor());
                graphics.fillRect((int)((RectangularShape)object).getX() - 1, (int)((RectangularShape)object).getY() - 1, (int)((RectangularShape)object).getWidth() + 2, (int)((RectangularShape)object).getHeight() + 2);
                graphics.setColor(BasicGraphUI.this.graph.getMarqueeColor());
                graphics.draw3DRect((int)((RectangularShape)object).getX() - 2, (int)((RectangularShape)object).getY() - 2, (int)((RectangularShape)object).getWidth() + 3, (int)((RectangularShape)object).getHeight() + 3, true);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && this.handles != null) {
                for (int i = this.handles.length - 1; i >= 0 && !mouseEvent.isConsumed(); --i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].mouseMoved(mouseEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && BasicGraphUI.this.graph.isMoveable()) {
                Object object;
                Point point;
                Object object2;
                CellView cellView;
                if (this.handles != null) {
                    for (int i = this.handles.length - 1; i >= 0; --i) {
                        if (this.handles[i] == null) continue;
                        this.handles[i].mousePressed(mouseEvent);
                        if (!mouseEvent.isConsumed()) continue;
                        this.activeHandle = this.handles[i];
                        return;
                    }
                }
                if (this.views != null && (cellView = this.findViewForPoint((Point2D)(object2 = BasicGraphUI.this.graph.fromScreen((Point2D)(point = mouseEvent.getPoint()).clone())))) != null) {
                    if (BasicGraphUI.this.snapSelectedView) {
                        object = cellView.getBounds();
                        this.start = BasicGraphUI.this.graph.toScreen(new Point2D.Double(((RectangularShape)object).getX(), ((RectangularShape)object).getY()));
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)this.start.clone());
                        this._mouseToViewDelta_x = ((Point2D)point).getX() - this.start.getX();
                        this._mouseToViewDelta_y = ((Point2D)point).getY() - this.start.getY();
                    } else {
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)point.clone());
                        this._mouseToViewDelta_x = this.snapStart.getX() - ((Point2D)point).getX();
                        this._mouseToViewDelta_y = this.snapStart.getY() - ((Point2D)point).getY();
                        this.start = (Point2D)this.snapStart.clone();
                    }
                    this.last = (Point2D)this.start.clone();
                    this.snapLast = (Point2D)this.snapStart.clone();
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!mouseEvent.isControlDown() || !BasicGraphUI.this.graph.isCloneable());
                    mouseEvent.consume();
                }
                if (BasicGraphUI.this.graph.isMoveIntoGroups() || BasicGraphUI.this.graph.isMoveOutOfGroups()) {
                    Object[] objectArray = this.context.getCells();
                    object2 = BasicGraphUI.this.graph.getModel().getParent(objectArray[0]);
                    for (int i = 1; i < objectArray.length; ++i) {
                        object = BasicGraphUI.this.graph.getModel().getParent(objectArray[i]);
                        if (object2 == object) continue;
                        object2 = null;
                        break;
                    }
                    if (object2 != null) {
                        this.ignoreTargetGroup = BasicGraphUI.this.graph.getGraphLayoutCache().getMapping(object2, false);
                    }
                }
            }
        }

        protected CellView findViewForPoint(Point2D point2D) {
            double d = BasicGraphUI.this.graph.getTolerance();
            Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - d, point2D.getY() - d, 2.0 * d, 2.0 * d);
            for (int i = 0; i < this.views.length; ++i) {
                if (!this.views[i].intersects(BasicGraphUI.this.graph, double_)) continue;
                return this.views[i];
            }
            return null;
        }

        protected CellView findUnselectedInnermostGroup(double d, double d2) {
            Object[] objectArray = BasicGraphUI.this.graph.getDescendants(BasicGraphUI.this.graph.getRoots());
            for (int i = objectArray.length - 1; i >= 0; --i) {
                CellView cellView = BasicGraphUI.this.graph.getGraphLayoutCache().getMapping(objectArray[i], false);
                if (cellView == null || cellView.isLeaf() || this.context.contains(cellView.getCell()) || !cellView.getBounds().contains(d, d2)) continue;
                return cellView;
            }
            return null;
        }

        protected void startDragging(MouseEvent mouseEvent) {
            this.isDragging = true;
            if (BasicGraphUI.this.graph.isDragEnabled()) {
                int n = mouseEvent.isControlDown() && BasicGraphUI.this.graph.isCloneable() ? 1 : 2;
                TransferHandler transferHandler = BasicGraphUI.this.graph.getTransferHandler();
                BasicGraphUI.this.setInsertionLocation(mouseEvent.getPoint());
                try {
                    transferHandler.exportAsDrag(BasicGraphUI.this.graph, mouseEvent, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Component getFirstOpaqueParent(Component component) {
            if (component != null) {
                for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
                    if (!component2.isOpaque() || component2 instanceof JViewport) continue;
                    return component2;
                }
            }
            return component;
        }

        protected void initOffscreen() {
            try {
                Rectangle rectangle = BasicGraphUI.this.graph.getBounds();
                this.offscreen = new BufferedImage(rectangle.width, rectangle.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, rectangle.width, rectangle.height);
                this.offgraphics.setColor(BasicGraphUI.this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, rectangle.width, rectangle.height);
                BasicGraphUI.this.graph.getUI().paint(this.offgraphics, BasicGraphUI.this.graph);
            }
            catch (Exception exception) {
                this.offscreen = null;
                this.offgraphics = null;
            }
            catch (Error error) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl = BasicGraphUI.this.isConstrainedMoveEvent(mouseEvent);
            Rectangle2D rectangle2D = null;
            if (this.firstDrag && BasicGraphUI.this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            if (mouseEvent != null && !mouseEvent.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseDragged(mouseEvent);
                } else if (this.start != null) {
                    Point2D point2D;
                    Graphics graphics = this.offgraphics != null ? this.offgraphics : BasicGraphUI.this.graph.getGraphics();
                    Point point = mouseEvent.getPoint();
                    Point2D.Double double_ = new Point2D.Double(point.getX() - this._mouseToViewDelta_x, point.getY() - this._mouseToViewDelta_y);
                    Point2D point2D2 = point2D = BasicGraphUI.this.graph.snap(double_);
                    int n = BasicGraphUI.this.graph.getMinimumMove();
                    double d = point2D2.getX() - this.start.getX();
                    double d2 = point2D2.getY() - this.start.getY();
                    if (this.isMoving || Math.abs(d) > (double)n || Math.abs(d2) > (double)n) {
                        boolean bl2 = false;
                        this.isMoving = true;
                        if (this.disconnect == null && BasicGraphUI.this.graph.isDisconnectOnMove()) {
                            this.disconnect = this.context.disconnect(BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views));
                        }
                        double d3 = point2D2.getX() - this.start.getX();
                        double d4 = point2D2.getY() - this.start.getY();
                        d = point2D2.getX() - this.last.getX();
                        d2 = point2D2.getY() - this.last.getY();
                        if (bl && this.cachedBounds == null) {
                            if (Math.abs(d3) < Math.abs(d4)) {
                                d = 0.0;
                                d2 = d4;
                            } else {
                                d = d3;
                                d2 = 0.0;
                            }
                        } else if (!BasicGraphUI.this.graph.isMoveBelowZero() && this.last != null && this.initialLocation != null && this.start != null) {
                            if (this.initialLocation.getX() + d3 < 0.0) {
                                d = this.start.getX() - this.last.getX() - this.initialLocation.getX();
                            }
                            if (this.initialLocation.getY() + d4 < 0.0) {
                                d2 = this.start.getY() - this.last.getY() - this.initialLocation.getY();
                            }
                        }
                        double d5 = BasicGraphUI.this.graph.getScale();
                        d = (int)(d / d5);
                        d2 = (int)(d2 / d5);
                        graphics.setColor(BasicGraphUI.this.graph.getForeground());
                        graphics.setXORMode(BasicGraphUI.this.graph.getBackground().darker());
                        if (BasicGraphUI.this.graph.isDragEnabled() && !this.isDragging) {
                            this.startDragging(mouseEvent);
                        }
                        if (d != 0.0 || d2 != 0.0) {
                            Object object;
                            if (!(this.snapLast.equals(this.snapStart) || this.offscreen == null && this.blockPaint)) {
                                this.overlay(graphics);
                                bl2 = true;
                            }
                            this.isContextVisible = (!mouseEvent.isControlDown() || !BasicGraphUI.this.graph.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS;
                            this.blockPaint = false;
                            if (this.offscreen != null) {
                                rectangle2D = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views));
                                object = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (object != null) {
                                    rectangle2D.add((Rectangle2D)object);
                                }
                            }
                            if (bl && this.cachedBounds == null) {
                                object = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                                for (int i = 0; i < ((CellView[])object).length; ++i) {
                                    CellView cellView = BasicGraphUI.this.graphLayoutCache.getMapping(object[i].getCell(), false);
                                    AttributeMap attributeMap = cellView.getAllAttributes();
                                    object[i].changeAttributes((AttributeMap)attributeMap.clone());
                                    object[i].refresh(BasicGraphUI.this.graph.getModel(), this.context, false);
                                }
                            }
                            if (this.cachedBounds != null) {
                                this.cachedBounds.setFrame(this.cachedBounds.getX() + d * d5, this.cachedBounds.getY() + d2 * d5, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                            } else {
                                GraphLayoutCache.translateViews(this.views, d, d2);
                                if (this.views != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.views);
                                }
                                if (this.contextViews != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.contextViews);
                                }
                            }
                            Object object2 = object = this.ignoreTargetGroup != null ? (Rectangle2D)this.ignoreTargetGroup.getBounds().clone() : null;
                            if (this.targetGroup != null) {
                                Rectangle2D rectangle2D2 = BasicGraphUI.this.graph.toScreen((Rectangle2D)this.targetGroup.getBounds().clone());
                                if (rectangle2D != null) {
                                    rectangle2D.add(rectangle2D2);
                                } else {
                                    rectangle2D = rectangle2D2;
                                }
                            }
                            this.targetGroup = null;
                            if (BasicGraphUI.this.graph.isMoveIntoGroups() && (object == null || !((RectangularShape)object).intersects(AbstractCellView.getBounds(this.views)))) {
                                CellView cellView = this.targetGroup = mouseEvent.isControlDown() ? null : this.findUnselectedInnermostGroup(point2D.getX() / d5, point2D.getY() / d5);
                                if (this.targetGroup == this.ignoreTargetGroup) {
                                    this.targetGroup = null;
                                }
                            }
                            if (!point2D.equals(this.snapStart)) {
                                this.overlay(graphics);
                                bl2 = true;
                            }
                            if (bl) {
                                this.last = (Point2D)this.start.clone();
                            }
                            this.last.setLocation(this.last.getX() + d * d5, this.last.getY() + d2 * d5);
                            this.snapLast = point2D;
                            if (bl2 && this.offscreen != null) {
                                rectangle2D.add(BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views)));
                                Rectangle2D rectangle2D3 = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (rectangle2D3 != null) {
                                    rectangle2D.add(rectangle2D3);
                                }
                                int n2 = PortView.SIZE + 4;
                                if (BasicGraphUI.this.graph.isPortsScaled()) {
                                    n2 = (int)(BasicGraphUI.this.graph.getScale() * (double)n2);
                                }
                                int n3 = n2 / 2;
                                rectangle2D.setFrame(rectangle2D.getX() - (double)n3, rectangle2D.getY() - (double)n3, rectangle2D.getWidth() + (double)n2, rectangle2D.getHeight() + (double)n2);
                                double d6 = Math.max(0.0, rectangle2D.getX());
                                double d7 = Math.max(0.0, rectangle2D.getY());
                                double d8 = d6 + rectangle2D.getWidth();
                                double d9 = d7 + rectangle2D.getHeight();
                                if (this.isDragging && !DNDPREVIEW) {
                                    return;
                                }
                                BasicGraphUI.this.graph.getGraphics().drawImage(this.offscreen, (int)d6, (int)d7, (int)d8, (int)d9, (int)d6, (int)d7, (int)d8, (int)d9, BasicGraphUI.this.graph);
                            }
                        }
                    }
                }
            } else if (mouseEvent == null) {
                BasicGraphUI.this.graph.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                block13: {
                    try {
                        if (mouseEvent == null || mouseEvent.isConsumed()) break block13;
                        if (this.activeHandle != null) {
                            this.activeHandle.mouseReleased(mouseEvent);
                            this.activeHandle = null;
                            break block13;
                        }
                        if (!this.isMoving || mouseEvent.getPoint().equals(this.start)) break block13;
                        if (this.cachedBounds != null) {
                            double d = (double)mouseEvent.getX() - this.start.getX();
                            double d2 = (double)mouseEvent.getY() - this.start.getY();
                            Point2D point2D = BasicGraphUI.this.graph.fromScreen(new Point2D.Double(d, d2));
                            GraphLayoutCache.translateViews(this.views, point2D.getX(), point2D.getY());
                        }
                        Object[] objectArray = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                        Map map = GraphConstants.createAttributes(objectArray, null);
                        if (mouseEvent.isControlDown() && BasicGraphUI.this.graph.isCloneable()) {
                            Object object;
                            Object[] objectArray2 = BasicGraphUI.this.graph.getDescendants(BasicGraphUI.this.graph.order(this.context.getCells()));
                            Map map2 = BasicGraphUI.this.graphLayoutCache.getHiddenMapping();
                            for (int i = 0; i < objectArray2.length; ++i) {
                                CellView cellView;
                                object = map.get(objectArray2[i]);
                                if (object != null || (cellView = (CellView)map2.get(objectArray2[i])) == null || BasicGraphUI.this.graphModel.isPort(cellView.getCell())) continue;
                                AttributeMap attributeMap = (AttributeMap)cellView.getAllAttributes().clone();
                                map.put(objectArray2[i], attributeMap.clone());
                            }
                            ConnectionSet connectionSet = ConnectionSet.create(BasicGraphUI.this.graphModel, objectArray2, false);
                            object = ParentMap.create(BasicGraphUI.this.graphModel, objectArray2, false, true);
                            objectArray2 = BasicGraphUI.this.graphLayoutCache.insertClones(objectArray2, BasicGraphUI.this.graph.cloneCells(objectArray2), map, connectionSet, (ParentMap)object, 0.0, 0.0);
                        } else if (BasicGraphUI.this.graph.isMoveable()) {
                            ParentMap parentMap = null;
                            if (this.targetGroup != null) {
                                parentMap = new ParentMap(this.context.getCells(), this.targetGroup.getCell());
                            } else if (BasicGraphUI.this.graph.isMoveOutOfGroups() && this.ignoreTargetGroup != null && !this.ignoreTargetGroup.getBounds().intersects(AbstractCellView.getBounds(this.views))) {
                                parentMap = new ParentMap(this.context.getCells(), null);
                            }
                            BasicGraphUI.this.graph.getGraphLayoutCache().edit(map, this.disconnect, parentMap, null);
                        }
                        mouseEvent.consume();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var11_17 = null;
                        this.ignoreTargetGroup = null;
                        this.targetGroup = null;
                        this.initialLocation = null;
                        this.isDragging = false;
                        this.disconnect = null;
                        this.offscreen = null;
                        this.firstDrag = true;
                        this.start = null;
                    }
                }
                Object var11_16 = null;
                this.ignoreTargetGroup = null;
                this.targetGroup = null;
                this.initialLocation = null;
                this.isDragging = false;
                this.disconnect = null;
                this.offscreen = null;
                this.firstDrag = true;
                this.start = null;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                this.ignoreTargetGroup = null;
                this.targetGroup = null;
                this.initialLocation = null;
                this.isDragging = false;
                this.disconnect = null;
                this.offscreen = null;
                this.firstDrag = true;
                this.start = null;
                throw throwable;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        public void mousePressed(MouseEvent mouseEvent) {
            this.handler = null;
            if (!mouseEvent.isConsumed() && BasicGraphUI.this.graph.isEnabled()) {
                BasicGraphUI.this.graph.requestFocus();
                int n = BasicGraphUI.this.graph.getTolerance();
                Rectangle2D rectangle2D = BasicGraphUI.this.graph.fromScreen(new Rectangle2D.Double(mouseEvent.getX() - n, mouseEvent.getY() - n, 2 * n, 2 * n));
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.intersects(BasicGraphUI.this.graph, rectangle2D) ? BasicGraphUI.this.focus : null;
                this.cell = BasicGraphUI.this.graph.getNextSelectableViewAt(BasicGraphUI.this.focus, mouseEvent.getX(), mouseEvent.getY());
                if (BasicGraphUI.this.focus == null) {
                    BasicGraphUI.this.focus = this.cell;
                }
                BasicGraphUI.this.completeEditing();
                if (!BasicGraphUI.this.isForceMarqueeEvent(mouseEvent)) {
                    if (mouseEvent.getClickCount() == BasicGraphUI.this.graph.getEditClickCount() && BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.isLeaf() && BasicGraphUI.this.focus.getParentView() == null && BasicGraphUI.this.graph.isCellEditable(BasicGraphUI.this.focus.getCell()) && this.handleEditTrigger(this.cell.getCell(), mouseEvent)) {
                        mouseEvent.consume();
                        this.cell = null;
                    } else if (!BasicGraphUI.this.isToggleSelectionEvent(mouseEvent)) {
                        if (BasicGraphUI.this.handle != null) {
                            BasicGraphUI.this.handle.mousePressed(mouseEvent);
                            this.handler = BasicGraphUI.this.handle;
                        }
                        if (!mouseEvent.isConsumed() && this.cell != null && !BasicGraphUI.this.graph.isCellSelected(this.cell)) {
                            BasicGraphUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                            BasicGraphUI.this.focus = this.cell;
                            if (BasicGraphUI.this.handle != null) {
                                BasicGraphUI.this.handle.mousePressed(mouseEvent);
                                this.handler = BasicGraphUI.this.handle;
                            }
                            mouseEvent.consume();
                            this.cell = null;
                        }
                    }
                }
                if (!(mouseEvent.isConsumed() || BasicGraphUI.this.marquee == null || BasicGraphUI.this.isToggleSelectionEvent(mouseEvent) && BasicGraphUI.this.focus != null)) {
                    BasicGraphUI.this.marquee.mousePressed(mouseEvent);
                    this.handler = BasicGraphUI.this.marquee;
                }
            }
        }

        protected boolean handleEditTrigger(Object object, MouseEvent mouseEvent) {
            BasicGraphUI.this.graph.scrollCellToVisible(object);
            if (object != null) {
                BasicGraphUI.this.startEditing(object, mouseEvent);
            }
            return BasicGraphUI.this.graph.isEditing();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            BasicGraphUI.autoscroll(BasicGraphUI.this.graph, mouseEvent.getPoint());
            if (BasicGraphUI.this.graph.isEnabled()) {
                if (this.handler != null && this.handler == BasicGraphUI.this.marquee) {
                    BasicGraphUI.this.marquee.mouseDragged(mouseEvent);
                } else if (this.handler == null && !BasicGraphUI.this.isEditing(BasicGraphUI.this.graph) && BasicGraphUI.this.focus != null) {
                    if (!BasicGraphUI.this.graph.isCellSelected(BasicGraphUI.this.focus.getCell())) {
                        BasicGraphUI.this.selectCellForEvent(BasicGraphUI.this.focus.getCell(), mouseEvent);
                        this.cell = null;
                    }
                    if (BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mousePressed(mouseEvent);
                    }
                    this.handler = BasicGraphUI.this.handle;
                }
                if (BasicGraphUI.this.handle != null && this.handler == BasicGraphUI.this.handle) {
                    BasicGraphUI.this.handle.mouseDragged(mouseEvent);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.previousCursor == null) {
                this.previousCursor = BasicGraphUI.this.graph.getCursor();
            }
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                if (BasicGraphUI.this.marquee != null) {
                    BasicGraphUI.this.marquee.mouseMoved(mouseEvent);
                }
                if (BasicGraphUI.this.handle != null) {
                    BasicGraphUI.this.handle.mouseMoved(mouseEvent);
                }
                if (!mouseEvent.isConsumed() && this.previousCursor != null) {
                    BasicGraphUI.this.graph.setCursor(this.previousCursor);
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (mouseEvent != null && !mouseEvent.isConsumed() && BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                    if (this.handler == BasicGraphUI.this.marquee && BasicGraphUI.this.marquee != null) {
                        BasicGraphUI.this.marquee.mouseReleased(mouseEvent);
                    } else if (this.handler == BasicGraphUI.this.handle && BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mouseReleased(mouseEvent);
                    }
                    if (this.isDescendant(this.cell, BasicGraphUI.this.focus) && mouseEvent.getModifiers() != 0) {
                        this.cell = BasicGraphUI.this.focus;
                    }
                    if (!mouseEvent.isConsumed() && this.cell != null) {
                        Object object = this.cell.getCell();
                        boolean bl = BasicGraphUI.this.graph.isCellSelected(object);
                        BasicGraphUI.this.selectCellForEvent(object, mouseEvent);
                        BasicGraphUI.this.focus = this.cell;
                        this.postProcessSelection(mouseEvent, object, bl);
                    }
                }
            }
            finally {
                this.handler = null;
                this.cell = null;
            }
        }

        protected void postProcessSelection(MouseEvent mouseEvent, Object object, boolean bl) {
            if (bl && BasicGraphUI.this.graph.isCellSelected(object) && mouseEvent.getModifiers() != 0) {
                Object object2 = object;
                Object object3 = null;
                while ((object3 = BasicGraphUI.this.graphModel.getParent(object2)) != null && BasicGraphUI.this.graphLayoutCache.isVisible(object3)) {
                    object2 = object3;
                }
                BasicGraphUI.this.selectCellForEvent(object2, mouseEvent);
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(object2, false);
            }
        }

        protected boolean isDescendant(CellView cellView, CellView cellView2) {
            Object object;
            if (cellView == null || cellView2 == null) {
                return false;
            }
            Object object2 = cellView.getCell();
            Object object3 = object = cellView2.getCell();
            do {
                if (object3 != object2) continue;
                return true;
            } while ((object3 = BasicGraphUI.this.graphModel.getParent(object3)) != null);
            return false;
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.hasFocus() && BasicGraphUI.this.graph.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                if (BasicGraphUI.this.graph.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener actionListener = BasicGraphUI.this.graph.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = actionListener instanceof Action ? (Action)actionListener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (BasicGraphUI.this.marquee != null) {
                            BasicGraphUI.this.marquee.mouseReleased(null);
                        }
                        if (BasicGraphUI.this.mouseListener != null) {
                            BasicGraphUI.this.mouseListener.mouseReleased(null);
                        }
                        BasicGraphUI.this.updateHandle();
                        BasicGraphUI.this.graph.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(BasicGraphUI.this.graph, 1001, ""));
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicGraphUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicGraphUI.this.completeEditing(false, false, false);
        }
    }

    public class GraphSelectionHandler
    implements GraphSelectionListener,
    Serializable {
        public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
            BasicGraphUI.this.updateHandle();
            Object[] objectArray = graphSelectionEvent.getCells();
            if (objectArray != null && objectArray.length <= MAXCLIPCELLS) {
                Rectangle2D rectangle2D = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(objectArray));
                if (BasicGraphUI.this.focus != null) {
                    if (rectangle2D != null) {
                        Rectangle2D.union(rectangle2D, BasicGraphUI.this.focus.getBounds(), rectangle2D);
                    } else {
                        rectangle2D = BasicGraphUI.this.focus.getBounds();
                    }
                }
                if (BasicGraphUI.this.lastFocus != null) {
                    if (rectangle2D != null) {
                        Rectangle2D.union(rectangle2D, BasicGraphUI.this.lastFocus.getBounds(), rectangle2D);
                    } else {
                        rectangle2D = BasicGraphUI.this.lastFocus.getBounds();
                    }
                }
                if (rectangle2D != null) {
                    int n = (int)((double)BasicGraphUI.this.graph.getHandleSize() * BasicGraphUI.this.graph.getScale()) + 1;
                    BasicGraphUI.this.updateHandle();
                    BasicGraphUI.this.graph.repaint((int)rectangle2D.getX() - n, (int)rectangle2D.getY() - n, (int)rectangle2D.getWidth() + 2 * n, (int)rectangle2D.getHeight() + 2 * n);
                }
            } else {
                BasicGraphUI.this.graph.repaint();
            }
        }
    }

    public class GraphLayoutCacheHandler
    implements GraphLayoutCacheListener,
    Serializable {
        public void graphLayoutCacheChanged(GraphLayoutCacheEvent graphLayoutCacheEvent) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = graphLayoutCacheEvent.getChange().getChanged();
            if (objectArray3 != null && objectArray3.length > 0) {
                for (int i = 0; i < objectArray3.length; ++i) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(objectArray3[i], false));
                }
            }
            if ((objectArray2 = graphLayoutCacheEvent.getChange().getInserted()) != null && objectArray2.length > 0 && BasicGraphUI.this.graphLayoutCache.isSelectsLocalInsertedCells() && (!BasicGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() || BasicGraphUI.this.graphLayoutCache.isPartial()) && BasicGraphUI.this.graph.isEnabled() && (objectArray = DefaultGraphModel.getRoots(BasicGraphUI.this.graphModel, objectArray2)) != null && objectArray.length > 0) {
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(objectArray[0], false);
                BasicGraphUI.this.graph.setSelectionCells(objectArray);
            }
            BasicGraphUI.this.updateSize();
        }
    }

    public class GraphModelHandler
    implements GraphModelListener,
    Serializable {
        public void graphChanged(GraphModelEvent graphModelEvent) {
            Object[] objectArray;
            int n;
            Object[] objectArray2 = graphModelEvent.getChange().getRemoved();
            if (objectArray2 != null && objectArray2.length > 0) {
                for (int i = 0; i < objectArray2.length && BasicGraphUI.this.focus != null; ++i) {
                    if (objectArray2[i] != BasicGraphUI.this.focus.getCell()) continue;
                    BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                    BasicGraphUI.this.focus = null;
                    break;
                }
                BasicGraphUI.this.graph.getSelectionModel().removeSelectionCells(objectArray2);
            }
            if (BasicGraphUI.this.graphLayoutCache != null) {
                BasicGraphUI.this.graphLayoutCache.graphChanged(graphModelEvent.getChange());
            }
            Object[] objectArray3 = graphModelEvent.getChange().getInserted();
            Object[] objectArray4 = graphModelEvent.getChange().getChanged();
            if (objectArray3 != null && objectArray3.length > 0) {
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(objectArray3[0], false);
                for (n = 0; n < objectArray3.length; ++n) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(objectArray3[n], false));
                }
            }
            if (objectArray4 != null && objectArray4.length > 0) {
                for (n = 0; n < objectArray4.length; ++n) {
                    BasicGraphUI.this.graph.updateAutoSize(BasicGraphUI.this.graphLayoutCache.getMapping(objectArray4[n], false));
                }
            }
            if (!BasicGraphUI.this.graphLayoutCache.isPartial() && BasicGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() && BasicGraphUI.this.graph.isEnabled() && (objectArray = DefaultGraphModel.getRoots(BasicGraphUI.this.graphModel, objectArray3)) != null && objectArray.length > 0) {
                BasicGraphUI.this.lastFocus = BasicGraphUI.this.focus;
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(objectArray[0], false);
                BasicGraphUI.this.graph.setSelectionCells(objectArray);
            }
            BasicGraphUI.this.updateSize();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicGraphUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicGraphUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            for (container = BasicGraphUI.this.graph.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicGraphUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }
}

