/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jess.JessException;
import tico.board.TBoard;
import tico.board.TProject;
import tico.components.TButton;
import tico.components.TComboBox;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.interpreter.TInterpreter;
import tico.rules.TGenerateRules;
import tico.rules.TShowResults;
import tico.rules.TUser;
import tico.rules.database.TLoadLimitation;
import tico.rules.database.TLoadParameter;
import tico.rules.database.TLoadUser;

public class TValidationDialog
extends TDialog {
    private TProject theProject = null;
    private TBoard theBoard = null;
    private TInterpreter theInterpreter = null;
    private TComboBox loadCombo;
    public Vector<Integer> limitationsValue = new Vector();
    public Vector<String> limitationsName = new Vector();
    public Vector<JSpinner> spinnerList = new Vector();
    private static Vector<JLabel> rangeLabelList = new Vector();
    private static Vector<JLabel> labelList = new Vector();

    public TValidationDialog(TEditor editor, TProject project) {
        super(editor, TLanguage.getString("TValidationDialog.PROJECT_TITLE"), true);
        this.theProject = project;
        this.clearComponents();
        this.createComponents(editor);
    }

    public TValidationDialog(TEditor editor, TBoard board) {
        super(editor, TLanguage.getString("TValidationDialog.BOARD_TITLE"), true);
        this.theBoard = board;
        this.clearComponents();
        this.createComponents(editor);
    }

    public TValidationDialog(TInterpreter interpreter) {
        super(interpreter, TLanguage.getString("TValidationDialog.INTERPRETER_TITLE"), true);
        this.theInterpreter = interpreter;
        this.clearComponents();
        this.createComponents(interpreter);
    }

    public TValidationDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.clearComponents();
    }

    private void clearComponents() {
        this.limitationsName.clear();
        this.limitationsValue.clear();
        this.spinnerList.clear();
        labelList.clear();
        rangeLabelList.clear();
    }

    private void createComponents(TEditor editor) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TValidationDialog.TAB"), this.createEntryPanel());
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(editor), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private void createComponents(TInterpreter interpreter) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TValidationDialog.TAB"), this.createEntryPanel());
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(interpreter), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(interpreter);
        this.setVisible(true);
    }

    private JPanel createEntryPanel() {
        JPanel entryPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        entryPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        entryPanel.add((Component)this.createSpinnerPanel(), c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        entryPanel.add((Component)this.createComboPanel(), c2);
        return entryPanel;
    }

    protected JPanel createSpinnerPanel() {
        JPanel spinnerPanel = new JPanel();
        this.createSpinners();
        GridBagConstraints c2 = new GridBagConstraints();
        spinnerPanel.setLayout(new GridBagLayout());
        spinnerPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TUsersAdminDialog.TEXT_TITLE")));
        int y2 = 0;
        int i2 = 0;
        while (i2 < this.spinnerList.size()) {
            labelList.get(i2).setHorizontalAlignment(2);
            c2.fill = 1;
            c2.insets = new Insets(5, 10, 5, 15);
            c2.gridx = 0;
            c2.gridy = y2;
            spinnerPanel.add((Component)labelList.get(i2), c2);
            c2.fill = 1;
            c2.insets = new Insets(5, 5, 5, 10);
            c2.gridx = 1;
            c2.gridy = y2;
            spinnerPanel.add((Component)rangeLabelList.get(i2), c2);
            c2.fill = 1;
            c2.insets = new Insets(5, 5, 5, 10);
            c2.gridx = 2;
            c2.gridy = y2++;
            spinnerPanel.add((Component)this.spinnerList.get(i2), c2);
            ++i2;
        }
        return spinnerPanel;
    }

    private JPanel createComboPanel() {
        JPanel comboPanel = new JPanel();
        Vector<String> nameList = new Vector<String>();
        Vector<Object> userList = new Vector();
        TLoadUser load_u = new TLoadUser();
        userList = load_u.loadAllUsers();
        nameList.add("");
        int i2 = 0;
        while (i2 < userList.size()) {
            nameList.add(((TUser)userList.get(i2)).getName());
            ++i2;
        }
        this.loadCombo = new TComboBox((Vector)nameList);
        this.loadCombo.setSelectedIndex(0);
        TButton loadButton = new TButton(TLanguage.getString("TValidationDialog.LOAD_USER_BUTTON"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TLoadUser load_u = new TLoadUser();
                String userName = (String)TValidationDialog.this.loadCombo.getSelectedItem();
                if (userName != "") {
                    JSpinner spinner;
                    TUser user = new TUser();
                    user = load_u.loadUserByName(userName);
                    int j2 = 0;
                    while (j2 < TValidationDialog.this.spinnerList.size()) {
                        spinner = TValidationDialog.this.spinnerList.get(j2);
                        spinner.setValue(0);
                        TValidationDialog.this.spinnerList.set(j2, spinner);
                        ++j2;
                    }
                    j2 = 0;
                    while (j2 < user.getAttributeCount()) {
                        spinner = TValidationDialog.this.spinnerList.get(j2);
                        spinner.setValue(user.getAttribute(j2).getValue());
                        TValidationDialog.this.spinnerList.set(j2, spinner);
                        ++j2;
                    }
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        comboPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        comboPanel.add((Component)this.loadCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 10, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        comboPanel.add((Component)loadButton, c2);
        return comboPanel;
    }

    private void createSpinners() {
        TLoadLimitation load_l = new TLoadLimitation();
        this.limitationsName = load_l.getLimitationsName();
        Vector<String> list = new Vector<String>();
        Vector<Integer> sizes = new Vector<Integer>();
        int i2 = 0;
        while (i2 < this.limitationsName.size()) {
            if (!list.contains(this.limitationsName.get(i2))) {
                list.add(this.limitationsName.get(i2));
                sizes.add(1);
            } else {
                sizes.setElementAt(Integer.valueOf((Integer)sizes.lastElement()) + 1, sizes.indexOf(sizes.lastElement()));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < list.size()) {
            SpinnerNumberModel model = new SpinnerNumberModel(0, 0, (Integer)sizes.get(i2) - 1, 1);
            JSpinner spinner = new JSpinner(model);
            this.spinnerList.add(spinner);
            if (TLanguage.getString("TValidationDialog." + ((String)list.elementAt(i2)).toUpperCase()).startsWith("!")) {
                labelList.add(new JLabel((String)list.elementAt(i2)));
            } else {
                labelList.add(new JLabel(TLanguage.getString("TValidationDialog." + ((String)list.elementAt(i2)).toUpperCase())));
            }
            int init = 0;
            String range = String.valueOf(Integer.valueOf(init).toString()) + "/" + Integer.valueOf((Integer)sizes.get(i2) - 1).toString();
            rangeLabelList.add(new JLabel(range));
            ++i2;
        }
    }

    private JPanel createButtonPanel(final TEditor editor) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton helpButton = new TButton(TLanguage.getString("TValidationDialog.BUTTONDESIGN"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int j2 = 0;
                while (j2 < TValidationDialog.this.spinnerList.size()) {
                    TValidationDialog.this.limitationsValue.add((Integer)TValidationDialog.this.spinnerList.elementAt(j2).getValue());
                    ++j2;
                }
                TValidationDialog.this.limitationsValue.setSize(TValidationDialog.this.spinnerList.size());
                Vector<String> nameList = new Vector<String>();
                int i2 = 0;
                while (i2 < TValidationDialog.this.limitationsName.size()) {
                    if (!nameList.contains(TValidationDialog.this.limitationsName.get(i2))) {
                        nameList.add(TValidationDialog.this.limitationsName.get(i2));
                    }
                    ++i2;
                }
                TLoadParameter load_p = new TLoadParameter();
                load_p.getParametersForValidation(nameList, TValidationDialog.this.limitationsValue);
                TValidationDialog.this.dispose();
                TShowResults results = new TShowResults();
                if (TValidationDialog.this.theProject != null) {
                    results.designRules("project");
                } else {
                    results.designRules("board");
                }
                results.createDialog(editor, "DESIGNRULES");
            }
        });
        buttonPanel.add(helpButton);
        TButton validateButton = new TButton(TLanguage.getString("TValidationDialog.BUTTONVALIDATE"));
        validateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TGenerateRules gRules;
                int j2 = 0;
                while (j2 < TValidationDialog.this.spinnerList.size()) {
                    TValidationDialog.this.limitationsValue.add((Integer)TValidationDialog.this.spinnerList.elementAt(j2).getValue());
                    ++j2;
                }
                TValidationDialog.this.limitationsValue.setSize(TValidationDialog.this.spinnerList.size());
                Vector<String> nameList = new Vector<String>();
                int i2 = 0;
                while (i2 < TValidationDialog.this.limitationsName.size()) {
                    if (!nameList.contains(TValidationDialog.this.limitationsName.get(i2))) {
                        nameList.add(TValidationDialog.this.limitationsName.get(i2));
                    }
                    ++i2;
                }
                TLoadParameter load_p = new TLoadParameter();
                load_p.getParametersForValidation(nameList, TValidationDialog.this.limitationsValue);
                if (TValidationDialog.this.theProject != null) {
                    gRules = new TGenerateRules();
                    try {
                        gRules.getProjectAttributes(TValidationDialog.this.theProject);
                    }
                    catch (JessException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    gRules = new TGenerateRules();
                    try {
                        gRules.getBoardAttributes(TValidationDialog.this.theBoard);
                    }
                    catch (JessException e1) {
                        e1.printStackTrace();
                    }
                }
                TValidationDialog.this.dispose();
                TShowResults results = new TShowResults();
                results.createDialog(editor, "VALIDATION");
            }
        });
        buttonPanel.add(validateButton);
        TButton closeButton = new TButton(TLanguage.getString("TValidationDialog.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TValidationDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private JPanel createButtonPanel(final TInterpreter interpreter) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton helpButton = new TButton(TLanguage.getString("TValidationDialog.BUTTONDESIGN"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int j2 = 0;
                while (j2 < TValidationDialog.this.spinnerList.size()) {
                    TValidationDialog.this.limitationsValue.add((Integer)TValidationDialog.this.spinnerList.elementAt(j2).getValue());
                    ++j2;
                }
                TValidationDialog.this.limitationsValue.setSize(TValidationDialog.this.spinnerList.size());
                Vector<String> nameList = new Vector<String>();
                int i2 = 0;
                while (i2 < TValidationDialog.this.limitationsName.size()) {
                    if (!nameList.contains(TValidationDialog.this.limitationsName.get(i2))) {
                        nameList.add(TValidationDialog.this.limitationsName.get(i2));
                    }
                    ++i2;
                }
                TLoadParameter load_p = new TLoadParameter();
                load_p.getParametersForValidation(nameList, TValidationDialog.this.limitationsValue);
                TShowResults results = new TShowResults();
                results.designRules("interpreter");
                results.createDialog(interpreter, "DESIGNRULES");
                TValidationDialog.this.dispose();
            }
        });
        buttonPanel.add(helpButton);
        TButton validateButton = new TButton(TLanguage.getString("TValidationDialog.BUTTONVALIDATE"));
        validateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int j2 = 0;
                while (j2 < TValidationDialog.this.spinnerList.size()) {
                    TValidationDialog.this.limitationsValue.add((Integer)TValidationDialog.this.spinnerList.elementAt(j2).getValue());
                    ++j2;
                }
                TValidationDialog.this.limitationsValue.setSize(TValidationDialog.this.spinnerList.size());
                Vector<String> nameList = new Vector<String>();
                int i2 = 0;
                while (i2 < TValidationDialog.this.limitationsName.size()) {
                    if (!nameList.contains(TValidationDialog.this.limitationsName.get(i2))) {
                        nameList.add(TValidationDialog.this.limitationsName.get(i2));
                    }
                    ++i2;
                }
                TLoadParameter load_p = new TLoadParameter();
                load_p.getParametersForValidation(nameList, TValidationDialog.this.limitationsValue);
                TGenerateRules gRules = new TGenerateRules();
                try {
                    gRules.getInterpreterAttributes(TValidationDialog.this.theInterpreter);
                }
                catch (JessException e1) {
                    e1.printStackTrace();
                }
                TValidationDialog.this.dispose();
                TShowResults results = new TShowResults();
                results.createDialog(interpreter, "VALIDATION");
            }
        });
        buttonPanel.add(validateButton);
        TButton closeButton = new TButton(TLanguage.getString("TValidationDialog.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TValidationDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }
}

