/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import tico.components.TButton;
import tico.components.TComboBox;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.rules.TAttribute;
import tico.rules.TUser;
import tico.rules.database.TDeleteUser;
import tico.rules.database.TLoadLimitation;
import tico.rules.database.TLoadUser;
import tico.rules.database.TSaveUser;
import tico.rules.dialogs.TValidationDialog;

public class TUsersAdminDialog
extends TValidationDialog {
    private TComboBox loadCombo;
    private TComboBox saveCombo;
    private Vector<String> nameList;

    public TUsersAdminDialog(TEditor editor) {
        super(editor, TLanguage.getString("TUsersAdminDialog.TITLE"), true);
        this.createComponents(editor);
    }

    private void createComponents(TEditor editor) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TUsersAdminDialog.TAB"), this.createEntryPanel());
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(editor), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private JPanel createEntryPanel() {
        JPanel entryPanel = new JPanel();
        GridBagConstraints c2 = new GridBagConstraints();
        entryPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        entryPanel.add((Component)this.createSpinnerPanel(), c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        entryPanel.add((Component)this.createComboPanel(), c2);
        return entryPanel;
    }

    private JPanel createComboPanel() {
        JPanel comboPanel = new JPanel();
        TLoadUser load_u = new TLoadUser();
        Vector<Object> userList = new Vector();
        userList = load_u.loadAllUsers();
        this.nameList = new Vector();
        this.nameList.add("");
        int i2 = 0;
        while (i2 < userList.size()) {
            this.nameList.add(((TUser)userList.get(i2)).getName());
            ++i2;
        }
        this.loadCombo = new TComboBox((Vector)this.nameList);
        this.loadCombo.setSelectedIndex(0);
        this.saveCombo = new TComboBox((Vector)this.nameList);
        this.saveCombo.setSelectedIndex(0);
        this.saveCombo.setEditable(true);
        TButton loadButton = new TButton(TLanguage.getString("TUsersAdminDialog.LOAD_USER_BUTTON"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TLoadUser load_u = new TLoadUser();
                String userName = (String)TUsersAdminDialog.this.loadCombo.getSelectedItem();
                if (userName != "") {
                    JSpinner spinner;
                    TUser user = new TUser();
                    user = load_u.loadUserByName(userName);
                    int j2 = 0;
                    while (j2 < TUsersAdminDialog.this.spinnerList.size()) {
                        spinner = (JSpinner)TUsersAdminDialog.this.spinnerList.get(j2);
                        spinner.setValue(0);
                        TUsersAdminDialog.this.spinnerList.set(j2, spinner);
                        ++j2;
                    }
                    j2 = 0;
                    while (j2 < user.getAttributeCount()) {
                        spinner = (JSpinner)TUsersAdminDialog.this.spinnerList.get(j2);
                        spinner.setValue(user.getAttribute(j2).getValue());
                        TUsersAdminDialog.this.spinnerList.set(j2, spinner);
                        ++j2;
                    }
                }
            }
        });
        TButton saveButton = new TButton(TLanguage.getString("TUsersAdminDialog.SAVE_USER_BUTTON"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Vector<Object> limitName = new Vector();
                TLoadLimitation load_l = new TLoadLimitation();
                limitName = load_l.getLimitationsName();
                Vector<String> list = new Vector<String>();
                int i2 = 0;
                while (i2 < limitName.size()) {
                    if (!list.contains(limitName.get(i2))) {
                        list.add((String)limitName.get(i2));
                    }
                    ++i2;
                }
                TSaveUser save_u = new TSaveUser();
                String userName = (String)TUsersAdminDialog.this.saveCombo.getSelectedItem();
                if (userName != null && userName.compareTo("") != 0) {
                    TUser user = new TUser(userName);
                    int j2 = 0;
                    while (j2 < TUsersAdminDialog.this.spinnerList.size()) {
                        JSpinner spinner = (JSpinner)TUsersAdminDialog.this.spinnerList.elementAt(j2);
                        user.addAttribute(new TAttribute((String)list.get(j2), (String)list.get(j2), spinner.getValue()));
                        ++j2;
                    }
                    int ret = save_u.saveUser(user);
                    if (ret != -1) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TUsersAdminDialog.MESSAGE"), TLanguage.getString("INFO"), 1);
                    } else {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TUsersAdminDialog.ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
                    }
                    if (!TUsersAdminDialog.this.nameList.contains(userName)) {
                        TUsersAdminDialog.this.nameList.add(userName);
                        TUsersAdminDialog.this.saveCombo.updateUI();
                        TUsersAdminDialog.this.loadCombo.updateUI();
                    }
                    TUsersAdminDialog.this.saveCombo.setSelectedIndex(0);
                    TUsersAdminDialog.this.loadCombo.setSelectedIndex(0);
                }
            }
        });
        TButton deleteButton = new TButton(TLanguage.getString("TUsersAdminDialog.DELETE_USER_BUTTON"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String userName = (String)TUsersAdminDialog.this.loadCombo.getSelectedItem();
                if (userName != null && userName.compareTo("") != 0) {
                    Object[] options = new Object[]{TLanguage.getString("TUsersAdminDialog.ACCEPT_OPTION"), TLanguage.getString("TUsersAdminDialog.CANCEL_OPTION")};
                    int n2 = JOptionPane.showOptionDialog(null, TLanguage.getString("TUsersAdminDialog.DELETE_MESAGE"), TLanguage.getString("WARNING"), 1, 2, null, options, options[1]);
                    if (n2 == 0) {
                        TDeleteUser delete_u = new TDeleteUser();
                        int ret = delete_u.deleteUserByName(userName);
                        if (ret != -1) {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("TUsersAdminDialog.DELETE_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
                        } else {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("TUsersAdminDialog.DELETE_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
                        }
                        TUsersAdminDialog.this.nameList.remove(userName);
                        TUsersAdminDialog.this.saveCombo.updateUI();
                        TUsersAdminDialog.this.loadCombo.updateUI();
                        TUsersAdminDialog.this.saveCombo.setSelectedIndex(0);
                        TUsersAdminDialog.this.loadCombo.setSelectedIndex(0);
                    }
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        comboPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(10, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 0;
        comboPanel.add((Component)this.loadCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(10, 15, 1, 20);
        c2.gridx = 1;
        c2.gridy = 0;
        comboPanel.add((Component)this.saveCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        comboPanel.add((Component)loadButton, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 15, 1, 20);
        c2.gridx = 1;
        c2.gridy = 1;
        comboPanel.add((Component)saveButton, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 15, 10);
        c2.gridx = 0;
        c2.gridy = 2;
        comboPanel.add((Component)deleteButton, c2);
        return comboPanel;
    }

    private JPanel createButtonPanel(TEditor editor) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton closeButton = new TButton(TLanguage.getString("TUsersAdminDialog.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TUsersAdminDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }
}

