/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TComboBox;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.rules.TAttribute;
import tico.rules.TRule;
import tico.rules.database.TDeleteRule;
import tico.rules.database.TLoadParameter;
import tico.rules.database.TLoadRule;
import tico.rules.database.TSaveRule;
import tico.rules.database.TWriteLanguageFile;
import tico.rules.dialogs.TAddRuleDialog;

public class TRulesAdminDialog
extends TDialog
implements ActionListener {
    private static String RULES_FILE_PATH = "conf" + File.separator + "rules.xml";
    private static File RULES_FILE = new File(RULES_FILE_PATH);
    private static String DEFAULT_RULES_FILE_PATH = "conf" + File.separator + "default_rules.xml";
    private static File DEFAULT_RULES_FILE = new File(DEFAULT_RULES_FILE_PATH);
    private TComboBox selectCombo;
    private TComboBox functionCombo;
    private TComboBox attributeCombo;
    private TComboBox attributeCombo2;
    private TComboBox parameterCombo;
    private JTextField languageField;
    private JRadioButton projectRadio;
    private JRadioButton boardRadio;
    private JRadioButton cellRadio;
    private JRadioButton allRadio;
    private Vector<TAttribute> attributeList = new Vector();
    private Vector<TAttribute> parameterList = new Vector();
    private Vector<TRule> ruleList = new Vector();

    public TRulesAdminDialog(TEditor editor) {
        super(editor, TLanguage.getString("TRulesAdminDialog.TITLE"), true);
        this.createComponents(editor);
    }

    private void createComponents(TEditor editor) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TRulesAdminDialog.TAB"), this.createEntryPanel(editor));
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(editor), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private JPanel createEntryPanel(TEditor editor) {
        JPanel entryPanel = new JPanel();
        entryPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TRulesAdminDialog.TEXT_TITLE")));
        this.getRuleElements();
        this.createSelectCombo();
        this.createFunctionCombo();
        this.createAttributeCombo();
        this.createParameterCombo();
        this.createRadioButtons();
        GridBagConstraints c2 = new GridBagConstraints();
        entryPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 0;
        entryPanel.add((Component)this.createRulePanel(), c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 1;
        entryPanel.add((Component)this.createRuleButtonPanel(editor), c2);
        return entryPanel;
    }

    private void getRuleElements() {
        TLoadRule rules = new TLoadRule();
        this.ruleList = rules.loadAllRules();
    }

    private void createSelectCombo() {
        this.selectCombo = new TComboBox();
        this.selectCombo.addItem("");
        int i2 = 0;
        while (i2 < this.ruleList.size()) {
            String[] fun;
            if (this.ruleList.get(i2).getFunctionXML().compareTo("lightness") != 0) {
                fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
            } else {
                fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + ", " + this.ruleList.get(i2).getAttribute2().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
            }
            ++i2;
        }
        this.selectCombo.setMinimumSize(new Dimension(460, 25));
        this.selectCombo.setPreferredSize(new Dimension(460, 25));
        this.selectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TRulesAdminDialog.this.selectCombo.getSelectedItem() != null && ((String)TRulesAdminDialog.this.selectCombo.getSelectedItem()).compareTo("") != 0) {
                    String[] name = ((String)TRulesAdminDialog.this.selectCombo.getSelectedItem()).split(": ");
                    String ruleName = name[0];
                    int i2 = 0;
                    while (i2 < TRulesAdminDialog.this.ruleList.size()) {
                        if (ruleName.compareTo(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getName()) == 0) {
                            if (((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getType().compareTo("interpreter") != 0) {
                                TRulesAdminDialog.this.functionCombo.setSelectedItem(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getFunction());
                                TRulesAdminDialog.this.attributeCombo.setSelectedItem(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getAttribute().getName());
                                TRulesAdminDialog.this.parameterCombo.setSelectedItem(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getParameter().getName());
                                TRulesAdminDialog.this.languageField.setText(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getMessage());
                                if (((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getAttribute2() != null) {
                                    TRulesAdminDialog.this.attributeCombo2.setSelectedItem(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getAttribute2().getName());
                                }
                                TRulesAdminDialog.this.functionCombo.setEnabled(true);
                                TRulesAdminDialog.this.attributeCombo.setEnabled(true);
                                TRulesAdminDialog.this.parameterCombo.setEnabled(true);
                                TRulesAdminDialog.this.languageField.setEnabled(true);
                            } else {
                                TRulesAdminDialog.this.functionCombo.setEnabled(false);
                                TRulesAdminDialog.this.attributeCombo.setEnabled(false);
                                TRulesAdminDialog.this.parameterCombo.setEnabled(false);
                                TRulesAdminDialog.this.languageField.setEnabled(false);
                            }
                        }
                        ++i2;
                    }
                }
            }
        });
        this.selectCombo.setSelectedIndex(0);
    }

    private void createFunctionCombo() {
        Vector<String> funNames = new Vector<String>();
        int i2 = 0;
        while (i2 < this.ruleList.size()) {
            if (!funNames.contains(this.ruleList.get(i2).getFunction())) {
                funNames.add(this.ruleList.get(i2).getFunction());
            }
            ++i2;
        }
        this.functionCombo = new TComboBox();
        this.functionCombo.addItem("");
        i2 = 0;
        while (i2 < funNames.size()) {
            this.functionCombo.addItem(funNames.get(i2));
            ++i2;
        }
        this.functionCombo.setSelectedIndex(0);
        this.functionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Vector<String> auxAttrib = new Vector<String>();
                Vector<String> auxParam = new Vector<String>();
                JComboBox cb = (JComboBox)e2.getSource();
                String funName = (String)cb.getSelectedItem();
                String funNameXML = null;
                if (funName != null && funName.compareTo("") != 0) {
                    int i2 = 0;
                    while (i2 < TRulesAdminDialog.this.ruleList.size()) {
                        if (funName.compareTo(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getFunction()) == 0) {
                            funNameXML = ((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getFunctionXML();
                        }
                        ++i2;
                    }
                    TRulesAdminDialog.this.parameterCombo.removeAllItems();
                    TRulesAdminDialog.this.attributeCombo.removeAllItems();
                    if (funNameXML.compareTo("exist") == 0 || funNameXML.compareTo("type") == 0) {
                        i2 = 0;
                        while (i2 < TRulesAdminDialog.this.parameterList.size()) {
                            if (((TAttribute)TRulesAdminDialog.this.parameterList.get(i2)).getValue().getClass() == new Boolean(true).getClass()) {
                                auxParam.add(((TAttribute)TRulesAdminDialog.this.parameterList.get(i2)).getName());
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < TRulesAdminDialog.this.attributeList.size()) {
                            if (((TAttribute)TRulesAdminDialog.this.attributeList.get(i2)).getValue().getClass() == new Boolean(true).getClass()) {
                                auxAttrib.add(((TAttribute)TRulesAdminDialog.this.attributeList.get(i2)).getName());
                            }
                            ++i2;
                        }
                    } else {
                        i2 = 0;
                        while (i2 < TRulesAdminDialog.this.parameterList.size()) {
                            if (((TAttribute)TRulesAdminDialog.this.parameterList.get(i2)).getValue().getClass() == new Integer(0).getClass()) {
                                auxParam.add(((TAttribute)TRulesAdminDialog.this.parameterList.get(i2)).getName());
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < TRulesAdminDialog.this.attributeList.size()) {
                            if (((TAttribute)TRulesAdminDialog.this.attributeList.get(i2)).getValue().getClass() == new Integer(0).getClass()) {
                                auxAttrib.add(((TAttribute)TRulesAdminDialog.this.attributeList.get(i2)).getName());
                            }
                            ++i2;
                        }
                    }
                    TRulesAdminDialog.this.parameterCombo.addItem("");
                    i2 = 0;
                    while (i2 < auxParam.size()) {
                        TRulesAdminDialog.this.parameterCombo.addItem(auxParam.get(i2));
                        ++i2;
                    }
                    TRulesAdminDialog.this.attributeCombo.addItem("");
                    i2 = 0;
                    while (i2 < auxAttrib.size()) {
                        TRulesAdminDialog.this.attributeCombo.addItem(auxAttrib.get(i2));
                        ++i2;
                    }
                    if (funNameXML.compareTo("lightness") == 0) {
                        TRulesAdminDialog.this.attributeCombo2.removeAllItems();
                        TRulesAdminDialog.this.attributeCombo2.setEnabled(true);
                        TRulesAdminDialog.this.attributeCombo2.addItem("");
                        i2 = 0;
                        while (i2 < auxAttrib.size()) {
                            TRulesAdminDialog.this.attributeCombo2.addItem(auxAttrib.get(i2));
                            ++i2;
                        }
                    } else {
                        TRulesAdminDialog.this.attributeCombo2.setEnabled(false);
                    }
                }
            }
        });
    }

    private void createAttributeCombo() {
        this.attributeCombo = new TComboBox();
        this.attributeCombo.addItem("");
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.PROJECTNUMBOARDS"), "projectNumBoards", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDHEIGHT"), "boardHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDWIDTH"), "boardWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDNOIMAGE"), "boardNoImage", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDSOUND"), "boardSound", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDLIGHTNESS"), "boardLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLHEIGHT"), "cellHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLWIDTH"), "cellWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLLIGHTNESS"), "cellLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXT"), "cellText", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSIZE"), "cellTextSize", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTTYPE"), "cellTextType", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTFONT"), "cellTextFont", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSTYLE"), "cellTextStyle", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTLIGHTNESS"), "cellTextLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOIMAGE"), "cellNoImage", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEHEIGHT"), "cellImageHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEWIDTH"), "cellImageWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLSOUND"), "cellSound", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERWIDTH"), "cellBorderWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERLIGHTNESS"), "cellBorderLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLROW"), "cellRow", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLCOLUMN"), "cellColumn", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOALTERNATIVEICON"), "cellNoAlternativeIcon", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONHEIGHT"), "cellIconHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONWIDTH"), "cellIconWidth", new Integer(0)));
        int i2 = 0;
        while (i2 < this.attributeList.size()) {
            this.attributeCombo.addItem(this.attributeList.get(i2).getName());
            ++i2;
        }
        this.attributeCombo.setSelectedIndex(0);
        this.attributeCombo2 = new TComboBox();
        this.attributeCombo2.setEnabled(false);
    }

    private void createParameterCombo() {
        this.parameterList.removeAllElements();
        TLoadParameter params = new TLoadParameter();
        this.parameterList = params.loadAllParameters();
        this.parameterCombo = new TComboBox();
        this.parameterCombo.addItem("");
        int i2 = 0;
        while (i2 < this.parameterList.size()) {
            this.parameterCombo.addItem(this.parameterList.get(i2).getName());
            ++i2;
        }
        this.parameterCombo.setSelectedIndex(0);
    }

    private void createRadioButtons() {
        this.projectRadio = new JRadioButton(TLanguage.getString("TRulesAdminDialog.PROJECT"));
        this.projectRadio.setActionCommand("project");
        this.boardRadio = new JRadioButton(TLanguage.getString("TRulesAdminDialog.BOARD"));
        this.boardRadio.setActionCommand("board");
        this.cellRadio = new JRadioButton(TLanguage.getString("TRulesAdminDialog.CELL"));
        this.cellRadio.setActionCommand("cell");
        this.allRadio = new JRadioButton(TLanguage.getString("TRulesAdminDialog.ALL"));
        this.allRadio.setActionCommand("all");
        ButtonGroup group = new ButtonGroup();
        group.add(this.projectRadio);
        group.add(this.boardRadio);
        group.add(this.cellRadio);
        group.add(this.allRadio);
        this.projectRadio.addActionListener(this);
        this.boardRadio.addActionListener(this);
        this.cellRadio.addActionListener(this);
        this.allRadio.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.selectCombo.removeAllItems();
        this.selectCombo.addItem("");
        if (e2.getActionCommand().compareTo("all") == 0) {
            int i2 = 0;
            while (i2 < this.ruleList.size()) {
                String[] fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.ruleList.size()) {
                if (this.ruleList.get(i3).getType().compareTo(e2.getActionCommand()) == 0) {
                    String[] fun = this.ruleList.get(i3).getFunction().split("'");
                    this.selectCombo.addItem(String.valueOf(this.ruleList.get(i3).getName()) + ": " + this.ruleList.get(i3).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i3).getParameter().getName());
                }
                ++i3;
            }
        }
    }

    private void updateCombo() {
        this.getRuleElements();
        this.selectCombo.removeAllItems();
        this.selectCombo.addItem("");
        if (this.allRadio.getActionCommand().compareTo("all") == 0) {
            int i2 = 0;
            while (i2 < this.ruleList.size()) {
                String[] fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.ruleList.size()) {
                String type = this.projectRadio.getActionCommand().compareTo("project") == 0 ? "project" : (this.boardRadio.getActionCommand().compareTo("board") == 0 ? "board" : (this.cellRadio.getActionCommand().compareTo("cell") == 0 ? "cell" : "all"));
                if (this.ruleList.get(i3).getType().compareTo(type) == 0) {
                    String[] fun = this.ruleList.get(i3).getFunction().split("'");
                    this.selectCombo.addItem(String.valueOf(this.ruleList.get(i3).getName()) + ": " + this.ruleList.get(i3).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i3).getParameter().getName());
                }
                ++i3;
            }
        }
    }

    private JPanel createRulePanel() {
        JPanel rulePanel = new JPanel();
        JLabel selectLabel = new JLabel(TLanguage.getString("TRulesAdminDialog.SELECT"));
        JLabel functionLabel = new JLabel(TLanguage.getString("TRulesAdminDialog.FUNCTION"));
        JLabel attributeLabel = new JLabel(TLanguage.getString("TRulesAdminDialog.ATTRIBUTE"));
        JLabel parameterLabel = new JLabel(TLanguage.getString("TRulesAdminDialog.PARAMETER"));
        JLabel languageLabel = new JLabel(String.valueOf(TLanguage.getString("TRulesAdminDialog.LANGUAGE")) + TSetup.getLanguage().toLowerCase());
        JLabel infoLabel = new JLabel(TLanguage.getString("TRulesAdminDialog.INFOLABEL"));
        this.languageField = new JTextField(80);
        this.languageField.setColumns(20);
        GridBagConstraints c2 = new GridBagConstraints();
        rulePanel.setLayout(new GridBagLayout());
        selectLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 0;
        rulePanel.add((Component)selectLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        rulePanel.add((Component)this.selectCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 2;
        rulePanel.add((Component)this.projectRadio, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 3;
        rulePanel.add((Component)this.boardRadio, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 4;
        rulePanel.add((Component)this.cellRadio, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 5;
        rulePanel.add((Component)this.allRadio, c2);
        functionLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 0;
        rulePanel.add((Component)functionLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 1;
        rulePanel.add((Component)this.functionCombo, c2);
        attributeLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 2;
        rulePanel.add((Component)attributeLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 3;
        rulePanel.add((Component)this.attributeCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 4;
        rulePanel.add((Component)this.attributeCombo2, c2);
        parameterLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 5;
        rulePanel.add((Component)parameterLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 6;
        rulePanel.add((Component)this.parameterCombo, c2);
        languageLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 7;
        rulePanel.add((Component)languageLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 8;
        rulePanel.add((Component)this.languageField, c2);
        infoLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 9;
        rulePanel.add((Component)infoLabel, c2);
        return rulePanel;
    }

    private JPanel createRuleButtonPanel(final TEditor editor) {
        JPanel ruleButtonPanel = new JPanel();
        ruleButtonPanel.setLayout(new FlowLayout());
        TButton removeButton = new TButton(TLanguage.getString("TRulesAdminDialog.REMOVE_BUTTON"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String[] name = ((String)TRulesAdminDialog.this.selectCombo.getSelectedItem()).split(": ");
                if (name[0] != null && name[0].compareTo("") != 0) {
                    String ruleName = null;
                    int i2 = 0;
                    while (i2 < TRulesAdminDialog.this.ruleList.size()) {
                        if (name[0].compareTo(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getName()) == 0) {
                            ruleName = ((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getNameXML();
                        }
                        ++i2;
                    }
                    Object[] options = new Object[]{TLanguage.getString("TRulesAdminDialog.ACCEPT_OPTION"), TLanguage.getString("TRulesAdminDialog.CANCEL_OPTION")};
                    int n2 = JOptionPane.showOptionDialog(null, TLanguage.getString("TRulesAdminDialog.DELETE_MESAGE"), TLanguage.getString("WARNING"), 1, 2, null, options, options[1]);
                    if (n2 == 0) {
                        TDeleteRule delRule = new TDeleteRule();
                        int ret = delRule.deleteRuleByName(ruleName.toUpperCase());
                        if (ret != -1) {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.DELETE_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
                        } else {
                            JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.DELETE_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
                        }
                        TRulesAdminDialog.this.updateCombo();
                        TRulesAdminDialog.this.selectCombo.setSelectedIndex(0);
                        TRulesAdminDialog.this.functionCombo.setSelectedIndex(0);
                        TRulesAdminDialog.this.attributeCombo.setSelectedIndex(0);
                        TRulesAdminDialog.this.parameterCombo.setSelectedIndex(0);
                        TRulesAdminDialog.this.languageField.setText("");
                    }
                }
            }
        });
        ruleButtonPanel.add(removeButton);
        TButton editButton = new TButton(TLanguage.getString("TRulesAdminDialog.EDIT_BUTTON"));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String[] name = ((String)TRulesAdminDialog.this.selectCombo.getSelectedItem()).split(": ");
                if (name[0] != null && name[0].compareTo("") != 0) {
                    TRule rule = new TRule();
                    int i2 = 0;
                    while (i2 < TRulesAdminDialog.this.ruleList.size()) {
                        if (name[0].compareTo(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getName()) == 0) {
                            rule.setNameXML(((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getNameXML());
                            if (((TRule)TRulesAdminDialog.this.ruleList.get(i2)).getType().compareTo("interpreter") != 0) {
                                TRulesAdminDialog.this.saveRule(rule);
                            }
                        }
                        ++i2;
                    }
                    TRulesAdminDialog.this.updateCombo();
                }
            }
        });
        ruleButtonPanel.add(editButton);
        TButton addButton = new TButton(TLanguage.getString("TRulesAdminDialog.ADD_BUTTON"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                new TAddRuleDialog(editor);
                TRulesAdminDialog.this.updateRules();
            }
        });
        ruleButtonPanel.add(addButton);
        TButton loadButton = new TButton(TLanguage.getString("TRulesAdminDialog.LOAD_BUTTON"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Object[] options = new Object[]{TLanguage.getString("TRulesAdminDialog.ACCEPT_OPTION"), TLanguage.getString("TRulesAdminDialog.CANCEL_OPTION")};
                int n2 = JOptionPane.showOptionDialog(null, TLanguage.getString("TRulesAdminDialog.LOAD_RULES_MESSAGE"), TLanguage.getString("WARNING"), 1, 2, null, options, options[1]);
                if (n2 == 0) {
                    try {
                        TRulesAdminDialog.this.copy(DEFAULT_RULES_FILE, RULES_FILE);
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.LOAD_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.LOAD_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
                        e1.printStackTrace();
                    }
                    TRulesAdminDialog.this.updateRules();
                }
            }
        });
        ruleButtonPanel.add(loadButton);
        return ruleButtonPanel;
    }

    private JPanel createButtonPanel(TEditor editor) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton closeButton = new TButton(TLanguage.getString("TRulesAdminDialog.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TRulesAdminDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private void saveRule(TRule rule) {
        String param;
        int i2;
        if (this.functionCombo.getSelectedIndex() != 0) {
            int i3 = 0;
            while (i3 < this.ruleList.size()) {
                if (((String)this.functionCombo.getSelectedItem()).compareTo(this.ruleList.get(i3).getFunction()) == 0) {
                    rule.setFunctionXML(this.ruleList.get(i3).getFunctionXML());
                }
                ++i3;
            }
        } else {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_FUN"), TLanguage.getString("WARNING"), 2);
        }
        String atr = (String)this.attributeCombo.getSelectedItem();
        if (atr == null || atr.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ATR"), TLanguage.getString("WARNING"), 2);
        } else {
            int i4 = 0;
            while (i4 < this.attributeList.size()) {
                if (this.attributeList.get(i4).getName().compareTo(atr) == 0) {
                    rule.setAttribute(new TAttribute(null, this.attributeList.get(i4).getNameXML()));
                }
                ++i4;
            }
        }
        if (rule.getFunctionXML().compareTo("lightness") == 0) {
            String atr2 = (String)this.attributeCombo2.getSelectedItem();
            if (atr2 == null || atr2.compareTo("") == 0) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ATR"), TLanguage.getString("WARNING"), 2);
            } else {
                i2 = 0;
                while (i2 < this.attributeList.size()) {
                    if (this.attributeList.get(i2).getName().compareTo(atr2) == 0) {
                        rule.setAttribute2(new TAttribute(null, this.attributeList.get(i2).getNameXML()));
                    }
                    ++i2;
                }
            }
        }
        if ((param = (String)this.parameterCombo.getSelectedItem()) == null || param.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_PAR"), TLanguage.getString("WARNING"), 2);
        } else {
            i2 = 0;
            while (i2 < this.parameterList.size()) {
                if (this.parameterList.get(i2).getName().compareTo(param) == 0) {
                    rule.setParameter(new TAttribute(null, this.parameterList.get(i2).getNameXML()));
                }
                ++i2;
            }
        }
        if (this.languageField.getText().compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ES"), TLanguage.getString("WARNING"), 2);
        } else {
            TSaveRule save_r;
            int ret;
            String str;
            String[] s2 = rule.getNameXML().split("_");
            rule.setMessage(this.languageField.getText());
            rule.setMessageXML("MESSAGE_" + s2[1]);
            if (TLanguage.getString("TShowResults." + rule.getMessageXML()).compareTo(this.languageField.getText()) != 0) {
                new TWriteLanguageFile(rule.getMessage(), rule.getMessageXML());
            }
            if ((str = rule.getAttribute().getNameXML()).contains("project")) {
                rule.setType("project");
            }
            if (str.contains("board")) {
                rule.setType("board");
            }
            if (str.contains("cell")) {
                rule.setType("cell");
            }
            if ((ret = (save_r = new TSaveRule()).saveRule(rule)) != -1) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.EDIT_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
            } else {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TRulesAdminDialog.EDIT_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
            }
        }
    }

    private void updateRules() {
        this.ruleList.removeAllElements();
        this.getRuleElements();
        this.selectCombo.removeAllItems();
        this.selectCombo.addItem("");
        int i2 = 0;
        while (i2 < this.ruleList.size()) {
            String[] fun;
            if (this.ruleList.get(i2).getFunctionXML().compareTo("lightness") != 0) {
                fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
            } else {
                fun = this.ruleList.get(i2).getFunction().split("'");
                this.selectCombo.addItem(String.valueOf(this.ruleList.get(i2).getName()) + ": " + this.ruleList.get(i2).getAttribute().getName() + ", " + this.ruleList.get(i2).getAttribute2().getName() + " " + fun[1] + " " + this.ruleList.get(i2).getParameter().getName());
            }
            ++i2;
        }
    }

    void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

