/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import tico.components.TButton;
import tico.components.TComboBox;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.rules.TAttribute;
import tico.rules.TLimitation;
import tico.rules.database.TDeleteLimitation;
import tico.rules.database.TLoadLimitation;

public class TLimitationsAdminDialog
extends TDialog
implements ActionListener {
    private static int MAX_LIMITATIONS = 8;
    private static String PARAMS_FILE_PATH = "conf" + File.separator + "params_resolution.xml";
    private static File PARAMS_FILE = new File(PARAMS_FILE_PATH);
    private static String DEFAULT_PARAMS_FILE_PATH = "conf" + File.separator + "default_params_resolution.xml";
    private static File DEFAULT_PARAMS_FILE = new File(DEFAULT_PARAMS_FILE_PATH);
    private TComboBox limitCombo;
    private TComboBox limitEditCombo;
    private TComboBox paramEditCombo;
    private JTable table;
    private int maxRow;
    private String type = "int";
    private Vector<TLimitation> limitationList = new Vector();

    public TLimitationsAdminDialog(TEditor editor) {
        super(editor, TLanguage.getString("TLimitationsAdminDialog.TITLE"), true);
        this.createComponents(editor);
    }

    private void createComponents(TEditor editor) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TLimitationsAdminDialog.TAB"), this.createEntryPanel(editor));
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(editor), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private JPanel createEntryPanel(TEditor editor) {
        JPanel entryPanel = new JPanel();
        this.createCombos();
        GridBagConstraints c2 = new GridBagConstraints();
        entryPanel.setLayout(new GridBagLayout());
        c2.fill = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        entryPanel.add((Component)this.createLimitationPanel(), c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 1, 15);
        c2.gridx = 0;
        c2.gridy = 1;
        entryPanel.add((Component)this.createParameterPanel(), c2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 1, 15);
        c2.gridx = 0;
        c2.gridy = 2;
        entryPanel.add((Component)this.createTablePanel(), c2);
        return entryPanel;
    }

    private void createCombos() {
        this.limitationList.removeAllElements();
        TLoadLimitation limits = new TLoadLimitation();
        this.limitationList = limits.loadAllLimitations();
        this.limitCombo = new TComboBox();
        this.limitEditCombo = new TComboBox();
        int i2 = 0;
        while (i2 < this.limitationList.size()) {
            this.limitCombo.addItem(this.limitationList.elementAt(i2).getName());
            this.limitEditCombo.addItem(this.limitationList.elementAt(i2).getName());
            ++i2;
        }
        this.limitCombo.setSelectedIndex(0);
        this.limitCombo.addActionListener(this);
        this.limitCombo.setMinimumSize(new Dimension(100, 25));
        this.limitCombo.setPreferredSize(new Dimension(100, 25));
        this.limitEditCombo.setEditable(true);
        this.limitEditCombo.setSelectedIndex(0);
        this.limitEditCombo.setMinimumSize(new Dimension(100, 25));
        this.limitEditCombo.setPreferredSize(new Dimension(100, 25));
        this.paramEditCombo = new TComboBox();
        this.paramEditCombo.setEditable(true);
    }

    private JPanel createLimitationPanel() {
        JPanel limitationPanel = new JPanel();
        JLabel labelLimit = new JLabel(TLanguage.getString("TLimitationsAdminDialog.LABEL_LIMT"));
        TButton deleteLimitButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.DELETE_LIMIT"));
        deleteLimitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String lim = (String)TLimitationsAdminDialog.this.limitEditCombo.getSelectedItem();
                if (lim.compareTo("") != 0) {
                    Object[] options = new Object[]{TLanguage.getString("TLimitationsAdminDialog.ACCEPT_OPTION"), TLanguage.getString("TLimitationsAdminDialog.CANCEL_OPTION")};
                    int n2 = JOptionPane.showOptionDialog(null, TLanguage.getString("TLimitationsAdminDialog.DELETE_LIM_MESAGE"), TLanguage.getString("WARNING"), 1, 2, null, options, options[1]);
                    if (n2 == 0) {
                        int index = TLimitationsAdminDialog.this.limitEditCombo.getSelectedIndex();
                        TLimitationsAdminDialog.this.removeLimitation(lim);
                        int i2 = 0;
                        while (i2 < TLimitationsAdminDialog.this.limitationList.size()) {
                            if (lim.compareTo(((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getName()) == 0) {
                                TLimitationsAdminDialog.this.limitationList.remove(i2);
                            }
                            ++i2;
                        }
                        TLimitationsAdminDialog.this.limitCombo.removeItemAt(index);
                        TLimitationsAdminDialog.this.limitCombo.setSelectedIndex(0);
                        TLimitationsAdminDialog.this.limitEditCombo.removeItemAt(index);
                        TLimitationsAdminDialog.this.limitEditCombo.setSelectedIndex(0);
                    }
                }
            }
        });
        TButton addLimitButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.ADD_LIMIT"));
        addLimitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TLimitationsAdminDialog.this.limitEditCombo.getItemCount() - 1 < MAX_LIMITATIONS) {
                    Boolean exist = false;
                    String lim = (String)TLimitationsAdminDialog.this.limitEditCombo.getSelectedItem();
                    int i2 = 0;
                    while (i2 < TLimitationsAdminDialog.this.limitationList.size()) {
                        if (lim.compareTo(((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getName()) == 0) {
                            exist = true;
                        }
                        ++i2;
                    }
                    if (!exist.booleanValue()) {
                        TLimitationsAdminDialog.this.limitationList.add(new TLimitation(lim, lim));
                        TLimitationsAdminDialog.this.limitCombo.addItem(lim);
                        TLimitationsAdminDialog.this.limitEditCombo.addItem(lim);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.MAX_LIMIT"), TLanguage.getString("ERROR"), 0);
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        limitationPanel.setLayout(new GridBagLayout());
        limitationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TLimitationsAdminDialog.TEXT_LIMIT")));
        labelLimit.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 1, 15);
        c2.gridx = 0;
        c2.gridy = 0;
        limitationPanel.add((Component)labelLimit, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 1;
        limitationPanel.add((Component)this.limitEditCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 1;
        limitationPanel.add((Component)addLimitButton, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 2;
        c2.gridy = 1;
        limitationPanel.add((Component)deleteLimitButton, c2);
        return limitationPanel;
    }

    private JPanel createParameterPanel() {
        JPanel attributePanel = new JPanel();
        JLabel labelLimit = new JLabel(TLanguage.getString("TLimitationsAdminDialog.LABEL_LIMT"));
        JLabel labelAttrib = new JLabel(TLanguage.getString("TLimitationsAdminDialog.LABEL_PARAM"));
        JRadioButton intRadio = new JRadioButton(TLanguage.getString("TLimitationsAdminDialog.INT"));
        intRadio.setActionCommand("int");
        intRadio.setSelected(true);
        JRadioButton boolRadio = new JRadioButton(TLanguage.getString("TLimitationsAdminDialog.BOOL"));
        boolRadio.setActionCommand("bool");
        ButtonGroup group = new ButtonGroup();
        group.add(intRadio);
        group.add(boolRadio);
        intRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TLimitationsAdminDialog.this.type = e2.getActionCommand();
            }
        });
        boolRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TLimitationsAdminDialog.this.type = e2.getActionCommand();
            }
        });
        TButton deleteAttribButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.DELETE_PARAM"));
        deleteAttribButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String limit = (String)TLimitationsAdminDialog.this.paramEditCombo.getSelectedItem();
                if (limit != null && limit.compareTo("") != 0) {
                    Object[] options = new Object[]{TLanguage.getString("TLimitationsAdminDialog.ACCEPT_OPTION"), TLanguage.getString("TLimitationsAdminDialog.CANCEL_OPTION")};
                    int n2 = JOptionPane.showOptionDialog(null, TLanguage.getString("TLimitationsAdminDialog.DELETE_PARAM_MESAGE"), TLanguage.getString("WARNING"), 1, 2, null, options, options[1]);
                    if (n2 == 0) {
                        String lim = (String)TLimitationsAdminDialog.this.limitCombo.getSelectedItem();
                        String atr = (String)TLimitationsAdminDialog.this.paramEditCombo.getSelectedItem();
                        TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                        model.removeColumn(lim, atr);
                        TLimitationsAdminDialog.this.paramEditCombo.removeItemAt(TLimitationsAdminDialog.this.paramEditCombo.getSelectedIndex());
                    }
                }
            }
        });
        TButton addParamButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.ADD_PARAM"));
        addParamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String lim = (String)TLimitationsAdminDialog.this.limitCombo.getSelectedItem();
                if (lim != null && lim.compareTo("") != 0) {
                    String atr = (String)TLimitationsAdminDialog.this.paramEditCombo.getSelectedItem();
                    TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                    model.addColumn(lim, atr);
                    TLimitationsAdminDialog.this.paramEditCombo.addItem(atr);
                }
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        attributePanel.setLayout(new GridBagLayout());
        attributePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TLimitationsAdminDialog.TEXT_PARAM")));
        labelLimit.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 1, 15);
        c2.gridx = 0;
        c2.gridy = 0;
        attributePanel.add((Component)labelLimit, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 1;
        attributePanel.add((Component)this.limitCombo, c2);
        labelAttrib.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 1, 15);
        c2.gridx = 1;
        c2.gridy = 0;
        attributePanel.add((Component)labelAttrib, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 1;
        attributePanel.add((Component)this.paramEditCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 2;
        c2.gridy = 1;
        attributePanel.add((Component)addParamButton, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 3;
        c2.gridy = 1;
        attributePanel.add((Component)deleteAttribButton, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 2;
        attributePanel.add((Component)intRadio, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 3;
        attributePanel.add((Component)boolRadio, c2);
        return attributePanel;
    }

    private JPanel createButtonPanel(TEditor editor) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton closeButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TLimitationsAdminDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private JPanel createTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 3));
        tablePanel.setOpaque(true);
        tablePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TLimitationsAdminDialog.TEXT_TABLE")));
        tablePanel.setMinimumSize(new Dimension(200, 250));
        tablePanel.setPreferredSize(new Dimension(200, 250));
        this.table = new JTable(new TTableModel());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 250));
        this.table.setAutoResizeMode(0);
        this.table.doLayout();
        JScrollPane scrollPane = new JScrollPane(this.table);
        TButton deleteRowButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.DELETE_ROW"));
        deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                if (model.getRowCount() > 0) {
                    model.removeRow(TLimitationsAdminDialog.this.table.getSelectedRow());
                }
            }
        });
        TButton addRowButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.ADD_ROW"));
        addRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                if (model.getRowCount() > 0) {
                    model.addRow();
                }
            }
        });
        JPanel tableButtonPanel = new JPanel();
        tableButtonPanel.setLayout(new FlowLayout());
        tableButtonPanel.add(addRowButton);
        tableButtonPanel.add(deleteRowButton);
        tablePanel.add(tableButtonPanel);
        tablePanel.add(scrollPane);
        TButton saveButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.SAVE_BUTTON"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                int ret = model.saveTable(TLimitationsAdminDialog.this.table);
                if (ret != -1) {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.MESSAGE"), TLanguage.getString("INFO"), 1);
                } else {
                    JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
                }
            }
        });
        TButton loadButton = new TButton(TLanguage.getString("TLimitationsAdminDialog.LOAD_BUTTON"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String name = (String)TLimitationsAdminDialog.this.limitCombo.getSelectedItem();
                TTableModel model = (TTableModel)TLimitationsAdminDialog.this.table.getModel();
                model.updateTable(name, "default");
                TLimitationsAdminDialog.this.computeColumnWidths();
                TLimitationsAdminDialog.this.paramEditCombo.removeAllItems();
                TLimitationsAdminDialog.this.paramEditCombo.addItem("");
                int i2 = 1;
                while (i2 < model.columnNames.size()) {
                    TLimitationsAdminDialog.this.paramEditCombo.addItem(model.columnNames.get(i2));
                    ++i2;
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(saveButton);
        buttonPanel.add(loadButton);
        tablePanel.add(buttonPanel);
        return tablePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        TComboBox cb = (TComboBox)e2.getSource();
        String limitName = (String)cb.getSelectedItem();
        TTableModel model = (TTableModel)this.table.getModel();
        model.updateTable(limitName, null);
        this.computeColumnWidths();
        this.paramEditCombo.removeAllItems();
        this.paramEditCombo.addItem("");
        int i2 = 1;
        while (i2 < model.columnNames.size()) {
            this.paramEditCombo.addItem(model.columnNames.get(i2));
            ++i2;
        }
    }

    private void removeLimitation(String limit) {
        String limitName = null;
        int i2 = 0;
        while (i2 < this.limitationList.size()) {
            if (limit.compareTo(this.limitationList.get(i2).getName()) == 0) {
                limitName = this.limitationList.get(i2).getNameXML();
            }
            ++i2;
        }
        if (limitName != null) {
            TDeleteLimitation delLimit = new TDeleteLimitation();
            int ret = delLimit.deleteLimitationByName(limitName);
            if (ret != -1) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.DELETE_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
            } else {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.DELETE_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
            }
        }
    }

    private void computeColumnWidths() {
        int hspace = 6;
        TTableModel model = (TTableModel)this.table.getModel();
        int cols = model.getColumnCount();
        int rows = model.getRowCount();
        int[] w2 = new int[model.getColumnCount()];
        int i2 = 0;
        while (i2 < cols) {
            w2[i2] = (int)this.table.getDefaultRenderer(String.class).getTableCellRendererComponent(this.table, this.table.getColumnName(i2), false, false, -1, i2).getPreferredSize().getWidth() + hspace;
            ++i2;
        }
        i2 = 0;
        while (i2 < rows) {
            int j2 = 0;
            while (j2 < cols) {
                Object o2 = model.getValueAt(i2, j2);
                int width = 0;
                if (o2 != null) {
                    width = (int)this.table.getCellRenderer(i2, j2).getTableCellRendererComponent(this.table, o2, false, false, i2, j2).getPreferredSize().getWidth() + hspace;
                }
                if (w2[j2] < width) {
                    w2[j2] = width;
                }
                ++j2;
            }
            ++i2;
        }
        TableColumnModel colModel = this.table.getColumnModel();
        int i3 = 0;
        while (i3 < cols) {
            colModel.getColumn(i3).setPreferredWidth(w2[i3]);
            ++i3;
        }
    }

    class ColorColumnRenderer
    extends DefaultTableCellRenderer {
        Color bkgndColor;
        Color fgndColor;

        public ColorColumnRenderer(Color bkgnd, Color foregnd) {
            this.bkgndColor = bkgnd;
            this.fgndColor = foregnd;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setBackground(this.bkgndColor);
            cell.setForeground(this.fgndColor);
            return cell;
        }
    }

    class TTableModel
    extends AbstractTableModel {
        private Vector<String> columnNames = new Vector();
        private Vector<String> columnNamesXML = new Vector();
        private Object[][] data = new Object[100][100];
        public Object[] longValues;

        TTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return TLimitationsAdminDialog.this.maxRow + 1;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.elementAt(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c2) {
            try {
                return this.getValueAt(0, c2).getClass();
            }
            catch (Exception e2) {
                if (TLimitationsAdminDialog.this.type.compareTo("int") == 0) {
                    return Integer.class.getClass();
                }
                return Boolean.class.getClass();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.DELETE_MESSAGE"), TLanguage.getString("WARNING"), 2);
            } else {
                this.data[row][col] = value;
            }
            if (row > TLimitationsAdminDialog.this.maxRow) {
                TLimitationsAdminDialog.this.maxRow = row;
            }
            int i2 = 0;
            while (i2 <= TLimitationsAdminDialog.this.maxRow) {
                this.data[i2][0] = i2;
                ++i2;
            }
            this.fireTableStructureChanged();
            TLimitationsAdminDialog.this.computeColumnWidths();
            TableColumn column = TLimitationsAdminDialog.this.table.getColumnModel().getColumn(0);
            column.setCellRenderer(new ColorColumnRenderer(Color.LIGHT_GRAY, Color.BLACK));
        }

        public void removeRow(int row) {
            if (TLimitationsAdminDialog.this.table.getSelectedRow() >= 0) {
                this.fireTableRowsDeleted(row, row);
                int i2 = row;
                while (i2 < this.getRowCount()) {
                    int j2 = 0;
                    while (j2 < this.getColumnCount()) {
                        this.data[i2][j2] = this.data[i2 + 1][j2];
                        ++j2;
                    }
                    ++i2;
                }
                TLimitationsAdminDialog tLimitationsAdminDialog = TLimitationsAdminDialog.this;
                tLimitationsAdminDialog.maxRow = tLimitationsAdminDialog.maxRow - 1;
                i2 = 0;
                while (i2 <= TLimitationsAdminDialog.this.maxRow) {
                    this.data[i2][0] = i2;
                    ++i2;
                }
            }
        }

        public void addRow() {
            TLimitationsAdminDialog tLimitationsAdminDialog = TLimitationsAdminDialog.this;
            tLimitationsAdminDialog.maxRow = tLimitationsAdminDialog.maxRow + 1;
            this.fireTableRowsInserted(TLimitationsAdminDialog.this.maxRow, TLimitationsAdminDialog.this.maxRow);
        }

        private void deleteContents() {
            int i2 = 0;
            while (i2 < this.getRowCount()) {
                int j2 = 0;
                while (j2 < this.getColumnCount()) {
                    this.data[i2][j2] = null;
                    ++j2;
                }
                ++i2;
            }
        }

        public void addColumn(String lim, String atr) {
            if (lim.compareTo("") != 0) {
                int i2 = 0;
                while (i2 < TLimitationsAdminDialog.this.limitationList.size()) {
                    if (((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getName().compareTo(lim) == 0) {
                        Boolean exist = false;
                        int j2 = 0;
                        while (j2 < ((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getAttributeCount()) {
                            if (atr.compareTo(((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getAttribute(j2).getName()) == 0) {
                                exist = true;
                            }
                            ++j2;
                        }
                        if (!exist.booleanValue() && atr.compareTo("") != 0) {
                            int k2;
                            this.columnNames.add(atr);
                            this.columnNamesXML.add(atr);
                            ((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).addAttribute(new TAttribute(atr, atr));
                            if (TLimitationsAdminDialog.this.type.compareTo("int") == 0) {
                                k2 = 0;
                                while (k2 < this.getRowCount()) {
                                    this.setValueAt(0, k2, this.getColumnCount() - 1);
                                    ++k2;
                                }
                            } else {
                                k2 = 0;
                                while (k2 < this.getRowCount()) {
                                    this.setValueAt(false, k2, this.getColumnCount() - 1);
                                    ++k2;
                                }
                                this.fireTableStructureChanged();
                                TLimitationsAdminDialog.this.computeColumnWidths();
                            }
                        }
                    }
                    ++i2;
                }
                TableColumn column = TLimitationsAdminDialog.this.table.getColumnModel().getColumn(0);
                column.setCellRenderer(new ColorColumnRenderer(Color.LIGHT_GRAY, Color.BLACK));
            }
        }

        public void removeColumn(String lim, String atr) {
            if (lim.compareTo("") != 0) {
                int index = this.columnNames.indexOf(atr);
                this.columnNames.remove(atr);
                this.columnNamesXML.remove(index);
                this.fireTableStructureChanged();
                TLimitationsAdminDialog.this.computeColumnWidths();
                TableColumn column = TLimitationsAdminDialog.this.table.getColumnModel().getColumn(0);
                column.setCellRenderer(new ColorColumnRenderer(Color.LIGHT_GRAY, Color.BLACK));
            }
        }

        public void updateTable(String name, String option) {
            this.deleteContents();
            TLimitationsAdminDialog.this.maxRow = 0;
            this.columnNames.removeAllElements();
            this.columnNames.add(TLanguage.getString("TLimitationsAdminDialog.RANGE"));
            this.columnNamesXML.removeAllElements();
            this.columnNamesXML.add("range");
            String limitName = null;
            int i2 = 0;
            while (i2 < TLimitationsAdminDialog.this.limitationList.size()) {
                if (name.compareTo(((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getName()) == 0) {
                    limitName = ((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getNameXML();
                }
                ++i2;
            }
            if (limitName != null && limitName.compareTo("") != 0) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                SAXBuilder builder = new SAXBuilder();
                try {
                    Element e2;
                    int val;
                    Document doc = option == "default" ? builder.build(DEFAULT_PARAMS_FILE) : builder.build(PARAMS_FILE);
                    Element root = doc.getRootElement();
                    List resolution = root.getChildren("res");
                    Iterator i3 = resolution.iterator();
                    do {
                        e2 = (Element)i3.next();
                        val = Integer.parseInt(e2.getAttributeValue("type"));
                    } while (i3.hasNext() && val != screenSize.width);
                    List limitations = e2.getChildren(limitName);
                    Iterator i_lim = limitations.iterator();
                    if (i_lim.hasNext()) {
                        int row = 0;
                        do {
                            int col = 1;
                            e2 = (Element)i_lim.next();
                            val = Integer.parseInt(e2.getAttributeValue("value"));
                            this.setValueAt(val, row, 0);
                            List attributes = e2.getChildren();
                            Iterator i_atr = attributes.iterator();
                            if (i_atr.hasNext()) {
                                do {
                                    String nameCol;
                                    if (!this.columnNamesXML.contains(nameCol = (e2 = (Element)i_atr.next()).getName())) {
                                        if (TLanguage.getString("Rules." + nameCol.toUpperCase()).startsWith("!")) {
                                            this.columnNames.add(nameCol);
                                            this.columnNamesXML.add(nameCol);
                                        } else {
                                            this.columnNames.add(TLanguage.getString("Rules." + e2.getName().toUpperCase()));
                                            this.columnNamesXML.add(e2.getName());
                                        }
                                    }
                                    if (e2.getText().compareTo("true") == 0) {
                                        this.setValueAt(new Boolean(true), row, col);
                                    } else if (e2.getText().compareTo("false") == 0) {
                                        this.setValueAt(new Boolean(false), row, col);
                                    } else {
                                        this.setValueAt(Integer.parseInt(e2.getText()), row, col);
                                    }
                                    ++col;
                                } while (i_atr.hasNext());
                            }
                            ++row;
                        } while (i_lim.hasNext());
                        TLimitationsAdminDialog.this.maxRow = row - 1;
                    }
                }
                catch (JDOMException e3) {
                    e3.printStackTrace();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
            this.fireTableStructureChanged();
            TLimitationsAdminDialog.this.computeColumnWidths();
            TableColumn column = TLimitationsAdminDialog.this.table.getColumnModel().getColumn(0);
            column.setCellRenderer(new ColorColumnRenderer(Color.LIGHT_GRAY, Color.BLACK));
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public int saveTable(JTable table) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            SAXBuilder builder = new SAXBuilder();
            String name = (String)TLimitationsAdminDialog.this.limitCombo.getSelectedItem();
            String limitName = null;
            int i2 = 0;
            while (i2 < TLimitationsAdminDialog.this.limitationList.size()) {
                if (name.compareTo(((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getName()) == 0) {
                    limitName = ((TLimitation)TLimitationsAdminDialog.this.limitationList.get(i2)).getNameXML();
                }
                ++i2;
            }
            if (limitName != null && limitName.compareTo("") != 0) {
                try {
                    Document doc = builder.build(PARAMS_FILE);
                    Element root = doc.getRootElement();
                    List resolution = root.getChildren("res");
                    Iterator i3 = resolution.iterator();
                    if (i3.hasNext()) {
                        Element e2;
                        String val;
                        do {
                            e2 = (Element)i3.next();
                            val = e2.getAttributeValue("type");
                        } while (i3.hasNext() && Integer.parseInt(val) != screenSize.width);
                        List limitations = e2.getChildren(limitName);
                        Iterator i_lim = limitations.iterator();
                        if (i_lim.hasNext()) {
                            do {
                                i_lim.next();
                                i_lim.remove();
                            } while (i_lim.hasNext());
                        }
                        int r2 = 0;
                        while (r2 < this.getRowCount()) {
                            if (this.data[r2][0] != null) {
                                Element limit = new Element(limitName);
                                limit.setAttribute("value", String.valueOf(this.data[r2][0]));
                                int c2 = 1;
                                while (c2 < this.getColumnCount()) {
                                    if (this.data[r2][c2] == null) {
                                        JOptionPane.showMessageDialog(null, TLanguage.getString("TLimitationsAdminDialog.INFO_BLANKCELLS"), TLanguage.getString("WARNING"), 2);
                                        return -1;
                                    }
                                    limit.addContent(new Element(this.columnNamesXML.elementAt(c2)).setText(String.valueOf(this.data[r2][c2])));
                                    ++c2;
                                }
                                e2.addContent(limit);
                            }
                            ++r2;
                        }
                    } else {
                        Element res = new Element("res");
                        res.setAttribute("type", Integer.toString(screenSize.width));
                        int r3 = 0;
                        while (r3 < this.getRowCount()) {
                            if (this.data[r3][0] != null) {
                                Element limit = new Element(limitName);
                                limit.setAttribute("value", String.valueOf(this.data[r3][0]));
                                int c3 = 1;
                                while (c3 < this.getColumnCount()) {
                                    if (this.data[r3][c3] != null) {
                                        limit.addContent(new Element(this.columnNamesXML.elementAt(c3)).setText(String.valueOf(this.data[r3][c3])));
                                    }
                                    ++c3;
                                }
                                res.addContent(limit);
                            }
                            ++r3;
                        }
                        root.addContent(res);
                    }
                    XMLOutputter xml = new XMLOutputter(Format.getPrettyFormat());
                    FileOutputStream file = new FileOutputStream(PARAMS_FILE);
                    xml.output(doc, (OutputStream)file);
                    return 0;
                }
                catch (JDOMException e3) {
                    return -1;
                }
                catch (IOException e4) {
                    return -1;
                }
            }
            return -1;
        }
    }
}

