/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import tico.components.TButton;
import tico.components.TComboBox;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.rules.TAttribute;
import tico.rules.TRule;
import tico.rules.database.TLoadParameter;
import tico.rules.database.TLoadRule;
import tico.rules.database.TSaveRule;
import tico.rules.database.TWriteLanguageFile;

public class TAddRuleDialog
extends TDialog
implements ActionListener {
    private TComboBox functionCombo;
    private TComboBox attributeCombo;
    private TComboBox attributeCombo2;
    private TComboBox parameterCombo;
    private JTextField languageField;
    public static Vector<Integer> userValue = new Vector();
    private Vector<String> functionTypes = new Vector();
    private Vector<String> functionTypesXML = new Vector();
    private Vector<TAttribute> attributeList = new Vector();
    private Vector<TAttribute> parameterList = new Vector();

    public TAddRuleDialog(TEditor editor) {
        super(editor, TLanguage.getString("TAddRule.TITLE"), true);
        this.createComponents(editor);
    }

    private void createComponents(TEditor editor) {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(TLanguage.getString("TAddRule.TAB"), this.createEntryPanel());
        this.add(tabbedPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tabbedPane, "North");
        this.getContentPane().add((Component)this.createButtonPanel(editor), "South");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(editor);
        this.setVisible(true);
    }

    private JPanel createEntryPanel() {
        JPanel entryPanel = new JPanel();
        entryPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TAddRule.TEXT_TITLE")));
        this.createFunctionCombo();
        this.createAttributeCombo();
        this.createParameterCombo();
        JLabel functionLabel = new JLabel(TLanguage.getString("TAddRule.FUNCTION"));
        JLabel attributeLabel = new JLabel(TLanguage.getString("TAddRule.ATTRIBUTE"));
        JLabel parameterLabel = new JLabel(TLanguage.getString("TAddRule.PARAMETER"));
        JLabel languageLabel = new JLabel(String.valueOf(TLanguage.getString("TAddRule.LANGUAGE")) + TSetup.getLanguage().toLowerCase());
        JLabel infoLabel = new JLabel(TLanguage.getString("TAddRule.INFOLABEL"));
        this.languageField = new JTextField(80);
        this.languageField.setColumns(20);
        GridBagConstraints c2 = new GridBagConstraints();
        entryPanel.setLayout(new GridBagLayout());
        functionLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 0;
        c2.gridy = 0;
        entryPanel.add((Component)functionLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 0;
        c2.gridy = 1;
        entryPanel.add((Component)this.functionCombo, c2);
        attributeLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 0;
        entryPanel.add((Component)attributeLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 1;
        entryPanel.add((Component)this.attributeCombo, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 2;
        entryPanel.add((Component)this.attributeCombo2, c2);
        parameterLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 3;
        entryPanel.add((Component)parameterLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 4;
        entryPanel.add((Component)this.parameterCombo, c2);
        languageLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 5;
        entryPanel.add((Component)languageLabel, c2);
        c2.fill = 1;
        c2.insets = new Insets(1, 10, 1, 10);
        c2.gridx = 1;
        c2.gridy = 6;
        entryPanel.add((Component)this.languageField, c2);
        infoLabel.setHorizontalAlignment(2);
        c2.fill = 1;
        c2.insets = new Insets(5, 10, 5, 15);
        c2.gridx = 1;
        c2.gridy = 7;
        entryPanel.add((Component)infoLabel, c2);
        return entryPanel;
    }

    private void createFunctionCombo() {
        this.functionTypes.add("");
        this.functionTypesXML.add("");
        TLoadRule load_r = new TLoadRule();
        Vector<TRule> rules = load_r.loadAllRules();
        int i2 = 0;
        while (i2 < rules.size()) {
            if (!this.functionTypes.contains(rules.get(i2).getFunction())) {
                this.functionTypes.add(rules.get(i2).getFunction());
            }
            if (!this.functionTypesXML.contains(rules.get(i2).getFunctionXML())) {
                this.functionTypesXML.add(rules.get(i2).getFunctionXML());
            }
            ++i2;
        }
        this.functionCombo = new TComboBox((Vector)this.functionTypes);
        this.functionCombo.setMinimumSize(new Dimension(310, 25));
        this.functionCombo.setPreferredSize(new Dimension(310, 25));
        this.functionCombo.addActionListener(this);
        this.functionCombo.setSelectedIndex(0);
    }

    private void createAttributeCombo() {
        this.attributeCombo = new TComboBox();
        this.attributeCombo.addItem("");
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.PROJECTNUMBOARDS"), "projectNumBoards", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDHEIGHT"), "boardHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDWIDTH"), "boardWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDNOIMAGE"), "boardNoImage", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDSOUND"), "boardSound", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDLIGHTNESS"), "boardLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLHEIGHT"), "cellHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLWIDTH"), "cellWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLLIGHTNESS"), "cellLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXT"), "cellText", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSIZE"), "cellTextSize", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTTYPE"), "cellTextType", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTFONT"), "cellTextFont", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSTYLE"), "cellTextStyle", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTLIGHTNESS"), "cellTextLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOIMAGE"), "cellNoImage", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEHEIGHT"), "cellImageHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEWIDTH"), "cellImageWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLSOUND"), "cellSound", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERWIDTH"), "cellBorderWidth", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERLIGHTNESS"), "cellBorderLightness", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLROW"), "cellRow", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLCOLUMN"), "cellColumn", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOALTERNATIVEICON"), "cellNoAlternativeIcon", new Boolean(false)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONHEIGHT"), "cellIconHeight", new Integer(0)));
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONWIDTH"), "cellIconWidth", new Integer(0)));
        int i2 = 0;
        while (i2 < this.attributeList.size()) {
            this.attributeCombo.addItem(this.attributeList.get(i2).getName());
            ++i2;
        }
        this.attributeCombo.setSelectedIndex(0);
        this.attributeCombo2 = new TComboBox();
        this.attributeCombo2.setEnabled(false);
    }

    private void createParameterCombo() {
        this.parameterList.removeAllElements();
        TLoadParameter params = new TLoadParameter();
        this.parameterList = params.loadAllParameters();
        this.parameterCombo = new TComboBox();
        this.parameterCombo.addItem("");
        int i2 = 0;
        while (i2 < this.parameterList.size()) {
            this.parameterCombo.addItem(this.parameterList.get(i2).getName());
            ++i2;
        }
        this.parameterCombo.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Vector<String> auxAttrib = new Vector<String>();
        Vector<String> auxParam = new Vector<String>();
        JComboBox cb = (JComboBox)e2.getSource();
        String funName = (String)cb.getSelectedItem();
        String funNameXML = null;
        if (funName != null && funName.compareTo("") != 0) {
            int i2 = 0;
            while (i2 < this.functionTypes.size()) {
                if (funName.compareTo(this.functionTypes.get(i2)) == 0) {
                    funNameXML = this.functionTypesXML.get(i2);
                }
                ++i2;
            }
            this.parameterCombo.removeAllItems();
            this.attributeCombo.removeAllItems();
            if (funNameXML.compareTo("exist") == 0 || funNameXML.compareTo("type") == 0) {
                i2 = 0;
                while (i2 < this.parameterList.size()) {
                    if (this.parameterList.get(i2).getValue().getClass() == new Boolean(false).getClass()) {
                        auxParam.add(this.parameterList.get(i2).getName());
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.attributeList.size()) {
                    if (this.attributeList.get(i2).getValue().getClass() == new Boolean(false).getClass()) {
                        auxAttrib.add(this.attributeList.get(i2).getName());
                    }
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < this.parameterList.size()) {
                    if (this.parameterList.get(i2).getValue().getClass() == new Integer(0).getClass()) {
                        auxParam.add(this.parameterList.get(i2).getName());
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.attributeList.size()) {
                    if (this.attributeList.get(i2).getValue().getClass() == new Integer(0).getClass()) {
                        auxAttrib.add(this.attributeList.get(i2).getName());
                    }
                    ++i2;
                }
            }
            this.parameterCombo.addItem("");
            i2 = 0;
            while (i2 < auxParam.size()) {
                this.parameterCombo.addItem(auxParam.get(i2));
                ++i2;
            }
            this.attributeCombo.addItem("");
            i2 = 0;
            while (i2 < auxAttrib.size()) {
                this.attributeCombo.addItem(auxAttrib.get(i2));
                ++i2;
            }
            if (funNameXML.compareTo("lightness") == 0) {
                this.attributeCombo2.removeAllItems();
                this.attributeCombo2.setEnabled(true);
                this.attributeCombo2.addItem("");
                i2 = 0;
                while (i2 < auxAttrib.size()) {
                    this.attributeCombo2.addItem(auxAttrib.get(i2));
                    ++i2;
                }
            } else {
                this.attributeCombo2.setEnabled(false);
            }
        }
    }

    private JPanel createButtonPanel(TEditor editor) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton saveButton = new TButton(TLanguage.getString("TAddRule.SAVE_BUTTON"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TRule rule = new TRule();
                int ret = TAddRuleDialog.this.saveRule(rule);
                if (ret != -1) {
                    String funXML = null;
                    int i2 = 0;
                    while (i2 < TAddRuleDialog.this.functionTypes.size()) {
                        if (((String)TAddRuleDialog.this.functionCombo.getSelectedItem()).compareTo((String)TAddRuleDialog.this.functionTypes.get(i2)) == 0) {
                            funXML = (String)TAddRuleDialog.this.functionTypesXML.get(i2);
                        }
                        ++i2;
                    }
                    if (funXML.compareTo("lightness") == 0) {
                        TAddRuleDialog.this.attributeCombo2.setSelectedIndex(0);
                    }
                    TAddRuleDialog.this.functionCombo.setSelectedIndex(0);
                    TAddRuleDialog.this.attributeCombo.setSelectedIndex(0);
                    TAddRuleDialog.this.parameterCombo.setSelectedIndex(0);
                    TAddRuleDialog.this.languageField.setText("");
                }
            }
        });
        buttonPanel.add(saveButton);
        TButton closeButton = new TButton(TLanguage.getString("TAddRule.CLOSE_BUTTON"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TAddRuleDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private int saveRule(TRule rule) {
        String param;
        int i2;
        if (this.functionCombo.getSelectedIndex() != 0) {
            int i3 = 0;
            while (i3 < this.functionTypes.size()) {
                if (((String)this.functionCombo.getSelectedItem()).compareTo(this.functionTypes.get(i3)) == 0) {
                    rule.setFunctionXML(this.functionTypesXML.get(i3));
                }
                ++i3;
            }
        } else {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_FUN"), TLanguage.getString("WARNING"), 2);
            return -1;
        }
        String atr = (String)this.attributeCombo.getSelectedItem();
        if (atr == null || atr.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ATR"), TLanguage.getString("WARNING"), 2);
            return -1;
        }
        int i4 = 0;
        while (i4 < this.attributeList.size()) {
            if (this.attributeList.get(i4).getName().compareTo(atr) == 0) {
                rule.setAttribute(new TAttribute(null, this.attributeList.get(i4).getNameXML()));
            }
            ++i4;
        }
        if (rule.getFunctionXML().compareTo("lightness") == 0) {
            String atr2 = (String)this.attributeCombo2.getSelectedItem();
            if (atr2 == null || atr2.compareTo("") == 0) {
                JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ATR"), TLanguage.getString("WARNING"), 2);
                return -1;
            }
            i2 = 0;
            while (i2 < this.attributeList.size()) {
                if (this.attributeList.get(i2).getName().compareTo(atr2) == 0) {
                    rule.setAttribute2(new TAttribute(null, this.attributeList.get(i2).getNameXML()));
                }
                ++i2;
            }
        }
        if ((param = (String)this.parameterCombo.getSelectedItem()) == null || param.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_PAR"), TLanguage.getString("WARNING"), 2);
            return -1;
        }
        i2 = 0;
        while (i2 < this.parameterList.size()) {
            if (this.parameterList.get(i2).getName().compareTo(param) == 0) {
                rule.setParameter(new TAttribute(null, this.parameterList.get(i2).getNameXML()));
            }
            ++i2;
        }
        if (this.languageField.getText().compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.INFO_BLANK_ES"), TLanguage.getString("WARNING"), 2);
            return -1;
        }
        TLoadRule load_r = new TLoadRule();
        Vector<Object> ruleList = new Vector();
        ruleList = load_r.loadAllRules();
        String[] s2 = ((TRule)ruleList.lastElement()).getNameXML().split("_");
        int num = Integer.valueOf(s2[1]) + 1;
        rule.setNameXML("RULE_" + num);
        rule.setMessage(this.languageField.getText());
        rule.setMessageXML("MESSAGE_" + num);
        new TWriteLanguageFile(rule.getMessage(), rule.getMessageXML());
        String str = rule.getAttribute().getNameXML();
        if (str.contains("project")) {
            rule.setType("project");
        } else if (str.contains("board")) {
            rule.setType("board");
        } else if (str.contains("cell")) {
            rule.setType("cell");
        } else if (str.contains("int")) {
            rule.setType("interpreter");
        }
        TSaveRule save_r = new TSaveRule();
        int ret = save_r.saveRule(rule);
        if (ret != -1) {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.SAVE_OK_MESSAGE"), TLanguage.getString("INFO"), 1);
        } else {
            JOptionPane.showMessageDialog(null, TLanguage.getString("TAddRule.SAVE_ERROR_MESSAGE"), TLanguage.getString("ERROR"), 0);
        }
        return 0;
    }
}

