/*
 * Decompiled with CFR 0.152.
 */
package tico.rules.database;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import tico.configuration.TLanguage;
import tico.rules.TAttribute;
import tico.rules.TLimitation;
import tico.rules.TRule;
import tico.rules.database.TLoadParameter;

public class TLoadRule {
    private static String RULES_FILE_PATH = "conf" + File.separator + "rules.xml";
    private static File RULES_FILE = new File(RULES_FILE_PATH);

    public Vector<TRule> loadRulesByType(String option, Vector<TAttribute> attributeList) {
        Vector<TRule> ruleList = new Vector<TRule>();
        Vector<Object> limitationList = new Vector();
        TLoadParameter load_p = new TLoadParameter();
        limitationList = load_p.getLimitationList();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(RULES_FILE);
            Element root = doc.getRootElement();
            List rules = root.getChildren("rule");
            Iterator i2 = rules.iterator();
            if (i2.hasNext()) {
                do {
                    TRule rule = new TRule();
                    Element e2 = (Element)i2.next();
                    String val = e2.getAttributeValue("type");
                    if (val.compareTo(option) != 0) continue;
                    List features = e2.getChildren();
                    Iterator i_feat = features.iterator();
                    if (i_feat.hasNext()) {
                        do {
                            int j2;
                            e2 = (Element)i_feat.next();
                            rule.setType(val);
                            if (e2.getName().compareTo("name") == 0) {
                                rule.setNameXML(e2.getText());
                                continue;
                            }
                            if (e2.getName().compareTo("atr") == 0) {
                                j2 = 0;
                                while (j2 < attributeList.size()) {
                                    if (attributeList.elementAt(j2).getNameXML().compareTo(e2.getText()) == 0) {
                                        rule.setAttribute(new TAttribute(attributeList.elementAt(j2).getName(), attributeList.elementAt(j2).getNameXML(), attributeList.elementAt(j2).getValue()));
                                    }
                                    ++j2;
                                }
                            } else if (e2.getName().compareTo("atr2") == 0) {
                                j2 = 0;
                                while (j2 < attributeList.size()) {
                                    if (attributeList.elementAt(j2).getNameXML().compareTo(e2.getText()) == 0) {
                                        rule.setAttribute2(new TAttribute(attributeList.elementAt(j2).getName(), attributeList.elementAt(j2).getNameXML(), attributeList.elementAt(j2).getValue()));
                                    }
                                    ++j2;
                                }
                            } else if (e2.getName().compareTo("param") == 0) {
                                j2 = 0;
                                while (j2 < limitationList.size()) {
                                    int k2 = 0;
                                    while (k2 < ((TLimitation)limitationList.get(j2)).getAttributeCount()) {
                                        if (((TLimitation)limitationList.elementAt(j2)).getAttribute(k2).getNameXML().compareTo(e2.getText()) == 0) {
                                            rule.setParameter(new TAttribute(((TLimitation)limitationList.elementAt(j2)).getAttribute(k2).getName(), ((TLimitation)limitationList.elementAt(j2)).getAttribute(k2).getNameXML(), ((TLimitation)limitationList.elementAt(j2)).getAttribute(k2).getValue()));
                                            rule.getParameter().setLimitType(((TLimitation)limitationList.get(j2)).getNameXML());
                                        }
                                        ++k2;
                                    }
                                    ++j2;
                                }
                            } else {
                                if (e2.getName().compareTo("function") == 0) {
                                    rule.setFunctionXML(e2.getText());
                                    continue;
                                }
                                if (e2.getName().compareTo("text") != 0) continue;
                                rule.setMessageXML(e2.getText());
                            }
                        } while (i_feat.hasNext());
                    }
                    ruleList.add(rule);
                } while (i2.hasNext());
            }
        }
        catch (JDOMException e3) {
            return null;
        }
        catch (IOException e4) {
            return null;
        }
        return ruleList;
    }

    public Vector<TRule> loadAllRules() {
        Vector<TRule> ruleList = new Vector<TRule>();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(RULES_FILE);
            Element root = doc.getRootElement();
            List rules = root.getChildren("rule");
            Iterator i2 = rules.iterator();
            if (i2.hasNext()) {
                do {
                    Element e2 = (Element)i2.next();
                    List features = e2.getChildren();
                    Iterator i_feat = features.iterator();
                    TRule rule = new TRule();
                    rule.setType(e2.getAttributeValue("type"));
                    if (!i_feat.hasNext()) continue;
                    do {
                        if ((e2 = (Element)i_feat.next()).getName().compareTo("name") == 0) {
                            rule.setNameXML(e2.getText());
                            String[] name = e2.getText().split("_");
                            rule.setName(String.valueOf(TLanguage.getString("TRulesAdminDialog.RULE")) + "_" + name[1]);
                        }
                        if (e2.getName().compareTo("atr") == 0) {
                            rule.setAttribute(new TAttribute(TLanguage.getString("Rules." + e2.getText().toUpperCase()), e2.getText()));
                        }
                        if (e2.getName().compareTo("atr2") == 0) {
                            rule.setAttribute2(new TAttribute(TLanguage.getString("Rules." + e2.getText().toUpperCase()), e2.getText()));
                        }
                        if (e2.getName().compareTo("param") == 0) {
                            if (TLanguage.getString("Rules." + e2.getText().toUpperCase()).startsWith("!")) {
                                rule.setParameter(new TAttribute(e2.getText(), e2.getText()));
                            } else {
                                rule.setParameter(new TAttribute(TLanguage.getString("Rules." + e2.getText().toUpperCase()), e2.getText()));
                            }
                        }
                        if (e2.getName().compareTo("function") == 0) {
                            rule.setFunctionXML(e2.getText());
                            rule.setFunction(TLanguage.getString("TRulesAdminDialog." + e2.getText().toUpperCase()));
                        }
                        if (e2.getName().compareTo("text") != 0) continue;
                        rule.setMessageXML(e2.getText());
                        rule.setMessage(TLanguage.getString("TShowResults." + e2.getText()));
                    } while (i_feat.hasNext());
                    ruleList.add(rule);
                } while (i2.hasNext());
            }
        }
        catch (JDOMException e3) {
            return null;
        }
        catch (IOException e4) {
            return null;
        }
        return ruleList;
    }
}

