/*
 * Decompiled with CFR 0.152.
 */
package tico.rules;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tico.configuration.TLanguage;
import tico.editor.TEditor;
import tico.interpreter.TInterpreter;
import tico.rules.TAttribute;
import tico.rules.TRule;
import tico.rules.database.TLoadRule;

public class TShowResults
extends TLanguage {
    private JDialog textAreaDialog;
    private static final String newline = "\n";
    private static final String tab = "\t";
    private static String text = "";

    public void createDialog(TEditor editor, String type) {
        this.textAreaDialog = type == "VALIDATION" ? new JDialog(editor, TLanguage.getString("TShowResults.TEXTAREA_VALIDATION_NAME"), false) : new JDialog(editor, TLanguage.getString("TShowResults.TEXTAREA_DESIGNRULES_NAME"), false);
        this.createTextAreaPanel();
        this.textAreaDialog.getContentPane().setLayout(new BorderLayout());
        this.textAreaDialog.getContentPane().add((Component)this.createTextAreaPanel(), "North");
        this.textAreaDialog.setDefaultCloseOperation(2);
        this.textAreaDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                TShowResults.this.removeText();
            }
        });
        this.textAreaDialog.setResizable(false);
        this.textAreaDialog.pack();
        this.textAreaDialog.setLocationRelativeTo(editor);
        this.textAreaDialog.setVisible(true);
        this.removeText();
    }

    public void createDialog(TInterpreter interpreter, String type) {
        this.textAreaDialog = type == "VALIDATION" ? new JDialog(interpreter, TLanguage.getString("TShowResults.TEXTAREA_VALIDATION_NAME"), false) : new JDialog(interpreter, TLanguage.getString("TShowResults.TEXTAREA_DESIGNRULES_NAME"), false);
        this.createTextAreaPanel();
        this.textAreaDialog.getContentPane().setLayout(new BorderLayout());
        this.textAreaDialog.getContentPane().add((Component)this.createTextAreaPanel(), "North");
        this.textAreaDialog.setDefaultCloseOperation(2);
        this.textAreaDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                TShowResults.this.removeText();
            }
        });
        this.textAreaDialog.setResizable(false);
        this.textAreaDialog.pack();
        this.textAreaDialog.setLocationRelativeTo(interpreter);
        this.textAreaDialog.setVisible(true);
        this.removeText();
    }

    private JPanel createTextAreaPanel() {
        JPanel textAreaPanel = new JPanel();
        JTextArea textArea = new JTextArea(15, 85);
        textArea.setEditable(false);
        textArea.setFont(new Font("Courier", 0, 12));
        textArea.append(text);
        JScrollPane scrollPane = new JScrollPane(textArea, 22, 32);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridwidth = 0;
        c2.fill = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        textAreaPanel.add((Component)scrollPane, c2);
        textArea.setCaretPosition(0);
        if (text.compareTo("") == 0) {
            text = TLanguage.getString("TShowResults.NO_ADVICES");
        }
        return textAreaPanel;
    }

    public void addToValidationResults(String str) {
        if (str != "") {
            String[] strVector = str.split("-");
            try {
                int n_rule = Integer.parseInt(strVector[0]);
                switch (n_rule) {
                    case 101: {
                        text = String.valueOf(text) + strVector[2] + newline + tab + TLanguage.getString("TShowResults.PROPERTY") + " " + TLanguage.getString("TShowResults." + strVector[1]) + newline + newline;
                        break;
                    }
                    case 102: {
                        text = String.valueOf(text) + strVector[2] + newline + tab + TLanguage.getString("TShowResults.PROPERTY") + " " + TLanguage.getString("TShowResults." + strVector[1]) + newline + tab + TLanguage.getString("TShowResults.ADVICE") + " ";
                        if (strVector[1].compareTo("MESSAGE_16") == 0) {
                            text = String.valueOf(text) + TLanguage.getString("TShowResults.UPPERCASE") + newline + newline;
                            break;
                        }
                        if (strVector[1].compareTo("MESSAGE_18") == 0) {
                            text = String.valueOf(text) + TLanguage.getString("TShowResults.FONT") + newline + newline;
                            break;
                        }
                        if (strVector[1].compareTo("MESSAGE_19") == 0) {
                            text = String.valueOf(text) + TLanguage.getString("TShowResults.STYLE") + newline + newline;
                            break;
                        }
                        if (strVector[1].compareTo("MESSAGE_23") == 0) {
                            text = String.valueOf(text) + TLanguage.getString("TShowResults.MOUSEBAR") + newline + newline;
                        }
                        break;
                    }
                    case 103: {
                        text = String.valueOf(text) + strVector[2] + newline + tab + TLanguage.getString("TShowResults.PROPERTY") + " " + TLanguage.getString("TShowResults." + strVector[1]) + newline + tab + TLanguage.getString("TShowResults.VALUE") + " " + strVector[3] + newline;
                        text = String.valueOf(text) + tab + TLanguage.getString("TShowResults.ADVICE") + " " + strVector[4] + newline + newline;
                        break;
                    }
                    case 104: {
                        text = String.valueOf(text) + strVector[2] + newline + tab + TLanguage.getString("TShowResults.PROPERTY") + " " + TLanguage.getString("TShowResults." + strVector[1]) + newline + tab + TLanguage.getString("TShowResults.VALUE") + " " + strVector[3] + newline + tab + TLanguage.getString("TShowResults.ADVICE") + " " + strVector[4] + newline + newline;
                    }
                }
            }
            catch (Exception e2) {
                text = String.valueOf(text) + newline + strVector[0] + newline + newline;
            }
        }
    }

    private void removeText() {
        text = "";
    }

    public void designRules(String type) {
        Vector<TAttribute> attributeList = new Vector<TAttribute>();
        Vector<TRule> ruleList = new Vector();
        TLoadRule load_r = new TLoadRule();
        if (type.compareTo("project") == 0) {
            ruleList = load_r.loadRulesByType("project", attributeList);
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.ATTRIB_PROJECT") + newline + newline;
            this.designRulesForType(ruleList);
            this.colorTable();
        } else if (type.compareTo("board") == 0) {
            ruleList = load_r.loadRulesByType("board", attributeList);
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.ATTRIB_BOARD") + newline + newline;
            this.designRulesForType(ruleList);
            ruleList = load_r.loadRulesByType("cell", attributeList);
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.ATTRIB_CELL") + newline + newline;
            this.designRulesForType(ruleList);
            this.colorTable();
        } else if (type.compareTo("interpreter") == 0) {
            ruleList = load_r.loadRulesByType("interpreter", attributeList);
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.ATTRIB_INTERPRETER") + newline + newline;
            this.designRulesForType(ruleList);
        }
    }

    private void designRulesForType(Vector<TRule> ruleList) {
        Vector<TRule> ruleAux = new Vector<TRule>();
        ruleAux.clear();
        if (ruleList.size() > 0) {
            int i2 = 0;
            while (i2 < ruleList.size()) {
                if (ruleAux.size() == 0) {
                    ruleAux.add(ruleList.get(i2));
                    String typeLim = "";
                    typeLim = TLanguage.getString("Rules." + ruleList.get(i2).getParameter().getLimitType().toUpperCase()).startsWith("!") ? ruleList.get(i2).getParameter().getLimitType() : TLanguage.getString("Rules." + ruleList.get(i2).getParameter().getLimitType().toUpperCase());
                    if (typeLim.compareTo("") != 0) {
                        text = String.valueOf(text) + "(" + typeLim + ") ";
                    }
                    text = String.valueOf(text) + ruleList.get(i2).getParameter().getName() + " --> ";
                    text = ruleList.get(i2).getParameter().getValue().equals(false) ? String.valueOf(text) + TLanguage.getString("TShowResults.NO") : (ruleList.get(i2).getParameter().getValue().equals(true) ? String.valueOf(text) + TLanguage.getString("TShowResults.YES") : String.valueOf(text) + ruleList.get(i2).getParameter().getValue());
                    text = String.valueOf(text) + newline;
                } else {
                    Boolean exist = false;
                    int j2 = 0;
                    while (j2 < ruleAux.size()) {
                        if (((TRule)ruleAux.get(j2)).getParameter().getNameXML().compareTo(ruleList.get(i2).getParameter().getNameXML()) == 0) {
                            exist = true;
                        }
                        ++j2;
                    }
                    if (!exist.booleanValue()) {
                        ruleAux.add(ruleList.get(i2));
                        String typeLim = "";
                        typeLim = TLanguage.getString("Rules." + ruleList.get(i2).getParameter().getLimitType().toUpperCase()).startsWith("!") ? ruleList.get(i2).getParameter().getLimitType() : TLanguage.getString("Rules." + ruleList.get(i2).getParameter().getLimitType().toUpperCase());
                        if (typeLim.compareTo("") != 0) {
                            text = String.valueOf(text) + "(" + typeLim + ") ";
                        }
                        text = String.valueOf(text) + ruleList.get(i2).getParameter().getName() + " --> ";
                        text = ruleList.get(i2).getParameter().getValue().equals(false) ? String.valueOf(text) + TLanguage.getString("TShowResults.NO") : (ruleList.get(i2).getParameter().getValue().equals(true) ? String.valueOf(text) + TLanguage.getString("TShowResults.YES") : String.valueOf(text) + ruleList.get(i2).getParameter().getValue());
                        text = String.valueOf(text) + newline;
                    }
                }
                ++i2;
            }
        }
    }

    private void colorTable() {
        String language = currentLanguage;
        if (language.compareTo("Espa\u00f1ol") == 0) {
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.COLORTABLE") + newline;
            text = String.valueOf(text) + "|-----------------------------------------------------------------------------|\n|  FONDO   |                               TEXTO                              |\n|          | negro | blanco | magenta | cian | amarillo | verde | rojo | azul |\n|----------|-------|--------|---------|------|----------|-------|------|------|\n| negro    |       |   x    |    x    |  x   |    x     |   x   |  x   |  x   |\n| blanco   |   x   |        |    x    |      |          |       |  x   |  x   |\n| magenta  |   x   |   x    |         |  x   |    x     |   x   |      |      |\n| cian     |   x   |        |    x    |      |          |       |  x   |  x   |\n| amarillo |   x   |        |    x    |      |          |       |  x   |  x   |\n| verde    |   x   |        |    x    |      |          |       |      |  x   |\n| rojo     |       |   x    |         |  x   |    x     |       |      |      |\n| azul     |       |   x    |         |  x   |    x     |   x   |      |      |\n|-----------------------------------------------------------------------------|\n";
        } else {
            text = String.valueOf(text) + newline + TLanguage.getString("TShowResults.COLORTABLE") + newline;
            text = String.valueOf(text) + "|-----------------------------------------------------------------------------|\n|  BACKGROUND  |                               TEXT                           |\n|              | black | white | magenta | cyan | yellow | green | red | blue |\n|--------------|-------|-------|---------|------|--------|-------|-----|------|\n| black        |       |   x   |    x    |  x   |   x    |   x   |  x  |  x   |\n| white        |   x   |       |    x    |      |        |       |  x  |  x   |\n| magenta      |   x   |   x   |         |  x   |   x    |   x   |     |      |\n| cyan         |   x   |       |    x    |      |        |       |  x  |  x   |\n| yellow       |   x   |       |    x    |      |        |       |  x  |  x   |\n| green        |   x   |       |    x    |      |        |       |     |  x   |\n| red          |       |   x   |         |  x   |   x    |       |     |      |\n| blue         |       |   x   |         |  x   |   x    |   x   |     |      |\n|-----------------------------------------------------------------------------|\n";
        }
    }
}

