/*
 * Decompiled with CFR 0.152.
 */
package tico.rules;

import java.awt.Color;
import java.io.File;
import java.io.StringWriter;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jess.Funcall;
import jess.JessException;
import jess.Rete;
import jess.Value;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.TProject;
import tico.board.components.TCell;
import tico.board.components.TComponent;
import tico.board.components.TGridCell;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterConstants;
import tico.rules.TAttribute;
import tico.rules.TColorTransformation;
import tico.rules.TComparationMax;
import tico.rules.TComparationMin;
import tico.rules.TExist;
import tico.rules.TLightness;
import tico.rules.TRule;
import tico.rules.TShowResults;
import tico.rules.TType;
import tico.rules.database.TLoadRule;

public class TGenerateRules {
    private Rete engine;
    StringWriter sw;
    String boardName;
    public Vector<TAttribute> attributeList = new Vector();
    private static final String newline = "\n";
    private static String RULES_DIRECTORY = "src" + File.separator + "tico" + File.separator + "rules" + File.separator + "TRules.clp";

    public TGenerateRules() {
        this.engine = new Rete();
    }

    private void generateRules(String element, String name) {
        this.sw = new StringWriter();
        this.engine.addOutputRouter("out", this.sw);
        try {
            this.engine.batch(RULES_DIRECTORY);
            String ret = this.createPredefinedRules(element, name);
            if (ret == null) {
                this.engine.run();
                this.engine.clear();
                this.getResults(element);
            } else {
                JOptionPane.showMessageDialog(null, String.valueOf(TLanguage.getString("TGenerateRules.ERROR_MESSAGE")) + " " + ret, TLanguage.getString("ERROR"), 0);
            }
        }
        catch (JessException e2) {
            e2.printStackTrace();
        }
    }

    private String createPredefinedRules(String element, String name) {
        Vector<Object> ruleList = new Vector();
        TLoadRule rules = new TLoadRule();
        ruleList = rules.loadRulesByType(element, this.attributeList);
        int i2 = 0;
        while (i2 < ruleList.size()) {
            TRule rule = (TRule)ruleList.get(i2);
            try {
                Funcall f2;
                if (rule.getFunctionXML().compareTo("comparationMin") == 0) {
                    TComparationMin comparationMin = new TComparationMin(rule.getNameXML(), name, rule.getAttribute().getValue(), rule.getParameter().getValue(), rule.getMessageXML());
                    f2 = new Funcall("definstance", this.engine);
                    f2.add(new Value("comparationMin", 1));
                    f2.add(new Value(comparationMin));
                    f2.execute(this.engine.getGlobalContext());
                } else if (rule.getFunctionXML().compareTo("comparationMax") == 0) {
                    TComparationMax comparationMax = new TComparationMax(rule.getNameXML(), name, rule.getAttribute().getValue(), rule.getParameter().getValue(), rule.getMessageXML());
                    f2 = new Funcall("definstance", this.engine);
                    f2.add(new Value("comparationMax", 1));
                    f2.add(new Value(comparationMax));
                    f2.execute(this.engine.getGlobalContext());
                } else if (rule.getFunctionXML().compareTo("exist") == 0) {
                    TExist exist = new TExist(rule.getNameXML(), name, rule.getAttribute().getValue(), rule.getParameter().getValue(), rule.getMessageXML());
                    f2 = new Funcall("definstance", this.engine);
                    f2.add(new Value("exist", 1));
                    f2.add(new Value(exist));
                    f2.execute(this.engine.getGlobalContext());
                } else if (rule.getFunctionXML().compareTo("type") == 0) {
                    TType type = new TType(rule.getNameXML(), name, rule.getAttribute().getValue(), rule.getParameter().getValue(), rule.getMessageXML());
                    f2 = new Funcall("definstance", this.engine);
                    f2.add(new Value("type", 1));
                    f2.add(new Value(type));
                    f2.execute(this.engine.getGlobalContext());
                } else {
                    TLightness lightness = new TLightness(rule.getNameXML(), name, rule.getAttribute().getValue(), rule.getAttribute2().getValue(), rule.getParameter().getValue(), rule.getMessageXML());
                    f2 = new Funcall("definstance", this.engine);
                    f2.add(new Value("lightness", 1));
                    f2.add(new Value(lightness));
                    f2.execute(this.engine.getGlobalContext());
                }
            }
            catch (Exception e2) {
                return rule.getName();
            }
            ++i2;
        }
        return null;
    }

    public void getProjectAttributes(TProject project) throws JessException {
        this.attributeList.clear();
        String projectName = project.getName();
        int projectNumBoards = project.getBoardCount();
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.PROJECTNUMBOARDS"), "projectNumBoards", projectNumBoards));
        this.generateRules("project", projectName);
        int i2 = 0;
        while (i2 < projectNumBoards) {
            this.getBoardAttributes(project.getBoard(i2));
            ++i2;
        }
    }

    public void getBoardAttributes(TBoard board) throws JessException {
        Map boardMap = ((TBoardModel)board.getModel()).getAttributes();
        this.boardName = board.getBoardName();
        int boardHeight = TBoardConstants.getSize((Map)boardMap).height;
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDHEIGHT"), "boardHeight", boardHeight));
        int boardWidth = TBoardConstants.getSize((Map)boardMap).width;
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDWIDTH"), "boardWidth", boardWidth));
        Color boardColor = TBoardConstants.getBackground(boardMap);
        TColorTransformation color = new TColorTransformation();
        int boardLightness = color.rgbToLab(boardColor.getRed(), boardColor.getGreen(), boardColor.getBlue());
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDLIGHTNESS"), "boardLightness", boardLightness));
        Boolean boardNoImage = TBoardConstants.getIcon(boardMap) == null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDNOIMAGE"), "boardNoImage", boardNoImage));
        Boolean boardSound = TBoardConstants.getSoundFile(boardMap) == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.BOARDSOUND"), "boardSound", boardSound));
        this.generateRules("board", this.boardName);
        this.getCellsAttributes(board);
    }

    public void getCellsAttributes(TBoard board) throws JessException {
        CellView[] views = board.getGraphLayoutCache().getCellViews();
        int i2 = 0;
        while (i2 < views.length) {
            if (views[i2].getCell() instanceof TCell || views[i2].getCell() instanceof TGridCell) {
                int cellSendTextTimer;
                Boolean cellSendText;
                int cellIconWidth;
                int cellIconHeight;
                Boolean cellNoAlternativeIcon;
                int cellImageWidth;
                int cellImageHeight;
                Boolean cellNoImage;
                Boolean cellSound;
                int cellTextLightness;
                Boolean cellTextStyle;
                Boolean cellTextFont;
                Boolean cellTextType;
                int cellTextSize;
                Boolean cellText;
                int cellBorderLightness;
                int cellLightness;
                AttributeMap map = views[i2].getAllAttributes();
                String cellid = ((TComponent)views[i2].getCell()).getId();
                int cellHeight = (int)TBoardConstants.getBounds(map).getHeight();
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLHEIGHT"), "cellHeight", cellHeight));
                int cellWidth = (int)TBoardConstants.getBounds(map).getWidth();
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLWIDTH"), "cellWidth", cellWidth));
                Color cellBackgroundColor = TBoardConstants.getBackground(map);
                TColorTransformation color = new TColorTransformation();
                try {
                    cellLightness = color.rgbToLab(cellBackgroundColor.getRed(), cellBackgroundColor.getGreen(), cellBackgroundColor.getBlue());
                }
                catch (Exception e2) {
                    cellLightness = 0;
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLLIGHTNESS"), "cellLightness", cellLightness));
                Color cellBorderColor = TBoardConstants.getBorderColor(map);
                try {
                    cellBorderLightness = color.rgbToLab(cellBorderColor.getRed(), cellBorderColor.getGreen(), cellBorderColor.getBlue());
                }
                catch (Exception e3) {
                    cellBorderLightness = 0;
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERLIGHTNESS"), "cellBorderLightness", cellBorderLightness));
                int cellBorderWidth = cellBorderColor != null ? Math.max(1, Math.round(TBoardConstants.getLineWidth(map))) : 0;
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLBORDERWIDTH"), "cellBorderWidth", cellBorderWidth));
                String cellTextString = TBoardConstants.getText(map);
                if (cellTextString == "" || cellTextString == null) {
                    cellText = false;
                    cellTextSize = 0;
                    cellTextType = true;
                    cellTextFont = true;
                    cellTextStyle = true;
                    cellTextLightness = -1;
                } else {
                    cellText = true;
                    cellTextSize = TBoardConstants.getFont(map).getSize();
                    String font = TBoardConstants.getFont(map).getFontName();
                    cellTextFont = font.compareTo("Arial") != 0 || font.compareTo("Verdana") != 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    int style = TBoardConstants.getFont(map).getStyle();
                    cellTextStyle = style != 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    String cellTextUpperString = cellTextString.toUpperCase();
                    cellTextType = cellTextString.compareTo(cellTextUpperString) > 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    Color cellTextColor = TBoardConstants.getForeground(map);
                    try {
                        cellTextLightness = color.rgbToLab(cellTextColor.getRed(), cellTextColor.getGreen(), cellTextColor.getBlue());
                    }
                    catch (Exception e4) {
                        cellTextLightness = 0;
                    }
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXT"), "cellText", cellText));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSIZE"), "cellTextSize", cellTextSize));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTTYPE"), "cellTextType", cellTextType));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTFONT"), "cellTextFont", cellTextFont));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTSTYLE"), "cellTextStyle", cellTextStyle));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLTEXTLIGHTNESS"), "cellTextLightness", cellTextLightness));
                try {
                    cellSound = TBoardConstants.getSoundFile(map) == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
                }
                catch (Exception e5) {
                    cellSound = false;
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLSOUND"), "cellSound", cellSound));
                if ((ImageIcon)TBoardConstants.getIcon(map) != null) {
                    cellNoImage = false;
                    cellImageHeight = TBoardConstants.getIcon(map).getIconHeight();
                    cellImageWidth = TBoardConstants.getIcon(map).getIconWidth();
                } else {
                    cellNoImage = true;
                    cellImageHeight = 0;
                    cellImageWidth = 0;
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOIMAGE"), "cellNoImage", cellNoImage));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEHEIGHT"), "cellImageHeight", cellImageHeight));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLIMAGEWIDTH"), "cellImageWidth", cellImageWidth));
                int cellRow = TBoardConstants.getRow(map);
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLROW"), "cellRow", cellRow));
                int cellColumn = TBoardConstants.getColumn(map);
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLCOLUMN"), "cellColumn", cellColumn));
                if (TBoardConstants.getAlternativeIcon(map) != null) {
                    cellNoAlternativeIcon = false;
                    cellIconHeight = TBoardConstants.getAlternativeIcon(map).getIconHeight();
                    cellIconWidth = TBoardConstants.getAlternativeIcon(map).getIconWidth();
                } else {
                    cellNoAlternativeIcon = true;
                    cellIconHeight = 0;
                    cellIconWidth = 0;
                }
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLNOALTERNATIVEICON"), "cellNoAlternativeIcon", cellNoAlternativeIcon));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONHEIGHT"), "cellIconHeight", cellIconHeight));
                this.attributeList.add(new TAttribute(TLanguage.getString("Rules.CELLICONWIDTH"), "cellIconWidth", cellIconWidth));
                if (TBoardConstants.getSendText(map) != null && TBoardConstants.getSendText(map).compareTo("") != 0) {
                    cellSendText = true;
                    cellSendTextTimer = TBoardConstants.getSendTextTimer(map);
                } else {
                    cellSendText = false;
                    cellSendTextTimer = 0;
                }
                this.generateRules("cell", cellid);
            }
            ++i2;
        }
    }

    public void getInterpreterAttributes(TInterpreter interpreter) throws JessException {
        int intAccumulated = TInterpreterConstants.accumulatedCells;
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.INTACCUMULATED"), "intAccumulated", intAccumulated));
        int intDelay = TInterpreterConstants.interpreterDelay;
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.INTDELAY"), "intDelay", intDelay));
        Boolean intMouseBar = TInterpreter.returnMouseMode().equals("automaticScanningMode") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.attributeList.add(new TAttribute(TLanguage.getString("Rules.INTMOUSEBAR"), "intMouseBar", intMouseBar));
        this.generateRules("interpreter", interpreter.getProject().getName());
    }

    private void getResults(String element) {
        TShowResults res = new TShowResults();
        if (element.compareTo("board") == 0) {
            res.addToValidationResults(String.valueOf(TLanguage.getString("TBoardRules.ANALYZE")) + " " + this.boardName + newline + "___________________________________________");
        }
        if (this.sw.toString().compareTo("") != 0) {
            String[] strVector = this.sw.toString().split(";");
            int i2 = 0;
            while (i2 < strVector.length) {
                res.addToValidationResults(strVector[i2]);
                ++i2;
            }
        } else {
            res.addToValidationResults("");
        }
    }
}

