/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.threads;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class TInterpreterWavSound
extends Thread {
    private String filename;
    private final int EXTERNAL_BUFFER_SIZE = 524288;
    private boolean stop = false;
    private SourceDataLine auline = null;
    private boolean isFinished = true;

    public TInterpreterWavSound(String wavfile) {
        this.filename = wavfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        File soundFile = new File(this.filename);
        if (!soundFile.exists()) {
            System.err.println("Wave file not found: " + this.filename);
            return;
        }
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        AudioFormat format = audioInputStream.getFormat();
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.auline = (SourceDataLine)AudioSystem.getLine(info);
            this.auline.open(format);
        }
        catch (LineUnavailableException e2) {
            e2.printStackTrace();
            return;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return;
        }
        if (this.auline.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl e3 = (FloatControl)this.auline.getControl(FloatControl.Type.PAN);
        }
        this.auline.start();
        this.isFinished = false;
        int nBytesRead = 0;
        byte[] abData = new byte[524288];
        try {
            try {
                while (nBytesRead != -1) {
                    if (this.stop) {
                        return;
                    }
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                    if (nBytesRead < 0) continue;
                    this.auline.write(abData, 0, nBytesRead);
                }
                return;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                this.auline.drain();
                this.auline.close();
                this.isFinished = true;
                return;
            }
        }
        finally {
            this.auline.drain();
            this.auline.close();
            this.isFinished = true;
        }
    }

    public void TStop() {
        this.stop = true;
        if (this.auline != null) {
            this.auline.stop();
        }
        this.isFinished = true;
    }

    public boolean TIsFinished() {
        return this.isFinished;
    }
}

