/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.threads;

import de.humatic.dsj.DSFiltergraph;
import de.humatic.dsj.DSJException;
import de.humatic.dsj.DSJUtils;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.UIManager;
import tico.components.resources.TResourceManager;
import tico.interpreter.TInterpreter;
import tico.interpreter.listeners.TVideoListener;

public class TInterpreterVideo
extends JDialog
implements PropertyChangeListener {
    private DSFiltergraph moviePanel;
    private static boolean ini = false;
    private boolean running = true;
    private JAudioPlayer audioPlayer;
    private int xVideo;
    private int yVideo;
    private int widthVideo;
    private int heightVideo;

    static {
        try {
            if (!ini) {
                System.loadLibrary("libs/dsj");
                System.out.println("Video DLL loaded correctly");
                ini = true;
            }
        }
        catch (UnsatisfiedLinkError e2) {
            e2.printStackTrace();
            System.out.println("Video DLL not loaded");
        }
    }

    public TInterpreterVideo(String videoLocation, int x2, int y2, int width, int height, TInterpreter interprete) {
        super(interprete);
        this.setUndecorated(true);
        this.xVideo = x2;
        this.yVideo = y2;
        this.widthVideo = width;
        this.heightVideo = height;
        this.setModal(true);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.pack();
        this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0), (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0));
        this.toFront();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                TInterpreterVideo.this.running = false;
                try {
                    if (TInterpreterVideo.this.audioPlayer != null) {
                        TInterpreterVideo.this.audioPlayer.close();
                        TInterpreterVideo.this.audioPlayer = null;
                        TInterpreterVideo.this.dispose();
                    }
                    if (TInterpreterVideo.this.moviePanel != null) {
                        TInterpreterVideo.this.moviePanel.dispose();
                        TInterpreterVideo.this.moviePanel = null;
                        TInterpreterVideo.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.loadMovie(videoLocation, 0);
    }

    private void loadMovie(String path, int flags) {
        this.running = false;
        if (this.moviePanel != null) {
            this.moviePanel.dispose();
            if (this.audioPlayer != null) {
                this.audioPlayer.close();
                this.audioPlayer = null;
            }
        }
        try {
            this.moviePanel = DSFiltergraph.createDSFiltergraph(path, flags, this);
            this.moviePanel.addMouseListener(new TVideoListener(this, this.running, this.audioPlayer, this.moviePanel));
            DSFiltergraph.DSAudioStream audioStream = this.moviePanel.getAudioStream();
            if (audioStream != null) {
                this.audioPlayer = new JAudioPlayer(audioStream);
            }
        }
        catch (DSJException e2) {
            System.err.println("El video no se puede reproducir");
            System.out.println("\n" + e2.toString() + "  " + e2.getErrorCode());
            this.moviePanel = null;
            this.pack();
            return;
        }
        this.initDisplay();
        if (this.audioPlayer != null) {
            this.audioPlayer.start();
        }
        this.setVisible(true);
    }

    private void initDisplay() {
        try {
            this.add("Center", this.moviePanel.asComponent());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.pack();
        this.setLocation(this.xVideo + 5, this.yVideo + 54);
        this.setSize(this.widthVideo, this.heightVideo);
        this.running = true;
        this.toFront();
        ImageIcon icon = TResourceManager.getImageIcon("transparent.png");
        Image imageCursor = icon.getImage();
        Cursor customCursor = this.getToolkit().createCustomCursor(imageCursor, new Point(), "MyCursor");
        this.setCursor(customCursor);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pe) {
        switch (DSJUtils.getEventType(pe)) {
            case 0: {
                System.out.print(".");
                break;
            }
            case 20: {
                System.out.println("Evento de rat\u00f3n");
                break;
            }
            case 9: {
                try {
                    if (this.audioPlayer != null) {
                        this.audioPlayer.close();
                        this.audioPlayer = null;
                        this.dispose();
                    }
                    if (this.moviePanel == null) break;
                    this.moviePanel.dispose();
                    this.moviePanel = null;
                    this.dispose();
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public class JAudioPlayer
    extends Thread {
        private AudioInputStream audioInputStrem;
        private AudioFormat format;
        private SourceDataLine sourceDataLine;
        private int bufferSize;
        private DataLine.Info info;

        private JAudioPlayer(DSFiltergraph.DSAudioStream dsAudio) {
            try {
                this.format = dsAudio.getFormat();
                this.bufferSize = dsAudio.getBufferSize();
                this.audioInputStrem = new AudioInputStream(dsAudio, this.format, -1L);
                this.info = new DataLine.Info(SourceDataLine.class, this.format);
                if (!AudioSystem.isLineSupported(this.info)) {
                    System.out.println("Line matching " + this.info + " not supported.");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(this.info);
                this.sourceDataLine.open(this.format, this.bufferSize);
                this.sourceDataLine.start();
            }
            catch (LineUnavailableException ex) {
                System.out.println("Unable to open the line: " + ex);
                return;
            }
            try {
                byte[] data = new byte[this.bufferSize];
                int numBytesRead = 0;
                int written = 0;
                while (TInterpreterVideo.this.running) {
                    try {
                        numBytesRead = this.audioInputStrem.read(data);
                        if (numBytesRead == -1) break;
                        int numBytesRemaining = numBytesRead;
                        while (numBytesRemaining > 0) {
                            written = this.sourceDataLine.write(data, 0, numBytesRemaining);
                            numBytesRemaining -= written;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ae2) {
                        this.bufferSize = numBytesRead;
                        data = new byte[this.bufferSize];
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        System.out.println("Error during playback: " + e2);
                        break;
                    }
                }
                this.sourceDataLine.stop();
                this.sourceDataLine.flush();
                this.sourceDataLine.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void close() {
            try {
                TInterpreterVideo.this.running = false;
                JAudioPlayer.sleep(500L);
                this.audioInputStrem.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

