/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.threads;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.speech.Central;
import javax.speech.EngineList;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.Voice;

public class TInterpreterTTS
implements Runnable {
    private HashMap<String, Synthesizer> synths = new HashMap();
    private String voiceName;
    private String text;
    private static TInterpreterTTS instance = null;

    private TInterpreterTTS() {
    }

    public static TInterpreterTTS getInstance() {
        if (instance == null) {
            instance = new TInterpreterTTS();
        }
        return instance;
    }

    public void addVoiceByName(String voice) {
        EngineList list = Central.availableSynthesizers(null);
        SynthesizerModeDesc desc = null;
        Voice v2 = null;
        SynthesizerModeDesc d2 = null;
        Boolean found = false;
        int i2 = 0;
        while (i2 < list.size() && !found.booleanValue()) {
            desc = (SynthesizerModeDesc)list.elementAt(i2);
            Voice[] voices = desc.getVoices();
            int j2 = 0;
            while (j2 < voices.length && !found.booleanValue()) {
                if (voices[j2].getName().indexOf(voice) > -1) {
                    v2 = voices[j2];
                    d2 = desc;
                    found = true;
                }
                ++j2;
            }
            ++i2;
        }
        try {
            Synthesizer synth = Central.createSynthesizer(d2);
            synth.allocate();
            synth.resume();
            synth.waitEngineState(4L);
            SynthesizerProperties props = synth.getSynthesizerProperties();
            props.setVoice(v2);
            this.synths.put(voice, synth);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentVoiceAndText(String voiceName, String text) {
        this.voiceName = voiceName;
        this.text = text;
    }

    @Override
    public void run() {
        Synthesizer synth = this.synths.get(this.voiceName);
        try {
            synth.speak("", null);
            synth.waitEngineState(65536L);
            synth.speak(this.text, null);
            synth.waitEngineState(65536L);
        }
        catch (Exception ex) {
            Logger.getLogger(TInterpreterTTS.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unload() {
        for (Synthesizer synth : this.synths.values()) {
            try {
                synth.deallocate();
                synth.waitEngineState(1L);
            }
            catch (Exception ex) {
                Logger.getLogger(TInterpreterTTS.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

