/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.threads;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class TInterpreterMidSound
extends Thread {
    private String filename;
    private static Sequencer sequencer;
    private static Sequence sequence;

    public TInterpreterMidSound(String midfile) {
        this.filename = midfile;
    }

    @Override
    public void run() {
        File soundFile = new File(this.filename);
        if (!soundFile.exists()) {
            System.err.println("Midi file not found: " + this.filename);
            return;
        }
        try {
            sequence = MidiSystem.getSequence(soundFile);
            sequencer = MidiSystem.getSequencer();
            sequencer.open();
            sequencer.setSequence(sequence);
            sequencer.start();
            TInterpreterMidSound.sleep((long)Math.ceil(sequence.getMicrosecondLength() / 1000L));
            sequencer.close();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
            return;
        }
        catch (InvalidMidiDataException e1) {
            e1.printStackTrace();
            return;
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
            return;
        }
    }

    public void TStop() {
        if (sequencer.isRunning()) {
            sequencer.stop();
        }
        super.stop();
    }
}

