/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.threads;

import java.io.File;
import tico.components.resources.TFileUtils;
import tico.editor.TFileHandler;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.threads.TInterpreterMidSound;
import tico.interpreter.threads.TInterpreterMp3Sound;
import tico.interpreter.threads.TInterpreterWavSound;

public class TInterpreterBoardSound
implements Runnable {
    private String filePath;

    public TInterpreterBoardSound(String soundFile) {
        this.filePath = soundFile;
    }

    @Override
    public void run() {
        try {
            TInterpreterConstants.semaforo.acquire();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        String extension = TFileUtils.getExtension(this.filePath);
        if (extension.equals("mp3")) {
            TInterpreterConstants.audioMp3 = new TInterpreterMp3Sound(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + this.filePath);
            TInterpreterConstants.audioMp3.TPlay();
            TInterpreterConstants.audioMp3.TJoin();
        } else if (extension.equals("mid") || extension.equals("midi")) {
            TInterpreterConstants.audioMid = new TInterpreterMidSound(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + this.filePath);
            TInterpreterConstants.audioMid.start();
            try {
                TInterpreterConstants.audioMid.join();
            }
            catch (InterruptedException e3) {
                e3.printStackTrace();
                System.err.println("Error al reproducir el sonido del tablero");
            }
        } else {
            TInterpreterConstants.audio = new TInterpreterWavSound(String.valueOf(TFileHandler.getCurrentDirectoryPath()) + File.separator + this.filePath);
            TInterpreterConstants.audio.start();
            try {
                TInterpreterConstants.audio.join();
            }
            catch (InterruptedException e4) {
                e4.printStackTrace();
                System.err.println("Error al reproducir el sonido del tablero");
            }
        }
        try {
            TInterpreterConstants.semaforo.release();
        }
        catch (InterruptedException e5) {
            e5.printStackTrace();
        }
    }
}

