/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.listeners;

import de.humatic.dsj.DSFiltergraph;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import tico.components.resources.TResourceManager;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.threads.TInterpreterVideo;

public class TVideoListener
implements MouseListener {
    private TInterpreterVideo videoWindowListener;
    Boolean running;
    private DSFiltergraph moviePanel;
    private TInterpreterVideo.JAudioPlayer audioPlayer;

    public TVideoListener(TInterpreterVideo videoWindow, Boolean runningVideo, TInterpreterVideo.JAudioPlayer audioPlayerVideo, DSFiltergraph moviePanelVideo) {
        this.videoWindowListener = videoWindow;
        this.running = runningVideo;
        this.audioPlayer = audioPlayerVideo;
        this.moviePanel = moviePanelVideo;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        ImageIcon icon = TResourceManager.getImageIcon("transparent.png");
        Image imageCursor = icon.getImage();
        Cursor customCursor = this.videoWindowListener.getToolkit().createCustomCursor(imageCursor, new Point(), "MyCursor");
        this.videoWindowListener.setCursor(customCursor);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        ImageIcon icon = null;
        icon = TInterpreterConstants.interpreterCursor == null ? TResourceManager.getImageIcon("flecha2.png") : new ImageIcon(TInterpreterConstants.interpreterCursor);
        Image imageCursor = icon.getImage();
        Cursor customCursor = this.videoWindowListener.getToolkit().createCustomCursor(imageCursor, new Point(), "MyCursor");
        this.videoWindowListener.setCursor(customCursor);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.running = false;
        try {
            if (this.audioPlayer != null) {
                this.audioPlayer.close();
                this.audioPlayer = null;
                this.videoWindowListener.dispose();
            }
            if (this.moviePanel != null) {
                this.moviePanel.dispose();
                this.moviePanel = null;
                this.videoWindowListener.dispose();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

