/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.listeners;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.border.LineBorder;
import tico.components.resources.TFileUtils;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.actions.TInterpreterExitAction;
import tico.interpreter.components.TInterpreterCell;
import tico.interpreter.threads.TInterpreterMidSound;
import tico.interpreter.threads.TInterpreterMp3Sound;
import tico.interpreter.threads.TInterpreterWavSound;

public class TExitCellListener
implements MouseListener {
    TInterpreter interpreter = TInterpreterConstants.interpreter;

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            if (arg0.getButton() == 3) {
                TInterpreter.boardListener.mouseClicked(arg0);
            } else {
                TInterpreter.run = 0;
                TInterpreterExitAction exit = new TInterpreterExitAction(this.interpreter);
                exit.actionPerformed(null);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            TInterpreterCell controllerCellButton = (TInterpreterCell)arg0.getSource();
            LineBorder thickBorder = new LineBorder(TInterpreterConstants.SELECTED_BORDER_COLOR, 4);
            controllerCellButton.setBorder(thickBorder);
            if (controllerCellButton.getAlternativeSoundPath() != null && !TInterpreter.returnMouseMode().equals("directSelectionMode")) {
                String extension = TFileUtils.getExtension(controllerCellButton.getAlternativeSoundPath());
                if (extension.equals("mp3")) {
                    TInterpreterConstants.audioMp3 = new TInterpreterMp3Sound(controllerCellButton.getAlternativeSoundPath());
                    TInterpreterConstants.audioMp3.TPlay();
                } else if (extension.equals("mid") || extension.equals("midi")) {
                    TInterpreterConstants.audioMid = new TInterpreterMidSound(controllerCellButton.getAlternativeSoundPath());
                    TInterpreterConstants.audioMid.start();
                } else {
                    TInterpreterConstants.audio = new TInterpreterWavSound(controllerCellButton.getAlternativeSoundPath());
                    TInterpreterConstants.audio.start();
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            TInterpreterCell controllerCellButton = (TInterpreterCell)arg0.getSource();
            LineBorder thickBorder = new LineBorder(TInterpreterConstants.BORDER_COLOR, 1);
            controllerCellButton.setBorder(thickBorder);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

