/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.listeners;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.border.LineBorder;
import tico.components.resources.TFileUtils;
import tico.configuration.TSetup;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterConstants;
import tico.interpreter.components.TInterpreterAccumulatedCell;
import tico.interpreter.components.TInterpreterCell;
import tico.interpreter.components.TInterpreterTextArea;
import tico.interpreter.threads.TInterpreterGoogleTTS;
import tico.interpreter.threads.TInterpreterMidSound;
import tico.interpreter.threads.TInterpreterMp3Sound;
import tico.interpreter.threads.TInterpreterTTS;
import tico.interpreter.threads.TInterpreterVideo;
import tico.interpreter.threads.TInterpreterWavSound;

public class TCellListener
implements MouseListener {
    TInterpreterCell cell;
    TInterpreter interpreter;

    public TCellListener(TInterpreterCell c2) {
        this.cell = c2;
        this.interpreter = TInterpreterConstants.interpreter;
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            if (arg0.getButton() == 3) {
                if (TInterpreter.returnMouseMode().equals("manualScanningMode")) {
                    TInterpreter.boardListener.click();
                }
            } else {
                TInterpreterTextArea textArea;
                TInterpreterCell cell = (TInterpreterCell)arg0.getSource();
                if (TInterpreter.returnMouseMode().equals("automaticScanningMode")) {
                    try {
                        TInterpreterConstants.semaforo.acquire();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                if (cell.isAccumulated() && TInterpreter.accumulatedCellsList.size() < TInterpreterConstants.accumulatedCells) {
                    TInterpreterAccumulatedCell accumulatedCell = new TInterpreterAccumulatedCell();
                    accumulatedCell.setAttributes(cell);
                    TInterpreter.accumulatedCellsList.add(accumulatedCell);
                    TInterpreter.accumulatedCells.add(accumulatedCell);
                    TInterpreter.accumulatedCells.updateUI();
                }
                if (TInterpreterConstants.audioMp3 != null && !TInterpreterConstants.audioMp3.TIsFinished()) {
                    TInterpreterConstants.audioMp3.TStop();
                    TInterpreterConstants.audioMp3 = null;
                } else if (TInterpreterConstants.audio != null && !TInterpreterConstants.audio.TIsFinished()) {
                    TInterpreterConstants.audio.TStop();
                    TInterpreterConstants.audio = null;
                }
                if (TInterpreterConstants.audio != null && TInterpreterConstants.audio.TIsFinished() || TInterpreterConstants.audioMp3 != null && TInterpreterConstants.audioMp3.TIsFinished()) {
                    TInterpreterConstants.audioOrigin = null;
                    TInterpreterConstants.audio = null;
                    TInterpreterConstants.audioMp3 = null;
                }
                if (TInterpreterConstants.audioOrigin != this.cell && cell.getSoundPath() != null) {
                    String extension = TFileUtils.getExtension(cell.getSoundPath());
                    if (extension.equals("mp3")) {
                        if (TInterpreterConstants.audioMp3 == null || TInterpreterConstants.audioMp3.TIsFinished()) {
                            TInterpreterConstants.audioMp3 = new TInterpreterMp3Sound(cell.getSoundPath());
                            TInterpreterConstants.audioMp3.TPlay();
                        }
                    } else if (extension.equals("mid") || extension.equals("midi")) {
                        TInterpreterConstants.audioMid = new TInterpreterMidSound(cell.getSoundPath());
                        TInterpreterConstants.audioMid.start();
                        try {
                            TInterpreterConstants.audioMid.join();
                        }
                        catch (InterruptedException e3) {
                            e3.printStackTrace();
                            System.out.println("Error al reproducir el sonido de la celda");
                        }
                    } else if (TInterpreterConstants.audio == null || TInterpreterConstants.audio.TIsFinished()) {
                        TInterpreterConstants.audio = new TInterpreterWavSound(cell.getSoundPath());
                        TInterpreterConstants.audio.start();
                        try {
                            TInterpreterConstants.audio.join();
                        }
                        catch (InterruptedException e4) {
                            e4.printStackTrace();
                            System.out.println("Error al reproducir el sonido de la celda");
                        }
                    }
                    TInterpreterConstants.audioOrigin = this.cell;
                }
                if (TInterpreterConstants.audioMp3 == null && TInterpreterConstants.audio == null) {
                    TInterpreterConstants.audioOrigin = null;
                }
                if (TInterpreterConstants.operatingSystem == "windows") {
                    TInterpreterVideo e4;
                    Point point;
                    if (cell.getVideoPath() != null) {
                        point = cell.getLocationOnScreen();
                        cell.setXVideo(point.x - 5);
                        cell.setYVideo(point.y - 54);
                        try {
                            e4 = new TInterpreterVideo(cell.getVideoPath(), cell.getXVideo(), cell.getYVideo(), cell.getWidth(), cell.getHeight(), this.interpreter);
                        }
                        catch (Exception e5) {
                            e5.printStackTrace();
                        }
                    }
                    if (cell.getVideoURL() != null) {
                        point = cell.getLocationOnScreen();
                        cell.setXVideo(point.x - 5);
                        cell.setYVideo(point.y - 54);
                        try {
                            e4 = new TInterpreterVideo(cell.getVideoURL(), cell.getXVideo(), cell.getYVideo(), cell.getWidth(), cell.getHeight(), this.interpreter);
                        }
                        catch (Exception e6) {
                            e6.printStackTrace();
                        }
                    }
                }
                if (cell.getTextAreaToSend() != null && (textArea = TInterpreter.getCurrentBoard().getTextAreaByName(cell.getTextAreaToSend())) != null) {
                    String originalText = textArea.getText();
                    textArea.setText(String.valueOf(originalText) + cell.getTextToSend());
                    TInterpreter.interpretArea.paintImmediately(0, 0, TInterpreter.interpretArea.getWidth(), TInterpreter.interpretArea.getHeight());
                    waiting w2 = new waiting(cell.getTimeSending());
                    w2.start();
                    try {
                        w2.join();
                    }
                    catch (InterruptedException e7) {
                        e7.printStackTrace();
                    }
                    textArea.setText(originalText);
                    TInterpreter.interpretArea.removeAll();
                    TInterpreter.getCurrentBoard().paintBoard(TInterpreter.interpretArea, false);
                    TInterpreter.interpretArea.repaint();
                }
                if (cell.getBoardToGo() != null) {
                    TInterpreterConstants.currentBoard = this.interpreter.getProject().getBoard(cell.getBoardToGo());
                    TInterpreterConstants.countRun = 0;
                    TInterpreterConstants.boardOrderedCells = TInterpreterConstants.currentBoard.getOrderedCellListNames();
                    this.interpreter.getProject().setPositionCellToReturn(0);
                    this.interpreter.getProject().setBoardToReturn(this.interpreter.getProject().getCurrentBoard());
                    this.interpreter.getProject().setCellToReturn(((TInterpreterCell)arg0.getSource()).getName());
                    this.interpreter.getProject().getPositionCellToReturnByName(this.interpreter.getProject().getBoardToReturn(), this.interpreter.getProject().getCellToReturn());
                    this.interpreter.repaintCurrentBoard(false);
                    this.interpreter.changeBoard(cell.getBoardToGo());
                    this.interpreter.getProject().setBoardChanged(true);
                    this.interpreter.getProject().setBoardToGo(cell.getBoardToGo());
                    this.interpreter.getProject().setCurrentBoard(cell.getBoardToGo());
                    if (TInterpreter.returnMouseMode().equals("manualScanningMode")) {
                        TInterpreter.boardListener.click();
                    }
                }
                if (cell.getCommand() != null) {
                    try {
                        Process p2 = Runtime.getRuntime().exec(cell.getCommand());
                        try {
                            p2.waitFor();
                        }
                        catch (InterruptedException e8) {
                            e8.printStackTrace();
                        }
                    }
                    catch (IOException e9) {
                        e9.printStackTrace();
                        System.out.println(e9.getCause());
                    }
                }
                if (cell.getVoiceText() != null) {
                    String OS = System.getProperty("os.name");
                    if (cell.getSynthMode() == 0) {
                        String voiceLang = TSetup.getLanguageCode();
                        TInterpreterGoogleTTS ttsg = new TInterpreterGoogleTTS();
                        ttsg.setCurrentVoiceAndText(voiceLang, cell.getVoiceText());
                        ttsg.run();
                    } else if (cell.getSynthMode() == 1 && OS.startsWith("Windows")) {
                        String voice = cell.getVoiceName();
                        if (voice == null) {
                            voice = this.interpreter.getIntepreterProject().getDefaultVoiceName();
                        }
                        TInterpreterTTS tts = TInterpreterTTS.getInstance();
                        tts.setCurrentVoiceAndText(voice, cell.getVoiceText());
                        tts.run();
                    }
                }
                if (TInterpreter.returnMouseMode().equals("automaticScanningMode")) {
                    try {
                        TInterpreterConstants.semaforo.release();
                    }
                    catch (InterruptedException e10) {
                        e10.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            TInterpreterCell cell = (TInterpreterCell)arg0.getSource();
            Color colorLine = Color.red;
            int widthLine = 1;
            if (cell.getAlternativeIcon() != null) {
                cell.setIcon(cell.getAlternativeIcon());
            }
            if (cell.getAlternativeBorderSize() != 0) {
                cell.setBorderPainted(true);
                colorLine = cell.getAlternativeBorderColor();
                widthLine = cell.getAlternativeBorderSize();
            }
            LineBorder thickBorder = new LineBorder(colorLine, widthLine);
            cell.setBorder(thickBorder);
            if (cell.getAlternativeSoundPath() != null && !TInterpreter.returnMouseMode().equals("directSelectionMode")) {
                String extension = TFileUtils.getExtension(cell.getAlternativeSoundPath());
                if (extension.equals("mp3")) {
                    TInterpreterConstants.audioMp3 = new TInterpreterMp3Sound(cell.getAlternativeSoundPath());
                    TInterpreterConstants.audioMp3.TPlay();
                    TInterpreterConstants.audioMp3.TJoin();
                } else if (extension.equals("mid") || extension.equals("midi")) {
                    TInterpreterConstants.audioMid = new TInterpreterMidSound(cell.getAlternativeSoundPath());
                    TInterpreterConstants.audioMid.start();
                } else {
                    TInterpreterConstants.audio = new TInterpreterWavSound(cell.getAlternativeSoundPath());
                    TInterpreterConstants.audio.start();
                    try {
                        TInterpreterConstants.audio.join();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                        System.out.println("Error al reproducir el sonido de la celda");
                    }
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        if (TInterpreter.run == 1) {
            TInterpreterCell cell = (TInterpreterCell)arg0.getSource();
            cell.setIcon(cell.getDefaultIcon());
            if (cell.isTransparentBorder()) {
                cell.setBorderPainted(false);
            } else {
                cell.setBorder(new LineBorder(cell.getBorderColor(), (int)cell.getBorderSize()));
            }
            if (cell.isTransparentBackground()) {
                cell.setFocusPainted(false);
                cell.setContentAreaFilled(false);
            } else if (cell.getBackground() != null) {
                cell.setFocusPainted(true);
                cell.setBackground(cell.getBackground());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    class waiting
    extends Thread {
        private int secs;

        public waiting(int segundos) {
            this.secs = segundos;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.secs * 1000);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }
}

