/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import tico.components.TButton;
import tico.components.TDialog;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreter;

public abstract class TProjectInterpreterDialog
extends TDialog {
    private JPanel mainPanel;
    private TInterpreter interpreter;

    public TProjectInterpreterDialog(TInterpreter interpreter) {
        super((Frame)interpreter, true);
        this.interpreter = interpreter;
        this.setDefaultCloseOperation(2);
        this.createPanels();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.interpreter);
        super.setVisible(visible);
    }

    private void createPanels() {
        this.mainPanel = new JPanel();
        JPanel buttonPanel = this.createButtonPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "North");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        TButton accept = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_ACCEPT"));
        accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (TProjectInterpreterDialog.this.applyValues()) {
                    TProjectInterpreterDialog.this.dispose();
                }
            }
        });
        buttonPanel.add(accept);
        TButton apply = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_APPLY"));
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TProjectInterpreterDialog.this.applyValues();
            }
        });
        buttonPanel.add(apply);
        TButton cancel = new TButton(TLanguage.getString("TPropertiesDialog.BUTTON_CANCEL"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TProjectInterpreterDialog.this.dispose();
            }
        });
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    protected TInterpreter getInterpreter() {
        return this.interpreter;
    }

    public JPanel getPropertiesPane() {
        return this.mainPanel;
    }

    protected abstract boolean applyValues();
}

