/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tico.components.TButton;
import tico.components.TDialog;
import tico.components.TImageChooser;
import tico.configuration.TLanguage;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterConstants;

public class TInterpreterOptionsDialog
extends TDialog {
    TImageChooser cursorPanel;
    JPanel panelButtons;
    JPanel speedPanel;
    JPanel cellPanel;
    JPanel mouseModePanel;
    public static int value;
    JSpinner spinner;
    SpinnerNumberModel model;

    private void createCursorPanel() {
        this.cursorPanel = new TImageChooser(TLanguage.getString("TInterpreterOptionDialog.CURSOR_IMAGE"));
        if (TInterpreterConstants.interpreterCursor != null) {
            ImageIcon cursorIcon = new ImageIcon(TInterpreterConstants.interpreterCursor);
            this.cursorPanel.setIcon(cursorIcon);
        }
    }

    private void createButtonPanel() {
        this.panelButtons = new JPanel();
        TButton AcceptButton = new TButton(TLanguage.getString("TInterpreterOptionDialog.BUTTON_ACCEPT"));
        AcceptButton.setFocusable(true);
        TButton CancelButton = new TButton(TLanguage.getString("TInterpreterOptionDialog.BUTTON_CANCEL"));
        AcceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TInterpreterOptionsDialog.this.Accept_ActionPerformed(e2);
            }
        });
        CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TInterpreterOptionsDialog.this.Cancel_ActionPerformed(e2);
            }
        });
        this.panelButtons.add(AcceptButton);
        this.panelButtons.add(CancelButton);
    }

    private void createSpeedPanel() {
        this.speedPanel = new JPanel();
        this.speedPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TInterpreterOptionDialog.WAIT_CURSOR")));
        JSlider gros = new JSlider(0, 1000, 20000, TInterpreterConstants.interpreterDelay);
        value = gros.getValue();
        gros.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                JSlider source = (JSlider)e2.getSource();
                if (!source.getValueIsAdjusting()) {
                    value = source.getValue();
                }
            }
        });
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        ((Dictionary)labelTable).put(new Integer(1000), new JLabel("1"));
        ((Dictionary)labelTable).put(new Integer(10000), new JLabel("10"));
        ((Dictionary)labelTable).put(new Integer(20000), new JLabel("20"));
        gros.setLabelTable(labelTable);
        gros.setMinorTickSpacing(1000);
        gros.setPaintTicks(true);
        gros.setPaintLabels(true);
        this.speedPanel.add(gros);
    }

    private void createNumCellsPanel() {
        this.cellPanel = new JPanel(new FlowLayout(0));
        this.cellPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), ""));
        JLabel text = new JLabel(TLanguage.getString("TInterpreterOptionDialog.MAX_ACCUMULATED_CELLS"));
        this.cellPanel.add(text);
        this.model = new SpinnerNumberModel(TInterpreterConstants.accumulatedCells, 0, TInterpreterConstants.maxAccumulatedCells, 1);
        this.spinner = new JSpinner(this.model);
        this.cellPanel.add(this.spinner);
    }

    private void createMouseModePanel() {
        this.mouseModePanel = new JPanel();
        this.mouseModePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.WHITE, new Color(165, 163, 151)), TLanguage.getString("TInterpreterOptionDialog.MOUSE_MODE")));
        JRadioButton automaticScanningMode = new JRadioButton(TLanguage.getString("TInterpreterMouseMode.AUTOMATIC_SCANNING"));
        automaticScanningMode.setActionCommand("automaticScanningMode");
        automaticScanningMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TInterpreterConstants.mouseModeSelected = "automaticScanningMode";
            }
        });
        if (TInterpreterConstants.mouseModeSelected.equals("automaticScanningMode")) {
            automaticScanningMode.setSelected(true);
        }
        JRadioButton directSelectionMode = new JRadioButton(TLanguage.getString("TInterpreterMouseMode.DIRECT_SELECTION"));
        directSelectionMode.setActionCommand("directSelectionMode");
        directSelectionMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TInterpreterConstants.mouseModeSelected = "directSelectionMode";
            }
        });
        if (TInterpreterConstants.mouseModeSelected.equals("directSelectionMode")) {
            directSelectionMode.setSelected(true);
        }
        JRadioButton manualScanningMode = new JRadioButton(TLanguage.getString("TInterpreterMouseMode.MANUAL_SCANNING"));
        manualScanningMode.setActionCommand("manualScanningMode");
        manualScanningMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TInterpreterConstants.mouseModeSelected = "manualScanningMode";
            }
        });
        if (TInterpreterConstants.mouseModeSelected.equals("manualScanningMode")) {
            manualScanningMode.setSelected(true);
        }
        ButtonGroup mouseModeOptions = new ButtonGroup();
        mouseModeOptions.add(directSelectionMode);
        mouseModeOptions.add(automaticScanningMode);
        mouseModeOptions.add(manualScanningMode);
        this.mouseModePanel.add(directSelectionMode);
        this.mouseModePanel.add(automaticScanningMode);
        this.mouseModePanel.add(manualScanningMode);
    }

    public TInterpreterOptionsDialog(TInterpreter interprete) {
        super(interprete, TLanguage.getString("TInterpreterOptionDialog.NAME"), true);
        JPanel backPanel = new JPanel();
        this.createCursorPanel();
        this.createButtonPanel();
        this.createSpeedPanel();
        this.createNumCellsPanel();
        this.createMouseModePanel();
        GridBagConstraints c2 = new GridBagConstraints();
        backPanel.setLayout(new GridBagLayout());
        c2.fill = 2;
        c2.insets = new Insets(5, 20, 0, 20);
        c2.gridx = 0;
        c2.gridy = 0;
        backPanel.add((Component)this.cursorPanel, c2);
        c2.gridx = 0;
        c2.gridy = 1;
        backPanel.add((Component)this.cellPanel, c2);
        c2.gridx = 0;
        c2.gridy = 2;
        backPanel.add((Component)this.speedPanel, c2);
        c2.gridx = 0;
        c2.gridy = 3;
        backPanel.add((Component)this.mouseModePanel, c2);
        c2.gridx = 0;
        c2.gridy = 4;
        backPanel.add((Component)this.panelButtons, c2);
        this.setBounds(100, 100, 380, 380);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setContentPane(backPanel);
        this.pack();
        this.setVisible(true);
    }

    public void Accept_ActionPerformed(ActionEvent e2) {
        TInterpreterConstants.interpreterCursor = TImageChooser.path != null ? TImageChooser.path : (this.cursorPanel.getImageGalleryButton().getPath() != null ? this.cursorPanel.getImageGalleryButton().getPath() : null);
        TInterpreterConstants.interpreterDelay = value;
        TInterpreterConstants.accumulatedCells = this.model.getNumber().intValue();
        this.setVisible(false);
    }

    public void Cancel_ActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }
}

