/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;

public class TInterpreterRoundRectangle
extends JButton {
    Color borderColorRoundRectangle;
    Color backgroundColorRoundRectangle;
    Color gradientColorRoundRectangle;
    int borderSizeRoundRectangle;
    int widthRoundRectangle;
    int heightRoundRectangle;
    boolean transparentBackgroundRoundRectangle;

    public TInterpreterRoundRectangle(Color borderColor, Color backgroundColor, Color gradientColor, float borderSize, Rectangle bounds, boolean transparentBackground) {
        this.borderColorRoundRectangle = borderColor;
        this.backgroundColorRoundRectangle = backgroundColor;
        this.gradientColorRoundRectangle = gradientColor;
        this.borderSizeRoundRectangle = (int)borderSize;
        this.widthRoundRectangle = bounds.width;
        this.heightRoundRectangle = bounds.height;
        this.transparentBackgroundRoundRectangle = transparentBackground;
        this.setLocation(bounds.x, bounds.y);
        this.setSize(bounds.width, bounds.height);
        this.setEnabled(false);
        this.setContentAreaFilled(false);
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Dimension dimension = this.getSize();
        int roundRectArc = TInterpreterRoundRectangle.getArcSize(dimension.width - this.borderSizeRoundRectangle, dimension.height - this.borderSizeRoundRectangle);
        if (!this.transparentBackgroundRoundRectangle) {
            g2.setColor(this.backgroundColorRoundRectangle);
            if (this.gradientColorRoundRectangle != null) {
                this.setOpaque(false);
                g22.setPaint(new GradientPaint(0.0f, 0.0f, this.backgroundColorRoundRectangle, this.getWidth(), this.getHeight(), this.gradientColorRoundRectangle, true));
            }
            g2.fillRoundRect(this.borderSizeRoundRectangle - 1, this.borderSizeRoundRectangle - 1, dimension.width - 2 * this.borderSizeRoundRectangle, dimension.height - 2 * this.borderSizeRoundRectangle, roundRectArc, roundRectArc);
        }
        this.setBorder(null);
        this.setOpaque(false);
        super.paint(g2);
        if (this.borderColorRoundRectangle != null) {
            g2.setColor(this.borderColorRoundRectangle);
            g22.setStroke(new BasicStroke(this.borderSizeRoundRectangle));
            g2.drawRoundRect(this.borderSizeRoundRectangle - 1, this.borderSizeRoundRectangle - 1, dimension.width - 2 * this.borderSizeRoundRectangle, dimension.height - 2 * this.borderSizeRoundRectangle, roundRectArc, roundRectArc);
        } else if (this.gradientColorRoundRectangle != null) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.backgroundColorRoundRectangle, this.getWidth(), this.getHeight(), this.gradientColorRoundRectangle, true));
            g2.fillRoundRect(0, 0, dimension.width, dimension.height, roundRectArc, roundRectArc);
        } else {
            g2.setColor(this.backgroundColorRoundRectangle);
            g2.fillRoundRect(0, 0, dimension.width, dimension.height, roundRectArc, roundRectArc);
        }
    }

    public static int getArcSize(int width, int height) {
        int arcSize;
        if (width <= height) {
            arcSize = height / 5;
            if (arcSize > width / 2) {
                arcSize = width / 2;
            }
        } else {
            arcSize = width / 5;
            if (arcSize > height / 2) {
                arcSize = height / 2;
            }
        }
        return arcSize;
    }
}

