/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;

public class TInterpreterLabel
extends JLabel {
    boolean transparentBackgroundLabel;
    Color gradientColorLabel;
    private static final int HORIZONTAL_MARGIN = 10;

    public TInterpreterLabel setAttributes(Color borderColor, float borderSize, Color backgroundColor, Color gradientColor, Rectangle r2, String text, Font font, Color textColor, boolean transparentBackground) {
        this.transparentBackgroundLabel = transparentBackground;
        this.gradientColorLabel = gradientColor;
        this.setLocation(r2.x, r2.y);
        this.setSize(r2.width, r2.height);
        if (backgroundColor != null) {
            this.setOpaque(true);
            this.setBackground(backgroundColor);
        }
        this.setBorder(null);
        if (borderColor != null) {
            this.setBorder(new LineBorder(borderColor, (int)borderSize));
        }
        this.setForeground(textColor);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setFont(font);
        this.setText(text);
        int cellTextSpace = (int)((float)r2.width - 2.0f * borderSize - 20.0f);
        JButton j2 = new JButton();
        j2.setSize(cellTextSpace, cellTextSpace);
        FontMetrics fm = j2.getFontMetrics(font);
        int textWidth = fm.stringWidth(text);
        if (textWidth > cellTextSpace) {
            int fontSize = font.getSize();
            int fontStyle = font.getStyle();
            String fontName = font.getFontName();
            while (textWidth > cellTextSpace && fontSize > 0) {
                font = new Font(fontName, fontStyle, --fontSize);
                fm = j2.getFontMetrics(font);
                textWidth = fm.stringWidth(text);
            }
            if (fontSize != 0) {
                this.setFont(font);
                this.setText(text);
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (!this.transparentBackgroundLabel && this.gradientColorLabel != null) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColorLabel, true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
    }
}

