/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import tico.interpreter.TInterpreterConstants;

public class TInterpreterCell
extends JButton {
    private static final int VERTICAL_ICON_MARGIN = 15;
    private static final int HORIZONTAL_ICON_MARGIN = 10;
    private static final int GAP_ICON_TEXT = 5;
    public Font font;
    public Color textColor;
    public int verticalTextPosition;
    public ImageIcon icon;
    public float borderSize;
    public Color borderColor;
    public Color backgroundColor;
    public Color gradientColor;
    public boolean transparentBackground;
    public boolean transparentBorder;
    public boolean accumulated;
    public String textAreaToSend = null;
    public int timeSending;
    public String textToSend;
    public int altBorderSize;
    public Color altBorderColor = null;
    private ImageIcon alternativeIcon = null;
    public String boardToGo = null;
    public String soundPath = null;
    public String alternativeSoundPath = null;
    public String videoPath = null;
    public String videoURL = null;
    public int xVideo = -1;
    public int yVideo = -1;
    public String command = null;
    public Point center = new Point();
    private int synthMode = 0;
    private String voiceName = null;
    private String voiceText = null;

    public float getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int borderSize) {
        this.borderSize = borderSize;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Point getCenter() {
        return this.center;
    }

    public int getSynthMode() {
        return this.synthMode;
    }

    public void setSynthMode(int mode) {
        this.synthMode = mode;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVoiceName(String voiceName) {
        this.voiceName = voiceName;
    }

    public String getVoiceText() {
        return this.voiceText;
    }

    public void setVoiceText(String voiceText) {
        this.voiceText = voiceText;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isTransparentBorder() {
        return this.transparentBorder;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setAccumulated(boolean accumulated) {
        this.accumulated = accumulated;
    }

    public boolean isAccumulated() {
        return this.accumulated;
    }

    public String getTextAreaToSend() {
        return this.textAreaToSend;
    }

    public void setTextAreaToSend(String textArea) {
        this.textAreaToSend = textArea;
    }

    public int getTimeSending() {
        return this.timeSending;
    }

    public void setTimeSending(int timeSending) {
        this.timeSending = timeSending;
    }

    public String getTextToSend() {
        return this.textToSend;
    }

    public void setTextToSend(String textToSend) {
        this.textToSend = textToSend;
    }

    public int getAlternativeBorderSize() {
        return this.altBorderSize;
    }

    public void setAlternativeBorderSize(int borderSize) {
        this.altBorderSize = borderSize;
    }

    public Color getAlternativeBorderColor() {
        return this.altBorderColor;
    }

    public void setAlternativeBorderColor(Color borderColor) {
        this.altBorderColor = borderColor;
    }

    public ImageIcon getAlternativeIcon() {
        return this.alternativeIcon;
    }

    public void setAlternativeIcon(ImageIcon icon) {
        this.alternativeIcon = icon;
    }

    public ImageIcon getDefaultIcon() {
        return this.icon;
    }

    public void setDefaultIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getBoardToGo() {
        return this.boardToGo;
    }

    public void setBoardToGo(String boardToGo) {
        this.boardToGo = boardToGo;
    }

    public String getSoundPath() {
        return this.soundPath;
    }

    public String getAlternativeSoundPath() {
        return this.alternativeSoundPath;
    }

    public void setAlternativeSoundPath(String alternativeSoundPath) {
        this.alternativeSoundPath = alternativeSoundPath;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    public String getVideoURL() {
        return this.videoURL;
    }

    public int getXVideo() {
        return this.xVideo;
    }

    public void setXVideo(int xVideo) {
        this.xVideo = xVideo;
    }

    public int getYVideo() {
        return this.yVideo;
    }

    public void setYVideo(int yVideo) {
        this.yVideo = yVideo;
    }

    public TInterpreterCell setAttributes(String id, Rectangle bounds, String text, Font font, Color textColor, int verticalTextPosition, ImageIcon icon, float borderSize, Color borderColor, Color backgroundColor, Color gradientColor, boolean transBackground, boolean transBorder, ImageIcon alternativeIcon) {
        this.setName(id);
        this.setBounds(bounds);
        this.setText(text);
        this.setFont(font);
        this.setForeground(textColor);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(verticalTextPosition);
        this.setHorizontalTextPosition(0);
        int cellTextSpace = (int)(bounds.getWidth() - (double)(2.0f * borderSize) - 20.0);
        JButton j2 = new JButton();
        j2.setSize(cellTextSpace, cellTextSpace);
        FontMetrics fm = j2.getFontMetrics(font);
        int textWidth = fm.stringWidth(text);
        if (textWidth > cellTextSpace) {
            int fontSize = font.getSize();
            int fontStyle = font.getStyle();
            String fontName = font.getFontName();
            while (textWidth > cellTextSpace && fontSize > 0) {
                font = new Font(fontName, fontStyle, --fontSize);
                fm = j2.getFontMetrics(font);
                textWidth = fm.stringWidth(text);
            }
            if (fontSize != 0) {
                this.setFont(font);
                this.setText(text);
            }
        }
        if (icon != null) {
            int maxImageWidth = (int)((float)bounds.width - 2.0f * (borderSize + 10.0f));
            int maxImageHeight = (int)((float)bounds.height - 2.0f * (borderSize + 15.0f));
            if (verticalTextPosition != 0 && !text.equals("")) {
                this.setIconTextGap(5);
                maxImageWidth = bounds.width - 2 * (10 + (int)borderSize) - 5;
                maxImageHeight = bounds.height - 2 * (15 + (int)borderSize) - 5 - font.getSize();
            }
            if (icon.getIconHeight() > maxImageHeight) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            if (icon.getIconWidth() > maxImageWidth) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            this.setIcon(icon);
        }
        this.icon = icon;
        this.borderSize = borderSize;
        this.borderColor = borderColor;
        this.backgroundColor = backgroundColor;
        this.gradientColor = gradientColor;
        this.transparentBackground = transBackground;
        this.transparentBorder = transBorder;
        if (this.transparentBackground) {
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
        } else {
            this.setOpaque(true);
            this.setBackground(backgroundColor);
        }
        if (this.transparentBorder) {
            this.setBorderPainted(false);
        } else {
            this.setBorder(new LineBorder(borderColor, (int)borderSize));
        }
        if (alternativeIcon != null) {
            int textPosition = verticalTextPosition;
            int maxAImageWidth = bounds.width - 2 * ((int)borderSize + 10);
            int maxAImageHeight = bounds.height - 2 * ((int)borderSize + 15);
            if (textPosition != 0 && !text.equals("")) {
                this.setIconTextGap(5);
                maxAImageWidth = bounds.width - 2 * (10 + (int)borderSize) - 5;
                maxAImageHeight = bounds.height - 2 * (15 + (int)borderSize) - 5 - font.getSize();
            }
            if (alternativeIcon.getIconHeight() > maxAImageHeight) {
                alternativeIcon = new ImageIcon(alternativeIcon.getImage().getScaledInstance(-1, maxAImageHeight, 4));
            }
            if (alternativeIcon.getIconWidth() > maxAImageWidth) {
                alternativeIcon = new ImageIcon(alternativeIcon.getImage().getScaledInstance(maxAImageWidth, -1, 4));
            }
            this.alternativeIcon = alternativeIcon;
        }
        return this;
    }

    public TInterpreterCell setActionsAttributes(String soundPath, String videoPath, String videoURL, String command, String voiceName, String voiceText, int synthMode) {
        this.soundPath = soundPath;
        this.videoPath = videoPath;
        this.videoURL = videoURL;
        this.command = command;
        this.voiceName = voiceName;
        this.voiceText = voiceText;
        this.synthMode = synthMode;
        return this;
    }

    public TInterpreterCell setAttributes2(String id, Rectangle bounds, String texto, Font f2, Color textColor, ImageIcon icon) {
        this.textColor = textColor;
        this.font = f2;
        this.borderSize = 1.0f;
        this.borderColor = TInterpreterConstants.BORDER_COLOR;
        this.setName(id);
        this.setForeground(textColor);
        this.setText(texto);
        this.setBounds(bounds);
        this.setBackground(TInterpreterConstants.BACKGROUND_COLOR);
        this.setBorder(new LineBorder(TInterpreterConstants.BORDER_COLOR, 1));
        this.setFont(f2);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        if (icon != null) {
            this.setIconTextGap(5);
            int maxImageWidth = bounds.width - 22 - 5;
            int maxImageHeight = bounds.height - 32 - 5 - f2.getSize();
            if (icon.getIconHeight() > maxImageHeight) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            if (icon.getIconWidth() > maxImageWidth) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            this.setIcon(icon);
        }
        this.icon = icon;
        return this;
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (!this.transparentBackground && this.gradientColor != null) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
    }
}

