/*
 * Decompiled with CFR 0.152.
 */
package tico.interpreter.components;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import tico.interpreter.components.TInterpreterCell;

public class TInterpreterAccumulatedCell
extends JButton {
    private static final int VERTICAL_ICON_MARGIN = 10;
    private static final int HORIZONTAL_ICON_MARGIN = 10;
    private static final int GAP_ICON_TEXT = 5;
    private String sound = null;
    private String voiceText = null;
    private String voiceName = null;
    private int synthMode = 0;

    public String getVoiceText() {
        return this.voiceText;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public int getSynthMode() {
        return this.synthMode;
    }

    public TInterpreterAccumulatedCell setAttributes(TInterpreterCell cell) {
        this.setForeground(cell.getForeground());
        this.setBorder(new LineBorder(cell.getBorderColor(), (int)cell.getBorderSize()));
        this.sound = cell.getSoundPath();
        this.setSize(90, 90);
        this.setContentAreaFilled(false);
        this.voiceText = cell.getVoiceText();
        this.voiceName = cell.getVoiceName();
        this.synthMode = cell.getSynthMode();
        this.setText(cell.getText());
        this.setOpaque(true);
        this.setBackground(cell.getBackground());
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(cell.getVerticalTextPosition());
        this.setHorizontalTextPosition(0);
        if (cell.getIcon() != null) {
            int textPosition = cell.getVerticalTextPosition();
            ImageIcon icon = (ImageIcon)cell.getIcon();
            int maxImageWidth = (int)((float)this.getWidth() - 2.0f * (cell.getBorderSize() + 10.0f));
            int maxImageHeight = (int)((float)this.getHeight() - 2.0f * (cell.getBorderSize() + 10.0f));
            if (textPosition != 0 && !cell.getText().equals("")) {
                this.setIconTextGap(5);
                maxImageWidth = this.getWidth() - 2 * (10 + (int)cell.getBorderSize()) - 5;
                maxImageHeight = this.getHeight() - 2 * (10 + (int)cell.getBorderSize()) - 5 - cell.getFont().getSize();
            }
            if (cell.getIcon().getIconHeight() > maxImageHeight) {
                icon = new ImageIcon(cell.getDefaultIcon().getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            if (cell.getIcon().getIconWidth() > maxImageWidth) {
                icon = new ImageIcon(cell.getDefaultIcon().getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            this.setIcon(icon);
        }
        return this;
    }

    public String getSound() {
        return this.sound;
    }
}

